/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Point2D;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B#\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006\"\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u000fJ\u0019\u0010\u0010\u001a\u00020\u00112\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016R\u0018\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\tR\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0016"}, d2={"Lorg/mkui/geom/Segment;", "", "()V", "type", "", "points", "", "Lorg/mkui/geom/Point2D;", "(I[Lorg/mkui/geom/Point2D;)V", "[Lorg/mkui/geom/Point2D;", "getType", "()I", "setType", "(I)V", "getPoints", "()[Lorg/mkui/geom/Point2D;", "setPoints", "", "([Lorg/mkui/geom/Point2D;)V", "toString", "", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class Segment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int type;
    @Nullable
    private Point2D[] points;
    public static final int $stable = 8;
    public static final int MOVE_TO = 0;
    public static final int LINE_TO = 1;
    public static final int QUAD_TO = 2;
    public static final int CUBIC_TO = 3;
    public static final int CLOSE = 4;

    public final int getType() {
        return this.type;
    }

    public final void setType(int n) {
        this.type = n;
    }

    public Segment() {
    }

    public Segment(int type, Point2D ... points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        switch (type) {
            case 0: {
                if (points.length == 1) break;
                boolean $i$a$-require-Segment$62 = false;
                String $i$a$-require-Segment$62 = "A Segment of type MOVE_TO has to be associate with exactly 1 point: new Segment(" + type + ", " + points + ")";
                throw new IllegalArgumentException($i$a$-require-Segment$62.toString());
            }
            case 1: {
                if (points.length == 1) break;
                boolean $i$a$-require-Segment$72 = false;
                String $i$a$-require-Segment$72 = "A Segment of type LINE_TO has to be associate with exactly 1 point: new Segment(" + type + ", " + points + ")";
                throw new IllegalArgumentException($i$a$-require-Segment$72.toString());
            }
            case 2: {
                if (points.length == 2) break;
                boolean $i$a$-require-Segment$82 = false;
                String $i$a$-require-Segment$82 = "A Segment of type QUAD_TO has to be associate with exactly 2 points: new Segment(" + type + ", " + points + ")";
                throw new IllegalArgumentException($i$a$-require-Segment$82.toString());
            }
            case 3: {
                if (points.length == 3) break;
                boolean $i$a$-require-Segment$92 = false;
                String $i$a$-require-Segment$92 = "A Segment of type CUBIC_TO has to be associate with exactly 3 point: new Segment(" + type + ", " + points + ")";
                throw new IllegalArgumentException($i$a$-require-Segment$92.toString());
            }
            case 4: {
                if (!(!(points.length == 0))) break;
                boolean bl = false;
                String string = "A Segment of type CLOSE is not to be associated with any points: new Segment(" + type + ", " + points + ")";
                throw new IllegalArgumentException(string.toString());
            }
            default: {
                throw new IllegalArgumentException("You can only create Segments of types MOVE_TO, LINE_TO, QUAD_TO, or CUBIC_TO: new Segment(" + type + ", " + points + ")");
            }
        }
        this.type = type;
        this.points = Arrays.copyOf(points, points.length);
    }

    @Nullable
    public final Point2D[] getPoints() {
        return this.points;
    }

    public final void setPoints(@NotNull Point2D[] points) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        this.points = points;
    }

    @NotNull
    public String toString() {
        Object[] objectArray = new Object[]{this.points};
        return "Segment{type=" + this.type + ", points=" + com.macrofocus.common.collection.Arrays.INSTANCE.toString(objectArray) + "}";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lorg/mkui/geom/Segment$Companion;", "", "()V", "CLOSE", "", "CUBIC_TO", "LINE_TO", "MOVE_TO", "QUAD_TO", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

