/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.curve.BinaryCurveApproximationAlgorithm;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ParametricCurve;
import org.mkui.geom.curve.ValueVector;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\n\b\u0007\u0018\u0000 /2\u00020\u0001:\u0001/B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\bH\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J(\u0010 \u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u001d2\u0006\u0010%\u001a\u00020&H\u0016J\u0006\u0010'\u001a\u00020\bJ\u0006\u0010(\u001a\u00020\bJ\b\u0010)\u001a\u0004\u0018\u00010\u0014J\b\u0010*\u001a\u00020\u001dH\u0016J\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\bJ\u000e\u0010,\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\bJ\u0010\u0010-\u001a\u00020\u001d2\b\u0010.\u001a\u0004\u0018\u00010\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u00060"}, d2={"Lorg/mkui/geom/curve/LagrangeCurve;", "Lorg/mkui/geom/curve/ParametricCurve;", "cp", "Lorg/mkui/geom/curve/ControlPath;", "gi", "Lorg/mkui/geom/curve/GroupIterator;", "(Lorg/mkui/geom/curve/ControlPath;Lorg/mkui/geom/curve/GroupIterator;)V", "baseIndex", "", "baseLength", "interpolateFirst", "", "getInterpolateFirst", "()Z", "setInterpolateFirst", "(Z)V", "interpolateLast", "getInterpolateLast", "setInterpolateLast", "knotVector", "Lorg/mkui/geom/curve/ValueVector;", "sampleLimit", "getSampleLimit", "()I", "L", "", "t", "i", "appendTo", "", "mp", "Lorg/mkui/geom/curve/MultiPath;", "doBCAA", "t1", "t2", "b", "eval", "p", "", "getBaseIndex", "getBaseLength", "getKnotVector", "resetMemory", "setBaseIndex", "setBaseLength", "setKnotVector", "v", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class LagrangeCurve
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ValueVector knotVector;
    private int baseIndex;
    private int baseLength;
    private boolean interpolateFirst;
    private boolean interpolateLast;
    public static final int $stable = 8;
    @NotNull
    private static double[][] pt = new double[0][];

    public LagrangeCurve(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
        double[] dArray = new double[]{0.0, 0.3333333333333333, 0.6666666666666666, 1.0};
        this.knotVector = new ValueVector(dArray, 4);
        this.baseIndex = 1;
        this.baseLength = 1;
    }

    public final boolean getInterpolateFirst() {
        return this.interpolateFirst;
    }

    public final void setInterpolateFirst(boolean bl) {
        this.interpolateFirst = bl;
    }

    public final boolean getInterpolateLast() {
        return this.interpolateLast;
    }

    public final void setInterpolateLast(boolean bl) {
        this.interpolateLast = bl;
    }

    public final int getBaseIndex() {
        return this.baseIndex;
    }

    public final void setBaseIndex(int b) {
        this.baseIndex = b;
    }

    public final int getBaseLength() {
        return this.baseLength;
    }

    public final void setBaseLength(int b) {
        this.baseLength = b;
    }

    @Nullable
    public final ValueVector getKnotVector() {
        return this.knotVector;
    }

    public final void setKnotVector(@Nullable ValueVector v) {
        this.knotVector = v;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        ValueVector valueVector = this.knotVector;
        Intrinsics.checkNotNull((Object)valueVector);
        if (this.baseIndex + this.baseLength >= valueVector.size()) {
            return;
        }
        int n = ((Object[])pt).length;
        ValueVector valueVector2 = this.knotVector;
        Intrinsics.checkNotNull((Object)valueVector2);
        if (n < valueVector2.size()) {
            ValueVector valueVector3 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector3);
            pt = new double[2 * valueVector3.size()][];
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        groupIterator2.set(0, 0);
        boolean b = false;
        if (this.baseIndex != 0 && this.interpolateFirst) {
            ValueVector valueVector4 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector4);
            int n2 = valueVector4.size();
            for (int i = 0; i < n2; ++i) {
                GroupIterator groupIterator3 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator3);
                if (!groupIterator3.hasNext()) {
                    return;
                }
                ControlPath controlPath2 = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath2);
                GroupIterator groupIterator4 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator4);
                LagrangeCurve.pt[i] = controlPath2.getPoint(groupIterator4.next()).getLocation();
            }
            ValueVector valueVector5 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector5);
            double d = valueVector5.get(0);
            ValueVector valueVector6 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector6);
            b = this.doBCAA(mp, d, valueVector6.get(this.baseIndex), b);
        }
        GroupIterator groupIterator5 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator5);
        groupIterator5.set(0, 0);
        int last_i = 0;
        int last_j = 0;
        while (true) {
            GroupIterator groupIterator6 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator6);
            int temp_i = groupIterator6.index_i();
            GroupIterator groupIterator7 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator7);
            int temp_j = groupIterator7.count_j();
            int index_i = 0;
            int count_j = 0;
            int j = 0;
            int i = 0;
            while (true) {
                ValueVector valueVector7 = this.knotVector;
                Intrinsics.checkNotNull((Object)valueVector7);
                if (j >= valueVector7.size()) break;
                if (i == this.baseLength) {
                    GroupIterator groupIterator8 = this.getGi();
                    Intrinsics.checkNotNull((Object)groupIterator8);
                    index_i = groupIterator8.index_i();
                    GroupIterator groupIterator9 = this.getGi();
                    Intrinsics.checkNotNull((Object)groupIterator9);
                    count_j = groupIterator9.count_j();
                }
                GroupIterator groupIterator10 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator10);
                if (!groupIterator10.hasNext()) break;
                ControlPath controlPath3 = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath3);
                GroupIterator groupIterator11 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator11);
                LagrangeCurve.pt[j] = controlPath3.getPoint(groupIterator11.next()).getLocation();
                ++i;
                ++j;
            }
            ValueVector valueVector8 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector8);
            if (j < valueVector8.size()) break;
            GroupIterator groupIterator12 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator12);
            groupIterator12.set(index_i, count_j);
            last_i = temp_i;
            last_j = temp_j;
            ValueVector valueVector9 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector9);
            double d = valueVector9.get(this.baseIndex);
            ValueVector valueVector10 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector10);
            b = this.doBCAA(mp, d, valueVector10.get(this.baseIndex + this.baseLength), b);
        }
        ValueVector valueVector11 = this.knotVector;
        Intrinsics.checkNotNull((Object)valueVector11);
        if (this.baseIndex + this.baseLength < valueVector11.size() - 1 && this.interpolateLast) {
            GroupIterator groupIterator13 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator13);
            groupIterator13.set(last_i, last_j);
            ValueVector valueVector12 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector12);
            int n3 = valueVector12.size();
            for (int i = 0; i < n3; ++i) {
                GroupIterator groupIterator14 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator14);
                if (!groupIterator14.hasNext()) {
                    System.out.println((Object)"not enough points to interpolate last");
                    return;
                }
                ControlPath controlPath4 = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath4);
                GroupIterator groupIterator15 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator15);
                LagrangeCurve.pt[i] = controlPath4.getPoint(groupIterator15.next()).getLocation();
            }
            ValueVector valueVector13 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector13);
            double d = valueVector13.get(this.baseIndex + this.baseLength);
            ValueVector valueVector14 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector14);
            ValueVector valueVector15 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector15);
            this.doBCAA(mp, d, valueVector14.get(valueVector15.size() - 1), b);
        }
    }

    private final boolean doBCAA(MultiPath mp, double t1, double t2, boolean b) {
        double t12 = t1;
        double t22 = t2;
        boolean b2 = b;
        if (t22 < t12) {
            double temp = t12;
            t12 = t22;
            t22 = temp;
        }
        if (!b2) {
            b2 = true;
            double[] d = new double[mp.getDimension() + 1];
            d[mp.getDimension()] = t12;
            this.eval(d);
            if (this.getConnect()) {
                mp.lineTo(d);
            } else {
                mp.moveTo(d);
            }
        }
        BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, t12, t22, mp);
        return b2;
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        ValueVector valueVector = this.knotVector;
        Intrinsics.checkNotNull((Object)valueVector);
        int n = valueVector.size();
        for (int i = 0; i < n; ++i) {
            double[] q = pt[i];
            double L = this.L(t, i);
            int n2 = p.length - 1;
            for (int j = 0; j < n2; ++j) {
                int n3 = j;
                double d = p[n3];
                Intrinsics.checkNotNull((Object)q);
                p[n3] = d + q[j] * L;
            }
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    private final double L(double t, int i) {
        double d = 1.0;
        ValueVector valueVector = this.knotVector;
        Intrinsics.checkNotNull((Object)valueVector);
        int n = valueVector.size();
        for (int j = 0; j < n; ++j) {
            ValueVector valueVector2 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector2);
            double d2 = valueVector2.get(i);
            ValueVector valueVector3 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector3);
            double e = d2 - valueVector3.get(j);
            if (e == 0.0) continue;
            ValueVector valueVector4 = this.knotVector;
            Intrinsics.checkNotNull((Object)valueVector4);
            d *= (t - valueVector4.get(j)) / e;
        }
        return d;
    }

    @Override
    public void resetMemory() {
        if (!(((Object[])pt).length == 0)) {
            pt = new double[0][];
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/mkui/geom/curve/LagrangeCurve$Companion;", "", "()V", "pt", "", "", "[[D", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

