/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.labeling;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.mkui.color.MkColor;
import org.mkui.color.MkColorKt;
import org.mkui.color.crossplatform.CPColorKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\u001a\u001e\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\u0001H\u0002\u001a\u0014\u0010\r\u001a\u00020\b*\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u0001H\u0002\u001a\f\u0010\u000f\u001a\u00020\f*\u00020\u0001H\u0002\u001a\f\u0010\u0010\u001a\u00020\b*\u00020\u0001H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0012\u001a\u00020\fH\u0002\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0011\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\u00a8\u0006\u0013"}, d2={"Black", "Lorg/mkui/color/MkColor;", "getBlack", "()Lorg/mkui/color/MkColor;", "White", "getWhite", "getHSBColor", "h", "", "s", "b", "brightness", "", "diff", "background", "lum", "luminance", "replaceBrightness", "min", "mkui"})
public final class EnhancedLabelKt {
    @NotNull
    private static final MkColor Black = MkColorKt.colorOf-bW95L_I((byte)0, (byte)0, (byte)0, (byte)-1);
    @NotNull
    private static final MkColor White = MkColorKt.colorOf-bW95L_I((byte)-1, (byte)-1, (byte)-1, (byte)-1);

    private static final MkColor replaceBrightness(MkColor $this$replaceBrightness, double min) {
        float[] hsb = CPColorKt.RGBtoHSB(MkColorKt.getURed($this$replaceBrightness) & 0xFF, MkColorKt.getUGreen($this$replaceBrightness) & 0xFF, MkColorKt.getUBlue($this$replaceBrightness) & 0xFF, null);
        return EnhancedLabelKt.getHSBColor(hsb[0], hsb[1], (float)min);
    }

    @NotNull
    public static final MkColor getHSBColor(float h, float s, float b) {
        return MkColorKt.colorOf(CPColorKt.HSBtoRGB(h, s, b));
    }

    private static final double brightness(MkColor $this$brightness) {
        float[] hsb = CPColorKt.RGBtoHSB(MkColorKt.getURed($this$brightness) & 0xFF, MkColorKt.getUGreen($this$brightness) & 0xFF, MkColorKt.getUBlue($this$brightness) & 0xFF, null);
        return hsb[2];
    }

    private static final double lum(MkColor $this$lum) {
        int r = MkColorKt.getURed($this$lum) & 0xFF;
        int g2 = MkColorKt.getUGreen($this$lum) & 0xFF;
        int b = MkColorKt.getUBlue($this$lum) & 0xFF;
        return 0.299 * (double)r + 0.587 * (double)g2 + 0.114 * (double)b;
    }

    private static final float luminance(MkColor $this$luminance) {
        int r = MkColorKt.getURed($this$luminance) & 0xFF;
        int g2 = MkColorKt.getUGreen($this$luminance) & 0xFF;
        int b = MkColorKt.getUBlue($this$luminance) & 0xFF;
        return (0.299f * (float)r + 0.587f * (float)g2 + 0.114f * (float)b) / 255.0f;
    }

    private static final float diff(MkColor $this$diff, MkColor background) {
        int r = Math.abs((MkColorKt.getURed($this$diff) & 0xFF) - (MkColorKt.getURed(background) & 0xFF));
        int g2 = Math.abs((MkColorKt.getUGreen($this$diff) & 0xFF) - (MkColorKt.getUGreen(background) & 0xFF));
        int b = Math.abs((MkColorKt.getUBlue($this$diff) & 0xFF) - (MkColorKt.getUBlue(background) & 0xFF));
        return (float)Math.max(r, Math.max(g2, b)) / 255.0f;
    }

    @NotNull
    public static final MkColor getBlack() {
        return Black;
    }

    @NotNull
    public static final MkColor getWhite() {
        return White;
    }

    public static final /* synthetic */ float access$diff(MkColor $receiver, MkColor background) {
        return EnhancedLabelKt.diff($receiver, background);
    }

    public static final /* synthetic */ double access$brightness(MkColor $receiver) {
        return EnhancedLabelKt.brightness($receiver);
    }

    public static final /* synthetic */ MkColor access$replaceBrightness(MkColor $receiver, double min) {
        return EnhancedLabelKt.replaceBrightness($receiver, min);
    }

    public static final /* synthetic */ float access$luminance(MkColor $receiver) {
        return EnhancedLabelKt.luminance($receiver);
    }

    public static final /* synthetic */ double access$lum(MkColor $receiver) {
        return EnhancedLabelKt.lum($receiver);
    }
}

