/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColor;
import org.mkui.color.MkColorKt;
import org.mkui.palette.AbstractPalette;
import org.mkui.palette.Cycle;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u0000 02\u00020\u00012\u00020\u0002:\u00010B\u0013\b\u0016\u0012\n\u0010\u0003\u001a\u00020\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u001b\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\u0003\u001a\u00020\u0004\"\u00020\u0005\u00a2\u0006\u0002\u0010\tB\u001b\b\u0016\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\fB#\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0012\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000b0\n\"\u00020\u000b\u00a2\u0006\u0002\u0010\rB\u0015\b\u0016\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0002\u0010\u000fB\u001b\u0012\u0006\u0010\u0010\u001a\u00020\b\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000e\u00a2\u0006\u0002\u0010\u0011J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u001dH\u0016J\u0010\u0010+\u001a\u00020\u000b2\u0006\u0010,\u001a\u00020\u0005H\u0016J\u0010\u0010-\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010.\u001a\u00020/H\u0016R \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u000fR(\u0010\u0017\u001a\u0004\u0018\u00010\u00162\b\u0010\u0015\u001a\u0004\u0018\u00010\u00168V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0010\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010 \"\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020\u001d8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001f\u00a8\u00061"}, d2={"Lorg/mkui/palette/FixedPalette;", "Lorg/mkui/palette/AbstractPalette;", "Lorg/mkui/palette/MutablePalette;", "colors", "", "", "([I)V", "inverted", "", "(Z[I)V", "", "Lorg/mkui/color/MkColor;", "([Lorg/mkui/color/MkColor;)V", "(Z[Lorg/mkui/color/MkColor;)V", "", "(Ljava/util/List;)V", "isInverted", "(ZLjava/util/List;)V", "getColors", "()Ljava/util/List;", "setColors", "value", "Lorg/mkui/palette/Cycle;", "cycle", "getCycle", "()Lorg/mkui/palette/Cycle;", "setCycle", "(Lorg/mkui/palette/Cycle;)V", "highestFraction", "", "getHighestFraction", "()D", "()Z", "setInverted", "(Z)V", "lowestFraction", "getLowestFraction", "addPaletteListener", "", "listener", "Lorg/mkui/palette/PaletteListener;", "getColor", "fraction", "getColorAt", "index", "removePaletteListener", "toString", "", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public class FixedPalette
extends AbstractPalette
implements MutablePalette {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isInverted;
    @NotNull
    private List<MkColor> colors;
    public static final int $stable = 8;

    public FixedPalette(boolean isInverted, @NotNull List<MkColor> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.isInverted = isInverted;
        this.colors = colors;
        this.setColorCount(this.colors != null ? this.colors.size() : 0);
    }

    @Override
    public boolean isInverted() {
        return this.isInverted;
    }

    public void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    @NotNull
    public final List<MkColor> getColors() {
        return this.colors;
    }

    public final void setColors(@NotNull List<MkColor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colors = list;
    }

    public FixedPalette(int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(false, Arrays.copyOf(colors, colors.length));
    }

    public FixedPalette(boolean inverted, int ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(false, FixedPalette.Companion.toCPColorList(colors));
    }

    public FixedPalette(MkColor ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(false, ArraysKt.toMutableList((Object[])colors));
    }

    public FixedPalette(boolean inverted, MkColor ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this(inverted, ArraysKt.toMutableList((Object[])colors));
    }

    public FixedPalette(@NotNull List<MkColor> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this(false, colors);
    }

    @Override
    @NotNull
    public MkColor getColor(double fraction) {
        MkColor mkColor;
        double fraction2 = fraction;
        boolean inverted = this.isInverted();
        Cycle cycle = this.getCycle();
        switch (cycle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cycle.ordinal()]) {
            case 1: {
                inverted = (int)fraction2 % 2 == 0;
                fraction2 -= (double)((int)fraction2);
                break;
            }
            case 2: {
                fraction2 -= (double)((int)fraction2);
                break;
            }
            default: {
            }
        }
        if (fraction2 < this.getLowestFraction()) {
            mkColor = this.getColor(this.getLowestFraction());
        } else if (fraction2 > this.getHighestFraction()) {
            mkColor = this.getColor(this.getHighestFraction());
        } else {
            int index = this.getEntry(!inverted ? fraction2 : 1.0 - fraction2, this.getColorCount(), this.colors.size());
            mkColor = this.colors.get(index);
        }
        return mkColor;
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    @Override
    @NotNull
    public MkColor getColorAt(int index) {
        return this.getColorCount() == this.colors.size() ? (index < 0 ? this.getColorAt(0) : (index > this.getColorCount() - 1 ? this.getColorAt(this.getColorCount() - 1) : this.colors.get(index))) : this.getColor((double)this.getColorCount() / (double)index);
    }

    @Override
    public void addPaletteListener(@NotNull PaletteListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Override
    public void removePaletteListener(@NotNull PaletteListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
    }

    @Override
    @Nullable
    public Cycle getCycle() {
        return super.getCycle();
    }

    @Override
    public void setCycle(@Nullable Cycle value) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public String toString() {
        return this.getColor(0.0) + "-" + this.getColor(1.0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lorg/mkui/palette/FixedPalette$Companion;", "", "()V", "toCPColorList", "", "Lorg/mkui/color/MkColor;", "colors", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final List<MkColor> toCPColorList(int[] colors) {
            List list = new ArrayList(colors.length);
            for (int color : colors) {
                list.add(MkColorKt.colorOf(color));
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Cycle.values().length];
            try {
                nArray[Cycle.REFLECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Cycle.REPEAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

