/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.rubberband;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SimpleSingleSelection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.rubberband.RubberBand;
import org.mkui.transform.TwoDScreenTransform;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000eH\u0016J\u0018\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u000e\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007R\u001c\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/mkui/rubberband/ScreenTransformRubberBand;", "Lorg/mkui/rubberband/RubberBand;", "screenTransform", "Lorg/mkui/transform/TwoDScreenTransform;", "(Lorg/mkui/transform/TwoDScreenTransform;)V", "rubberBand", "Lcom/macrofocus/common/selection/MutableSingleSelection;", "Lorg/mkui/geom/Rectangle2D;", "getRubberBand", "()Lcom/macrofocus/common/selection/MutableSingleSelection;", "rubberBandScreen", "getRubberBandScreen", "()Lorg/mkui/geom/Rectangle2D;", "startRubberBand", "", "x", "", "y", "stopRubberBand", "stretchRubberBand", "worldToScreen", "r", "mkui"})
@StabilityInferred(parameters=0)
public final class ScreenTransformRubberBand
implements RubberBand {
    @NotNull
    private final MutableSingleSelection<Rectangle2D> rubberBand;
    @NotNull
    private final TwoDScreenTransform screenTransform;
    public static final int $stable = 8;

    public ScreenTransformRubberBand(@NotNull TwoDScreenTransform screenTransform) {
        Intrinsics.checkNotNullParameter((Object)screenTransform, (String)"screenTransform");
        this.rubberBand = (MutableSingleSelection)new SimpleSingleSelection(null);
        this.screenTransform = screenTransform;
    }

    @NotNull
    public MutableSingleSelection<Rectangle2D> getRubberBand() {
        return this.rubberBand;
    }

    @Override
    public void startRubberBand(int x, int y) {
        double xWorld = this.screenTransform.getX().screenToWorld(x);
        double yWorld = this.screenTransform.getY().screenToWorld(y);
        this.getRubberBand().setSelected((Object)new Rectangle2D.Double(xWorld, yWorld, 0.0, 0.0));
    }

    @Override
    public void stretchRubberBand(int x, int y) {
        if (this.getRubberBand().isActive()) {
            double xWorld = this.screenTransform.getX().screenToWorld(x);
            double yWorld = this.screenTransform.getY().screenToWorld(y);
            Object object = this.getRubberBand().getSelected();
            Intrinsics.checkNotNull((Object)object);
            Rectangle2D r = (Rectangle2D)object;
            this.getRubberBand().setSelected((Object)new Rectangle2D.Double(r.getX(), r.getY(), xWorld - r.getX(), yWorld - r.getY()));
        }
    }

    @Override
    public void stopRubberBand() {
        this.getRubberBand().clearSelection();
    }

    @Override
    @Nullable
    public Rectangle2D getRubberBandScreen() {
        Rectangle2D rectangle2D;
        if (this.getRubberBand().isActive()) {
            Object object = this.getRubberBand().getSelected();
            Intrinsics.checkNotNull((Object)object);
            rectangle2D = this.worldToScreen((Rectangle2D)object).normalize();
        } else {
            rectangle2D = null;
        }
        return rectangle2D;
    }

    @NotNull
    public final Rectangle2D worldToScreen(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        int x1 = (int)Math.rint(this.screenTransform.getX().worldToScreenPrecise(r.getMinX()));
        int x2 = (int)Math.rint(this.screenTransform.getX().worldToScreenPrecise(r.getMaxX()));
        int y1 = (int)Math.rint(this.screenTransform.getY().worldToScreenPrecise(r.getMinY()));
        int y2 = (int)Math.rint(this.screenTransform.getY().worldToScreenPrecise(r.getMaxY()));
        int width = x2 - x1;
        int height = y2 - y1;
        return new Rectangle(x1, y1, width, height);
    }
}

