/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.font;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontStyle;
import org.jetbrains.skia.Typeface;
import org.mkui.font.MkFontKt;
import org.mkui.font.Weight;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00060\u0004j\u0002`\u0005J(\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ(\u0010\u0006\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\r\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0018\u0010\u000e\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\bJ(\u0010\u0010\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\b2\u000e\u0010\u0011\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005\u00a8\u0006\u0013"}, d2={"Lorg/mkui/font/CPFontFactory;", "", "()V", "createDefaultFont", "Lorg/jetbrains/skia/Font;", "Lorg/mkui/font/MkFont;", "createFont", "family", "", "style", "", "size", "Lorg/mkui/font/Weight;", "createFontFamily", "decodeFont", "labelingFont", "decodeFontWithDefault", "defaultLabelingFont", "Companion", "mkui"})
@StabilityInferred(parameters=1)
public final class CPFontFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final CPFontFactory instance;

    @Nullable
    public final Font createFont(@Nullable String family, @NotNull Weight style, int size) {
        Intrinsics.checkNotNullParameter((Object)((Object)style), (String)"style");
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Nullable
    public final Font createFont(@Nullable String family, int style, int size) {
        Font font = new Font(Typeface.Companion.makeDefault());
        return MkFontKt.deriveFontSize(MkFontKt.deriveFontWeight(font, Weight.NORMAL), size);
    }

    @Nullable
    public final Font decodeFont(@Nullable String labelingFont) {
        int fontStyle;
        int fontSize;
        String fontName;
        block27: {
            int strlen;
            int styleIndex;
            int sizeIndex;
            char sepChar;
            block25: {
                String styleName;
                block24: {
                    String string = labelingFont;
                    Intrinsics.checkNotNull((Object)string);
                    fontName = string;
                    styleName = "";
                    fontSize = 12;
                    fontStyle = FontStyle.Companion.getNORMAL().get_value();
                    int lastHyphen = StringsKt.lastIndexOf$default((CharSequence)labelingFont, (char)'-', (int)0, (boolean)false, (int)6, null);
                    int lastSpace = StringsKt.lastIndexOf$default((CharSequence)labelingFont, (char)' ', (int)0, (boolean)false, (int)6, null);
                    sepChar = lastHyphen > lastSpace ? (char)'-' : ' ';
                    sizeIndex = StringsKt.lastIndexOf$default((CharSequence)labelingFont, (char)sepChar, (int)0, (boolean)false, (int)6, null);
                    styleIndex = StringsKt.lastIndexOf$default((CharSequence)labelingFont, (char)sepChar, (int)(sizeIndex - 1), (boolean)false, (int)4, null);
                    strlen = labelingFont.length();
                    if (sizeIndex > 0 && sizeIndex + 1 < strlen) {
                        try {
                            String string2 = labelingFont.substring(sizeIndex + 1);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                            fontSize = Integer.valueOf(string2);
                            if (fontSize <= 0) {
                                fontSize = 12;
                            }
                        }
                        catch (NumberFormatException e) {
                            styleIndex = sizeIndex;
                            sizeIndex = strlen;
                            if (labelingFont.charAt(sizeIndex - 1) != sepChar) break block24;
                            --sizeIndex;
                        }
                    }
                }
                if (styleIndex < 0 || styleIndex + 1 >= strlen) break block25;
                String string = labelingFont.substring(styleIndex + 1, sizeIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String e = styleName = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = e.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                switch (string3) {
                    case "bolditalic": {
                        fontStyle = FontStyle.Companion.getBOLD().get_value() | FontStyle.Companion.getITALIC().get_value();
                        break;
                    }
                    case "italic": {
                        fontStyle = FontStyle.Companion.getITALIC().get_value();
                        break;
                    }
                    case "bold": {
                        fontStyle = FontStyle.Companion.getBOLD().get_value();
                        break;
                    }
                    case "plain": {
                        fontStyle = FontStyle.Companion.getNORMAL().get_value();
                        break;
                    }
                    default: {
                        styleIndex = sizeIndex;
                        if (labelingFont.charAt(styleIndex - 1) != sepChar) break;
                        --styleIndex;
                    }
                }
                String string4 = labelingFont.substring(0, styleIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
                fontName = string4;
                break block27;
            }
            int fontEnd = strlen;
            if (styleIndex > 0) {
                fontEnd = styleIndex;
            } else if (sizeIndex > 0) {
                fontEnd = sizeIndex;
            }
            if (fontEnd > 0 && labelingFont.charAt(fontEnd - 1) == sepChar) {
                --fontEnd;
            }
            String string = labelingFont.substring(0, fontEnd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            fontName = string;
        }
        return this.createFont(fontName, fontStyle, fontSize);
    }

    @Nullable
    public final Font createFontFamily(@Nullable String family) {
        return new Font(Typeface.Companion.makeDefault());
    }

    @Nullable
    public final Font decodeFontWithDefault(@Nullable String labelingFont, @Nullable Font defaultLabelingFont) {
        Font f = this.decodeFont(labelingFont);
        Font font = f;
        if (font == null) {
            font = defaultLabelingFont;
        }
        return font;
    }

    @NotNull
    public final Font createDefaultFont() {
        Font font = new Font(Typeface.Companion.makeDefault());
        return font;
    }

    static {
        instance = new CPFontFactory();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/mkui/font/CPFontFactory$Companion;", "", "()V", "instance", "Lorg/mkui/font/CPFontFactory;", "getInstance", "()Lorg/mkui/font/CPFontFactory;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CPFontFactory getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

