/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.math.MathKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Crossings;
import org.mkui.geom.Order0;
import org.mkui.geom.Order1;
import org.mkui.geom.Order2;
import org.mkui.geom.Order3;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0006\n\u0002\b\u001b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u001d\b'\u0018\u0000 T2\u00020\u0001:\u0001TB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH&J\u0010\u0010$\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH&J\u0010\u0010&\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH&J\u0010\u0010'\u001a\u00020\r2\u0006\u0010%\u001a\u00020\rH&J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/H\u0016J\b\u00100\u001a\u000201H\u0016J\u0018\u00102\u001a\u00020\u00032\u0006\u00103\u001a\u00020\r2\u0006\u0010#\u001a\u00020\rH\u0016J\u0018\u00104\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0003H&J\u0018\u00106\u001a\u00020\r2\u0006\u0010%\u001a\u00020\r2\u0006\u00105\u001a\u00020\u0003H&J\u0010\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H&J\u008e\u0001\u0010:\u001a\u00020)2\u0006\u0010-\u001a\u00020\u00002\u0006\u0010.\u001a\u00020/2\u0006\u0010;\u001a\u00020\r2\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u00032\u0006\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020\r2\u0006\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020\r2\u0006\u0010C\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\u0006\u0010E\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010G\u001a\u00020\r2\u0006\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020\rJ\u0010\u0010J\u001a\u00020\u00032\u0006\u0010K\u001a\u00020/H&J\u0016\u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\rJ \u0010L\u001a\u00020\u00002\u0006\u0010M\u001a\u00020\r2\u0006\u0010N\u001a\u00020\r2\u0006\u0010O\u001a\u00020\u0003H&J\u000e\u0010P\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u0018\u0010Q\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\u0006\u0010G\u001a\u00020\rH&J\u001e\u0010R\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\u0006\u0010F\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rJ\b\u0010S\u001a\u000201H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u0004\u0018\u00010\u0000X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\f\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0012\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000fR\u0012\u0010\u0014\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000fR\u0012\u0010\u0016\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000fR\u0012\u0010\u0018\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000fR\u0012\u0010\u001a\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000fR\u0012\u0010\u001c\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000fR\u0012\u0010\u001e\u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u000fR\u0012\u0010 \u001a\u00020\rX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000f\u00a8\u0006U"}, d2={"Lorg/mkui/geom/Curve;", "", "direction", "", "(I)V", "getDirection", "()I", "order", "getOrder", "reversedCurve", "getReversedCurve", "()Lorg/mkui/geom/Curve;", "x0", "", "getX0", "()D", "x1", "getX1", "xBot", "getXBot", "xMax", "getXMax", "xMin", "getXMin", "xTop", "getXTop", "y0", "getY0", "y1", "getY1", "yBot", "getYBot", "yTop", "getYTop", "TforY", "y", "XforT", "t", "XforY", "YforT", "accumulateCrossings", "", "c", "Lorg/mkui/geom/Crossings;", "compareTo", "that", "yrange", "", "controlPointString", "", "crossingsFor", "x", "dXforT", "deriv", "dYforT", "enlarge", "Lorg/mkui/geom/Rectangle2D;", "r", "findIntersect", "ymin", "slevel", "tlevel", "s0", "xs0", "ys0", "s1", "xs1", "ys1", "t0", "xt0", "yt0", "t1", "xt1", "yt1", "getSegment", "coords", "getSubCurve", "ystart", "yend", "dir", "getWithDirection", "nextVertical", "refineTforY", "toString", "Companion", "mkui"})
@StabilityInferred(parameters=1)
@SourceDebugExtension(value={"SMAP\nCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Curve.kt\norg/mkui/geom/Curve\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1295:1\n1#2:1296\n*E\n"})
public abstract class Curve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int direction;
    public static final int $stable;
    public static final int INCREASING = 1;
    public static final int DECREASING = -1;
    public static final int RECT_INTERSECTS = Integer.MIN_VALUE;
    public static final double TMIN = 0.001;

    public Curve(int direction) {
        this.direction = direction;
    }

    public final int getDirection() {
        return this.direction;
    }

    @NotNull
    public final Curve getWithDirection(int direction) {
        Curve curve;
        if (this.direction == direction) {
            curve = this;
        } else {
            Curve curve2 = this.getReversedCurve();
            curve = curve2;
            Intrinsics.checkNotNull((Object)curve2);
        }
        return curve;
    }

    @Nullable
    public abstract Curve getReversedCurve();

    @NotNull
    public String toString() {
        return "Curve[" + this.getOrder() + ", (" + Companion.round(this.getX0()) + ", " + Companion.round(this.getY0()) + "), " + this.controlPointString() + "(" + Companion.round(this.getX1()) + ", " + Companion.round(this.getY1()) + "), " + (this.direction == 1 ? "D" : "U") + "]";
    }

    @NotNull
    public String controlPointString() {
        return "";
    }

    public abstract int getOrder();

    public abstract double getX0();

    public abstract double getY0();

    public abstract double getX1();

    public abstract double getY1();

    public abstract double getXTop();

    public abstract double getXBot();

    public abstract double YforT(double var1);

    public abstract double dXforT(double var1, int var3);

    public abstract double dYforT(double var1, int var3);

    public int crossingsFor(double x, double y) {
        if (y >= this.getYTop() && y < this.getYBot() && x < this.getXMax() && (x < this.getXMin() || x < this.XforY(y))) {
            return 1;
        }
        return 0;
    }

    public abstract double getYTop();

    public abstract double getYBot();

    public abstract double getXMin();

    public abstract double getXMax();

    public abstract double XforY(double var1);

    public boolean accumulateCrossings(@NotNull Crossings c) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        double xhi = c.getXHi();
        if (this.getXMin() >= xhi) {
            return false;
        }
        double xlo = c.getXLo();
        double ylo = c.getYLo();
        double yhi = c.getYHi();
        double y0 = this.getYTop();
        double y1 = this.getYBot();
        double tstart = 0.0;
        double ystart = 0.0;
        if (y0 < ylo) {
            if (y1 <= ylo) {
                return false;
            }
            ystart = ylo;
            tstart = this.TforY(ylo);
        } else {
            if (y0 >= yhi) {
                return false;
            }
            ystart = y0;
            tstart = 0.0;
        }
        double yend = 0.0;
        double tend = 0.0;
        if (y1 > yhi) {
            yend = yhi;
            tend = this.TforY(yhi);
        } else {
            yend = y1;
            tend = 1.0;
        }
        boolean hitLo = false;
        boolean hitHi = false;
        while (true) {
            double x;
            if ((x = this.XforT(tstart)) < xhi) {
                if (hitHi || x > xlo) {
                    return true;
                }
                hitLo = true;
            } else {
                if (hitLo) {
                    return true;
                }
                hitHi = true;
            }
            if (tstart >= tend) break;
            tstart = this.nextVertical(tstart, tend);
        }
        if (hitLo) {
            c.record(ystart, yend, this.direction);
        }
        return false;
    }

    @NotNull
    public abstract Rectangle2D enlarge(@NotNull Rectangle2D var1);

    public abstract double TforY(double var1);

    public abstract double XforT(double var1);

    public abstract double nextVertical(double var1, double var3);

    @NotNull
    public final Curve getSubCurve(double ystart, double yend) {
        return this.getSubCurve(ystart, yend, this.direction);
    }

    @NotNull
    public abstract Curve getSubCurve(double var1, double var3, int var5);

    public int compareTo(@NotNull Curve that, @NotNull double[] yrange) {
        double t1;
        double t0;
        double yt0;
        double s1;
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        Intrinsics.checkNotNullParameter((Object)yrange, (String)"yrange");
        double y0 = yrange[0];
        double y1 = yrange[1];
        y1 = Math.min(Math.min(y1, this.getYBot()), that.getYBot());
        if (y1 <= yrange[0]) {
            System.out.println((Object)("this == " + this));
            System.out.println((Object)("that == " + that));
            System.out.println((Object)("target range = " + yrange[0] + "=>" + yrange[1]));
            throw new Error("backstepping from " + yrange[0] + " to " + y1);
        }
        yrange[1] = y1;
        if (this.getXMax() <= that.getXMin()) {
            return this.getXMin() == that.getXMax() ? 0 : -1;
        }
        if (this.getXMin() >= that.getXMax()) {
            return 1;
        }
        double s0 = this.TforY(y0);
        double ys0 = this.YforT(s0);
        if (ys0 < y0) {
            s0 = this.refineTforY(s0, ys0, y0);
            ys0 = this.YforT(s0);
        }
        if (this.YforT(s1 = this.TforY(y1)) < y0) {
            s1 = this.refineTforY(s1, this.YforT(s1), y0);
        }
        if ((yt0 = that.YforT(t0 = that.TforY(y0))) < y0) {
            t0 = that.refineTforY(t0, yt0, y0);
            yt0 = that.YforT(t0);
        }
        if (that.YforT(t1 = that.TforY(y1)) < y0) {
            t1 = that.refineTforY(t1, that.YforT(t1), y0);
        }
        double xs0 = this.XforT(s0);
        double xt0 = that.XforT(t0);
        double scale = Math.max(Math.abs(y0), Math.abs(y1));
        double ymin = Math.max(scale * 1.0E-14, 1.0E-300);
        if (Curve.Companion.fairlyClose(xs0, xt0)) {
            double y;
            double bump = 0.0;
            bump = ymin;
            double maxbump = Math.min(ymin * 1.0E13, (y1 - y0) * 0.1);
            for (y = y0 + bump; y <= y1; y += bump) {
                double newy;
                if (Curve.Companion.fairlyClose(this.XforY(y), that.XforY(y))) {
                    int it = 2;
                    boolean bl = false;
                    bump *= (double)it;
                    if (!(bump > maxbump)) continue;
                    bump = maxbump;
                    continue;
                }
                y -= bump;
                while (!((newy = y + (bump /= 2.0)) <= y)) {
                    if (!Curve.Companion.fairlyClose(this.XforY(newy), that.XforY(newy))) continue;
                    y = newy;
                }
                break;
            }
            if (y > y0) {
                if (y < y1) {
                    yrange[1] = y;
                }
                return 0;
            }
        }
        if (ymin <= 0.0) {
            System.out.println((Object)("ymin = " + ymin));
        }
        while (s0 < s1 && t0 < t1) {
            double sh = this.nextVertical(s0, s1);
            double xsh = this.XforT(sh);
            double ysh = this.YforT(sh);
            double th = that.nextVertical(t0, t1);
            double xth = that.XforT(th);
            double yth = that.YforT(th);
            try {
                if (this.findIntersect(that, yrange, ymin, 0, 0, s0, xs0, ys0, sh, xsh, ysh, t0, xt0, yt0, th, xth, yth)) {
                    break;
                }
            }
            catch (Throwable t) {
                System.out.println((Object)("Error: " + t));
                System.out.println((Object)("y range was " + yrange[0] + "=>" + yrange[1]));
                System.out.println((Object)("s y range is " + ys0 + "=>" + ysh));
                System.out.println((Object)("t y range is " + yt0 + "=>" + yth));
                System.out.println((Object)("ymin is " + ymin));
                return 0;
            }
            if (ysh < yth) {
                if (ysh > yrange[0]) {
                    if (!(ysh < yrange[1])) break;
                    yrange[1] = ysh;
                    break;
                }
                s0 = sh;
                xs0 = xsh;
                ys0 = ysh;
                continue;
            }
            if (yth > yrange[0]) {
                if (!(yth < yrange[1])) break;
                yrange[1] = yth;
                break;
            }
            t0 = th;
            xt0 = xth;
            yt0 = yth;
        }
        double ymid = (yrange[0] + yrange[1]) / (double)2;
        return Companion.orderof(this.XforY(ymid), that.XforY(ymid));
    }

    public final boolean findIntersect(@NotNull Curve that, @NotNull double[] yrange, double ymin, int slevel, int tlevel, double s0, double xs0, double ys0, double s1, double xs1, double ys1, double t0, double xt0, double yt0, double t1, double xt1, double yt1) {
        Intrinsics.checkNotNullParameter((Object)that, (String)"that");
        Intrinsics.checkNotNullParameter((Object)yrange, (String)"yrange");
        if (ys0 > yt1 || yt0 > ys1) {
            return false;
        }
        if (Math.min(xs0, xs1) > Math.max(xt0, xt1) || Math.max(xs0, xs1) < Math.min(xt0, xt1)) {
            return false;
        }
        if (s1 - s0 > 0.001) {
            double s = (s0 + s1) / (double)2;
            double xs = this.XforT(s);
            double ys = this.YforT(s);
            if (s == s0 || s == s1) {
                System.out.println((Object)("s0 = " + s0));
                System.out.println((Object)("s1 = " + s1));
                throw new Error("no s progress!");
            }
            if (t1 - t0 > 0.001) {
                double t = (t0 + t1) / (double)2;
                double xt = that.XforT(t);
                double yt = that.YforT(t);
                if (t == t0 || t == t1) {
                    System.out.println((Object)("t0 = " + t0));
                    System.out.println((Object)("t1 = " + t1));
                    throw new Error("no t progress!");
                }
                if (ys >= yt0 && yt >= ys0 && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s0, xs0, ys0, s, xs, ys, t0, xt0, yt0, t, xt, yt)) {
                    return true;
                }
                if (ys >= yt && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s0, xs0, ys0, s, xs, ys, t, xt, yt, t1, xt1, yt1)) {
                    return true;
                }
                if (yt >= ys && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s, xs, ys, s1, xs1, ys1, t0, xt0, yt0, t, xt, yt)) {
                    return true;
                }
                if (ys1 >= yt && yt1 >= ys) {
                    return this.findIntersect(that, yrange, ymin, slevel + 1, tlevel + 1, s, xs, ys, s1, xs1, ys1, t, xt, yt, t1, xt1, yt1);
                }
            } else {
                if (ys >= yt0 && this.findIntersect(that, yrange, ymin, slevel + 1, tlevel, s0, xs0, ys0, s, xs, ys, t0, xt0, yt0, t1, xt1, yt1)) {
                    return true;
                }
                if (yt1 >= ys) {
                    return this.findIntersect(that, yrange, ymin, slevel + 1, tlevel, s, xs, ys, s1, xs1, ys1, t0, xt0, yt0, t1, xt1, yt1);
                }
            }
        } else if (t1 - t0 > 0.001) {
            double t = (t0 + t1) / (double)2;
            double xt = that.XforT(t);
            double yt = that.YforT(t);
            if (t == t0 || t == t1) {
                System.out.println((Object)("t0 = " + t0));
                System.out.println((Object)("t1 = " + t1));
                throw new Error("no t progress!");
            }
            if (yt >= ys0 && this.findIntersect(that, yrange, ymin, slevel, tlevel + 1, s0, xs0, ys0, s1, xs1, ys1, t0, xt0, yt0, t, xt, yt)) {
                return true;
            }
            if (ys1 >= yt) {
                return this.findIntersect(that, yrange, ymin, slevel, tlevel + 1, s0, xs0, ys0, s1, xs1, ys1, t, xt, yt, t1, xt1, yt1);
            }
        } else {
            double xnm = xt1 - xt0;
            double ylk = ys1 - ys0;
            double ynm = yt1 - yt0;
            double xlk = xs1 - xs0;
            double det = xnm * ylk - ynm * xlk;
            if (!(det == 0.0)) {
                double detinv = 1.0 / det;
                double ymk = yt0 - ys0;
                double xmk = xt0 - xs0;
                double s = (xnm * ymk - ynm * xmk) * detinv;
                double t = (xlk * ymk - ylk * xmk) * detinv;
                if (s >= 0.0 && s <= 1.0 && t >= 0.0 && t <= 1.0) {
                    double y;
                    s = s0 + s * (s1 - s0);
                    t = t0 + t * (t1 - t0);
                    if (s < 0.0 || s > 1.0 || t < 0.0 || t > 1.0) {
                        System.out.println((Object)"Uh oh!");
                    }
                    if ((y = (this.YforT(s) + that.YforT(t)) / (double)2) <= yrange[1] && y > yrange[0]) {
                        yrange[1] = y;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final double refineTforY(double t0, double yt0, double y0) {
        double t02 = t0;
        double t1 = 1.0;
        while (true) {
            double th;
            if ((th = (t02 + t1) / (double)2) == t02 || th == t1) {
                return t1;
            }
            double y = this.YforT(th);
            if (y < y0) {
                t02 = th;
                continue;
            }
            if (!(y > y0)) break;
            t1 = th;
        }
        return t1;
    }

    public abstract int getSegment(@NotNull double[] var1);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\bH\u0002J,\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J4\u0010\u001a\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ$\u0010\u001c\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\bJ,\u0010\u001f\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010 \u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010!\u001a\u00020\bJ^\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0004J6\u0010*\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ\u001e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bJN\u0010.\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0004Jv\u00101\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010%\u001a\u00020\b2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0004JN\u00107\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ.\u00108\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-2\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\bJf\u00109\u001a\u00020\u00042\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\b2\u0006\u00104\u001a\u00020\b2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010/\u001a\u00020\b2\u0006\u00100\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010)\u001a\u00020\u0004J\u000e\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020\bJ\u0016\u0010<\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lorg/mkui/geom/Curve$Companion;", "", "()V", "DECREASING", "", "INCREASING", "RECT_INTERSECTS", "TMIN", "", "diffbits", "", "y1", "y2", "fairlyClose", "", "v1", "v2", "insertCubic", "", "curves", "", "Lorg/mkui/geom/Curve;", "x0", "y0", "coords", "", "insertLine", "x1", "insertMove", "x", "y", "insertQuad", "orderof", "x2", "pointCrossingsForCubic", "px", "py", "xc0", "yc0", "xc1", "yc1", "level", "pointCrossingsForLine", "pointCrossingsForPath", "pi", "Lorg/mkui/geom/PathIterator;", "pointCrossingsForQuad", "xc", "yc", "rectCrossingsForCubic", "crossings", "rxmin", "rymin", "rxmax", "rymax", "rectCrossingsForLine", "rectCrossingsForPath", "rectCrossingsForQuad", "round", "v", "signeddiffbits", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public final void insertMove(@NotNull List<Curve> curves, double x, double y) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            curves.add(new Order0(x, y));
        }

        public final void insertLine(@NotNull List<Curve> curves, double x0, double y0, double x1, double y1) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            if (y0 < y1) {
                curves.add(new Order1(x0, y0, x1, y1, 1));
            } else if (y0 > y1) {
                curves.add(new Order1(x1, y1, x0, y0, -1));
            }
        }

        public final void insertQuad(@NotNull List<Curve> curves, double x0, double y0, @NotNull double[] coords) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double y1 = coords[3];
            if (y0 > y1) {
                Order2.Companion.insert(curves, coords, coords[2], y1, coords[0], coords[1], x0, y0, -1);
            } else {
                if (y0 == y1 && y0 == coords[1]) {
                    return;
                }
                Order2.Companion.insert(curves, coords, x0, y0, coords[0], coords[1], coords[2], y1, 1);
            }
        }

        public final void insertCubic(@NotNull List<Curve> curves, double x0, double y0, @NotNull double[] coords) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double y1 = coords[5];
            if (y0 > y1) {
                Order3.Companion.insert(curves, coords, coords[4], y1, coords[2], coords[3], coords[0], coords[1], x0, y0, -1);
            } else {
                if (y0 == y1 && y0 == coords[1] && y0 == coords[3]) {
                    return;
                }
                Order3.Companion.insert(curves, coords, x0, y0, coords[0], coords[1], coords[2], coords[3], coords[4], y1, 1);
            }
        }

        public final int pointCrossingsForPath(@NotNull PathIterator pi, double px, double py) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            if (pi.isDone()) {
                return 0;
            }
            double[] coords = new double[6];
            if (pi.currentSegment(coords) != 0) {
                throw new IllegalStateException("missing initial moveto in path definition");
            }
            pi.next();
            double movx = 0.0;
            movx = coords[0];
            double movy = 0.0;
            movy = coords[1];
            double curx = 0.0;
            curx = movx;
            double cury = 0.0;
            cury = movy;
            int crossings = 0;
            while (!pi.isDone()) {
                double endy = 0.0;
                double endx = 0.0;
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        if (!(cury == movy)) {
                            crossings += this.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                        }
                        Companion $this$pointCrossingsForPath_u24lambda_u240 = this;
                        boolean bl = false;
                        movx = curx = coords[0];
                        Companion $this$pointCrossingsForPath_u24lambda_u241 = this;
                        boolean bl2 = false;
                        movy = cury = coords[1];
                        break;
                    }
                    case 1: {
                        endx = coords[0];
                        endy = coords[1];
                        crossings += this.pointCrossingsForLine(px, py, curx, cury, endx, endy);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 2: {
                        endx = coords[2];
                        endy = coords[3];
                        crossings += this.pointCrossingsForQuad(px, py, curx, cury, coords[0], coords[1], endx, endy, 0);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 3: {
                        endx = coords[4];
                        endy = coords[5];
                        crossings += this.pointCrossingsForCubic(px, py, curx, cury, coords[0], coords[1], coords[2], coords[3], endx, endy, 0);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 4: {
                        if (!(cury == movy)) {
                            crossings += this.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                        }
                        curx = movx;
                        cury = movy;
                    }
                }
                pi.next();
            }
            if (!(cury == movy)) {
                crossings += this.pointCrossingsForLine(px, py, curx, cury, movx, movy);
            }
            return crossings;
        }

        public final int pointCrossingsForLine(double px, double py, double x0, double y0, double x1, double y1) {
            if (py < y0 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < x1) {
                return y0 < y1 ? 1 : -1;
            }
            double xintercept = x0 + (py - y0) * (x1 - x0) / (y1 - y0);
            if (px >= xintercept) {
                return 0;
            }
            return y0 < y1 ? 1 : -1;
        }

        public final int pointCrossingsForQuad(double px, double py, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
            double xc2 = xc;
            double yc2 = yc;
            if (py < y0 && py < yc2 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= yc2 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= xc2 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < xc2 && px < x1) {
                if (py >= y0) {
                    if (py < y1) {
                        return 1;
                    }
                } else if (py >= y1) {
                    return -1;
                }
                return 0;
            }
            if (level > 52) {
                return this.pointCrossingsForLine(px, py, x0, y0, x1, y1);
            }
            double x0c = (x0 + xc2) / (double)2;
            double y0c = (y0 + yc2) / (double)2;
            double xc1 = (xc2 + x1) / (double)2;
            double yc1 = (yc2 + y1) / (double)2;
            xc2 = (x0c + xc1) / (double)2;
            yc2 = (y0c + yc1) / (double)2;
            return MathKt.isNaN((double)xc2) || MathKt.isNaN((double)yc2) ? 0 : this.pointCrossingsForQuad(px, py, x0, y0, x0c, y0c, xc2, yc2, level + 1) + this.pointCrossingsForQuad(px, py, xc2, yc2, xc1, yc1, x1, y1, level + 1);
        }

        public final int pointCrossingsForCubic(double px, double py, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
            double xc02 = xc0;
            double yc02 = yc0;
            double xc12 = xc1;
            double yc12 = yc1;
            if (py < y0 && py < yc02 && py < yc12 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= yc02 && py >= yc12 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= xc02 && px >= xc12 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < xc02 && px < xc12 && px < x1) {
                if (py >= y0) {
                    if (py < y1) {
                        return 1;
                    }
                } else if (py >= y1) {
                    return -1;
                }
                return 0;
            }
            if (level > 52) {
                return this.pointCrossingsForLine(px, py, x0, y0, x1, y1);
            }
            double xmid = (xc02 + xc12) / (double)2;
            double ymid = (yc02 + yc12) / (double)2;
            xc02 = (x0 + xc02) / (double)2;
            yc02 = (y0 + yc02) / (double)2;
            xc12 = (xc12 + x1) / (double)2;
            yc12 = (yc12 + y1) / (double)2;
            double xc0m = (xc02 + xmid) / (double)2;
            double yc0m = (yc02 + ymid) / (double)2;
            double xmc1 = (xmid + xc12) / (double)2;
            double ymc1 = (ymid + yc12) / (double)2;
            xmid = (xc0m + xmc1) / (double)2;
            ymid = (yc0m + ymc1) / (double)2;
            return MathKt.isNaN((double)xmid) || MathKt.isNaN((double)ymid) ? 0 : this.pointCrossingsForCubic(px, py, x0, y0, xc02, yc02, xc0m, yc0m, xmid, ymid, level + 1) + this.pointCrossingsForCubic(px, py, xmid, ymid, xmc1, ymc1, xc12, yc12, x1, y1, level + 1);
        }

        public final int rectCrossingsForPath(@NotNull PathIterator pi, double rxmin, double rymin, double rxmax, double rymax) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            if (rxmax <= rxmin || rymax <= rymin) {
                return 0;
            }
            if (pi.isDone()) {
                return 0;
            }
            double[] coords = new double[6];
            if (pi.currentSegment(coords) != 0) {
                throw new IllegalStateException("missing initial moveto in path definition");
            }
            pi.next();
            double movx = 0.0;
            movx = coords[0];
            double curx = 0.0;
            curx = movx;
            double movy = 0.0;
            movy = coords[1];
            double cury = 0.0;
            cury = movy;
            int crossings = 0;
            while (crossings != Integer.MIN_VALUE && !pi.isDone()) {
                double endy = 0.0;
                double endx = 0.0;
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        if (!(curx == movx) || !(cury == movy)) {
                            crossings = this.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                        }
                        Companion $this$rectCrossingsForPath_u24lambda_u242 = this;
                        boolean bl = false;
                        movx = curx = coords[0];
                        Companion $this$rectCrossingsForPath_u24lambda_u243 = this;
                        boolean bl2 = false;
                        movy = cury = coords[1];
                        break;
                    }
                    case 1: {
                        endx = coords[0];
                        endy = coords[1];
                        crossings = this.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, endx, endy);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 2: {
                        endx = coords[2];
                        endy = coords[3];
                        crossings = this.rectCrossingsForQuad(crossings, rxmin, rymin, rxmax, rymax, curx, cury, coords[0], coords[1], endx, endy, 0);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 3: {
                        endx = coords[4];
                        endy = coords[5];
                        crossings = this.rectCrossingsForCubic(crossings, rxmin, rymin, rxmax, rymax, curx, cury, coords[0], coords[1], coords[2], coords[3], endx, endy, 0);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 4: {
                        if (!(curx == movx) || !(cury == movy)) {
                            crossings = this.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
                        }
                        curx = movx;
                        cury = movy;
                    }
                }
                pi.next();
            }
            if (!(crossings == Integer.MIN_VALUE || curx == movx && cury == movy)) {
                crossings = this.rectCrossingsForLine(crossings, rxmin, rymin, rxmax, rymax, curx, cury, movx, movy);
            }
            return crossings;
        }

        public final int rectCrossingsForLine(int crossings, double rxmin, double rymin, double rxmax, double rymax, double x0, double y0, double x1, double y1) {
            int crossings2 = crossings;
            if (y0 >= rymax && y1 >= rymax) {
                return crossings2;
            }
            if (y0 <= rymin && y1 <= rymin) {
                return crossings2;
            }
            if (x0 <= rxmin && x1 <= rxmin) {
                return crossings2;
            }
            if (x0 >= rxmax && x1 >= rxmax) {
                if (y0 < y1) {
                    if (y0 <= rymin) {
                        ++crossings2;
                    }
                    if (y1 >= rymax) {
                        ++crossings2;
                    }
                } else if (y1 < y0) {
                    if (y1 <= rymin) {
                        --crossings2;
                    }
                    if (y0 >= rymax) {
                        --crossings2;
                    }
                }
                return crossings2;
            }
            if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax) {
                return Integer.MIN_VALUE;
            }
            double xi0 = x0;
            if (y0 < rymin) {
                xi0 += (rymin - y0) * (x1 - x0) / (y1 - y0);
            } else if (y0 > rymax) {
                xi0 += (rymax - y0) * (x1 - x0) / (y1 - y0);
            }
            double xi1 = x1;
            if (y1 < rymin) {
                xi1 += (rymin - y1) * (x0 - x1) / (y0 - y1);
            } else if (y1 > rymax) {
                xi1 += (rymax - y1) * (x0 - x1) / (y0 - y1);
            }
            if (xi0 <= rxmin && xi1 <= rxmin) {
                return crossings2;
            }
            if (xi0 >= rxmax && xi1 >= rxmax) {
                if (y0 < y1) {
                    if (y0 <= rymin) {
                        ++crossings2;
                    }
                    if (y1 >= rymax) {
                        ++crossings2;
                    }
                } else if (y1 < y0) {
                    if (y1 <= rymin) {
                        --crossings2;
                    }
                    if (y0 >= rymax) {
                        --crossings2;
                    }
                }
                return crossings2;
            }
            return Integer.MIN_VALUE;
        }

        public final int rectCrossingsForQuad(int crossings, double rxmin, double rymin, double rxmax, double rymax, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
            int crossings2 = crossings;
            double xc2 = xc;
            double yc2 = yc;
            if (y0 >= rymax && yc2 >= rymax && y1 >= rymax) {
                return crossings2;
            }
            if (y0 <= rymin && yc2 <= rymin && y1 <= rymin) {
                return crossings2;
            }
            if (x0 <= rxmin && xc2 <= rxmin && x1 <= rxmin) {
                return crossings2;
            }
            if (x0 >= rxmax && xc2 >= rxmax && x1 >= rxmax) {
                if (y0 < y1) {
                    if (y0 <= rymin && y1 > rymin) {
                        ++crossings2;
                    }
                    if (y0 < rymax && y1 >= rymax) {
                        ++crossings2;
                    }
                } else if (y1 < y0) {
                    if (y1 <= rymin && y0 > rymin) {
                        --crossings2;
                    }
                    if (y1 < rymax && y0 >= rymax) {
                        --crossings2;
                    }
                }
                return crossings2;
            }
            if (x0 < rxmax && x0 > rxmin && y0 < rymax && y0 > rymin || x1 < rxmax && x1 > rxmin && y1 < rymax && y1 > rymin) {
                return Integer.MIN_VALUE;
            }
            if (level > 52) {
                return this.rectCrossingsForLine(crossings2, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
            }
            double x0c = (x0 + xc2) / (double)2;
            double y0c = (y0 + yc2) / (double)2;
            double xc1 = (xc2 + x1) / (double)2;
            double yc1 = (yc2 + y1) / (double)2;
            xc2 = (x0c + xc1) / (double)2;
            yc2 = (y0c + yc1) / (double)2;
            if (MathKt.isNaN((double)xc2) || MathKt.isNaN((double)yc2)) {
                return 0;
            }
            if ((crossings2 = this.rectCrossingsForQuad(crossings2, rxmin, rymin, rxmax, rymax, x0, y0, x0c, y0c, xc2, yc2, level + 1)) != Integer.MIN_VALUE) {
                crossings2 = this.rectCrossingsForQuad(crossings2, rxmin, rymin, rxmax, rymax, xc2, yc2, xc1, yc1, x1, y1, level + 1);
            }
            return crossings2;
        }

        public final int rectCrossingsForCubic(int crossings, double rxmin, double rymin, double rxmax, double rymax, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
            int crossings2 = crossings;
            double xc02 = xc0;
            double yc02 = yc0;
            double xc12 = xc1;
            double yc12 = yc1;
            if (y0 >= rymax && yc02 >= rymax && yc12 >= rymax && y1 >= rymax) {
                return crossings2;
            }
            if (y0 <= rymin && yc02 <= rymin && yc12 <= rymin && y1 <= rymin) {
                return crossings2;
            }
            if (x0 <= rxmin && xc02 <= rxmin && xc12 <= rxmin && x1 <= rxmin) {
                return crossings2;
            }
            if (x0 >= rxmax && xc02 >= rxmax && xc12 >= rxmax && x1 >= rxmax) {
                if (y0 < y1) {
                    if (y0 <= rymin && y1 > rymin) {
                        ++crossings2;
                    }
                    if (y0 < rymax && y1 >= rymax) {
                        ++crossings2;
                    }
                } else if (y1 < y0) {
                    if (y1 <= rymin && y0 > rymin) {
                        --crossings2;
                    }
                    if (y1 < rymax && y0 >= rymax) {
                        --crossings2;
                    }
                }
                return crossings2;
            }
            if (x0 > rxmin && x0 < rxmax && y0 > rymin && y0 < rymax || x1 > rxmin && x1 < rxmax && y1 > rymin && y1 < rymax) {
                return Integer.MIN_VALUE;
            }
            if (level > 52) {
                return this.rectCrossingsForLine(crossings2, rxmin, rymin, rxmax, rymax, x0, y0, x1, y1);
            }
            double xmid = (xc02 + xc12) / (double)2;
            double ymid = (yc02 + yc12) / (double)2;
            xc02 = (x0 + xc02) / (double)2;
            yc02 = (y0 + yc02) / (double)2;
            xc12 = (xc12 + x1) / (double)2;
            yc12 = (yc12 + y1) / (double)2;
            double xc0m = (xc02 + xmid) / (double)2;
            double yc0m = (yc02 + ymid) / (double)2;
            double xmc1 = (xmid + xc12) / (double)2;
            double ymc1 = (ymid + yc12) / (double)2;
            xmid = (xc0m + xmc1) / (double)2;
            ymid = (yc0m + ymc1) / (double)2;
            if (MathKt.isNaN((double)xmid) || MathKt.isNaN((double)ymid)) {
                return 0;
            }
            if ((crossings2 = this.rectCrossingsForCubic(crossings2, rxmin, rymin, rxmax, rymax, x0, y0, xc02, yc02, xc0m, yc0m, xmid, ymid, level + 1)) != Integer.MIN_VALUE) {
                crossings2 = this.rectCrossingsForCubic(crossings2, rxmin, rymin, rxmax, rymax, xmid, ymid, xmc1, ymc1, xc12, yc12, x1, y1, level + 1);
            }
            return crossings2;
        }

        public final int orderof(double x1, double x2) {
            if (x1 < x2) {
                return -1;
            }
            return x1 > x2 ? 1 : 0;
        }

        public final long signeddiffbits(double y1, double y2) {
            return MathKt.doubleToLongBits((double)y1) - MathKt.doubleToLongBits((double)y2);
        }

        public final long diffbits(double y1, double y2) {
            return Math.abs(MathKt.doubleToLongBits((double)y1) - MathKt.doubleToLongBits((double)y2));
        }

        private final boolean fairlyClose(double v1, double v2) {
            return Math.abs(v1 - v2) < Math.max(Math.abs(v1), Math.abs(v2)) * 1.0E-10;
        }

        public final double round(double v) {
            return v;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

