/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.curve.BinaryCurveApproximationAlgorithm;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ParametricCurve;
import org.mkui.geom.curve.PascalsTriangle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\u0016\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/mkui/geom/curve/BezierCurve;", "Lorg/mkui/geom/curve/ParametricCurve;", "cp", "Lorg/mkui/geom/curve/ControlPath;", "gi", "Lorg/mkui/geom/curve/GroupIterator;", "(Lorg/mkui/geom/curve/ControlPath;Lorg/mkui/geom/curve/GroupIterator;)V", "sampleLimit", "", "getSampleLimit", "()I", "setSampleLimit", "(I)V", "t_max", "", "t_min", "appendTo", "", "mp", "Lorg/mkui/geom/curve/MultiPath;", "eval", "p", "", "resetMemory", "setInterval", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class BezierCurve
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double t_min;
    private double t_max = 1.0;
    private int sampleLimit = 1;
    public static final int $stable = 8;
    @NotNull
    private static double[] a = new double[0];

    public BezierCurve(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    @Override
    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int n) {
        this.sampleLimit = n;
    }

    public final void setInterval(double t_min, double t_max) {
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public final double t_min() {
        return this.t_min;
    }

    public final double t_max() {
        return this.t_max;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        int n = mp.getDimension();
        double[] d = new double[n + 1];
        d[n] = this.t_min;
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, this.t_min, this.t_max, mp);
    }

    @Override
    public void eval(@NotNull double[] p) {
        int i;
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        int numPts = groupIterator.getGroupSize();
        if (numPts > a.length) {
            a = new double[2 * numPts];
        }
        BezierCurve.a[numPts - 1] = 1.0;
        double one_minus_t = 1.0 - t;
        for (i = numPts - 2; -1 < i; --i) {
            BezierCurve.a[i] = a[i + 1] * one_minus_t;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        groupIterator2.set(0, 0);
        double b = 1.0;
        for (i = 0; i < numPts; ++i) {
            double pt = PascalsTriangle.INSTANCE.nCr(numPts - 1, i);
            if (!Double.isNaN(pt) && !Double.isNaN(pt)) {
                double gravity = a[i] * b * pt;
                ControlPath controlPath = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath);
                GroupIterator groupIterator3 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator3);
                double[] d = controlPath.getPoint(groupIterator3.next()).getLocation();
                int n = p.length - 1;
                for (int j = 0; j < n; ++j) {
                    int n2 = j;
                    p[n2] = p[n2] + d[j] * gravity;
                }
            }
            b *= t;
        }
    }

    @Override
    public void resetMemory() {
        if (!(a.length == 0)) {
            a = new double[0];
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/mkui/geom/curve/BezierCurve$Companion;", "", "()V", "a", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

