/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.geom.curve.Geom;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ShapeMultiPathIterator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ&\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aJ\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0096\u0002J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\rH\u0086\u0002J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u001aH\u0016J\u0012\u0010\u0012\u001a\u00020\u00112\b\u0010%\u001a\u0004\u0018\u00010&H\u0016J&\u0010'\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001aJ\u0010\u0010'\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u00118VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006)"}, d2={"Lorg/mkui/geom/curve/ShapeMultiPath;", "Lorg/mkui/geom/curve/MultiPath;", "Lorg/mkui/geom/Shape;", "dimension", "", "(I)V", "ai0", "ai1", "basisVectors", "", "getBasisVectors", "()[I", "bounds2D", "Lorg/mkui/geom/Rectangle2D;", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "windingRule", "getWindingRule", "()I", "contains", "", "x", "", "y", "x1", "y1", "w", "h", "p", "Lorg/mkui/geom/Point2D;", "r", "getFlattenPathIterator", "flatness", "at", "Lorg/mkui/geom/AffineTransform;", "intersects", "Companion", "mkui"})
@StabilityInferred(parameters=1)
public final class ShapeMultiPath
extends MultiPath
implements Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int windingRule;
    private final int ai0;
    private final int ai1;
    public static final int $stable;

    public ShapeMultiPath(int dimension) {
        super(dimension);
        this.ai1 = 1;
    }

    public final int getWindingRule() {
        return this.windingRule;
    }

    @NotNull
    public final int[] getBasisVectors() {
        int[] nArray = new int[]{this.ai0, this.ai1};
        return nArray;
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        int n = this.getNumPoints();
        double x1 = Double.MAX_VALUE;
        double y1 = Double.MAX_VALUE;
        double x2 = -1.7976931348623157E308;
        double y2 = -1.7976931348623157E308;
        boolean defined = false;
        for (int i = 0; i < n; ++i) {
            double[] p = this.get(i);
            boolean b = false;
            if (this.getType(i) == MultiPath.Companion.getMOVE_TO()) {
                if (i < n - 1 && this.getType(i + 1) == MultiPath.Companion.getLINE_TO()) {
                    b = true;
                }
            } else {
                b = true;
            }
            if (!b) continue;
            defined = true;
            if (p[this.ai0] < x1) {
                x1 = p[this.ai0];
            }
            if (p[this.ai1] < y1) {
                y1 = p[this.ai1];
            }
            if (p[this.ai0] > x2) {
                x2 = p[this.ai0];
            }
            if (!(p[this.ai1] > y2)) continue;
            y2 = p[this.ai1];
        }
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return new ShapeMultiPathIterator(this, at);
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return new ShapeMultiPathIterator(this, null);
    }

    public final boolean contains(double x, double y) {
        int cross = Companion.pointCrossingsForPath(this.getPathIterator(), x, y);
        return this.windingRule == 1 ? cross != 0 : (cross & 1) != 0;
    }

    public final boolean contains(double x1, double y1, double w, double h) {
        if (!this.contains(x1, y1)) {
            return false;
        }
        double y2 = y1 + h;
        if (!this.contains(x1, y2)) {
            return false;
        }
        double x2 = x1 + w;
        if (!this.contains(x2, y1)) {
            return false;
        }
        if (!this.contains(x2, y2)) {
            return false;
        }
        int n = this.getNumPoints();
        if (n == 0) {
            return false;
        }
        double[] p = this.get(0);
        double xb = p[this.ai0];
        double yb = p[this.ai1];
        for (int i = 1; i < n; ++i) {
            p = this.get(i);
            double xa = p[this.ai0];
            double ya = p[this.ai1];
            if (this.getType(i) == MultiPath.Companion.getLINE_TO()) {
                if (Geom.INSTANCE.getSegSegIntersection(xa, ya, xb, yb, x1, y1, x2, y1, null) == Geom.INSTANCE.getINTERSECT()) {
                    return false;
                }
                if (Geom.INSTANCE.getSegSegIntersection(xa, ya, xb, yb, x1, y1, x1, y2, null) == Geom.INSTANCE.getINTERSECT()) {
                    return false;
                }
                if (Geom.INSTANCE.getSegSegIntersection(xa, ya, xb, yb, x1, y2, x2, y2, null) == Geom.INSTANCE.getINTERSECT()) {
                    return false;
                }
                if (Geom.INSTANCE.getSegSegIntersection(xa, ya, xb, yb, x2, y1, x2, y2, null) == Geom.INSTANCE.getINTERSECT()) {
                    return false;
                }
            }
            xb = xa;
            yb = ya;
        }
        return true;
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x1, double y1, double w, double h) {
        if (this.contains(x1, y1)) {
            return true;
        }
        double y2 = y1 + h;
        if (this.contains(x1, y2)) {
            return true;
        }
        double x2 = x1 + w;
        if (this.contains(x2, y1)) {
            return true;
        }
        if (this.contains(x2, y2)) {
            return true;
        }
        int n = this.getNumPoints();
        if (n == 0) {
            return false;
        }
        double[] p = this.get(0);
        double xb = p[this.ai0];
        double yb = p[this.ai1];
        for (int i = 1; i < n; ++i) {
            p = this.get(i);
            double xa = p[this.ai0];
            double ya = p[this.ai1];
            if (this.getType(i) == MultiPath.Companion.getLINE_TO()) {
                if (Geom.INSTANCE.getSegSegIntersection(xa, ya, xb, yb, x1, y1, x2, y1, null) == Geom.INSTANCE.getINTERSECT()) {
                    return true;
                }
                if (Geom.INSTANCE.getSegSegIntersection(xa, ya, xb, yb, x1, y1, x1, y2, null) == Geom.INSTANCE.getINTERSECT()) {
                    return true;
                }
                if (Geom.INSTANCE.getSegSegIntersection(xa, ya, xb, yb, x1, y2, x2, y2, null) == Geom.INSTANCE.getINTERSECT()) {
                    return true;
                }
                if (Geom.INSTANCE.getSegSegIntersection(xa, ya, xb, yb, x2, y1, x2, y2, null) == Geom.INSTANCE.getINTERSECT()) {
                    return true;
                }
                if (xa >= x1 && ya >= y1 && xa <= x2 && ya <= y2) {
                    return true;
                }
                if (xb >= x1 && yb >= y1 && xb <= x2 && yb <= y2) {
                    return true;
                }
            }
            xb = xa;
            yb = ya;
        }
        return false;
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return Shape.DefaultImpls.getBounds(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J^\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004J6\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0006J\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006JN\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0004\u00a8\u0006\u0018"}, d2={"Lorg/mkui/geom/curve/ShapeMultiPath$Companion;", "", "()V", "pointCrossingsForCubic", "", "px", "", "py", "x0", "y0", "xc0", "yc0", "xc1", "yc1", "x1", "y1", "level", "pointCrossingsForLine", "pointCrossingsForPath", "pi", "Lorg/mkui/geom/PathIterator;", "pointCrossingsForQuad", "xc", "yc", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public final int pointCrossingsForPath(@NotNull PathIterator pi, double px, double py) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            if (pi.isDone()) {
                return 0;
            }
            double[] coords = new double[6];
            if (!(pi.currentSegment(coords) == 0)) {
                boolean bl = false;
                String string = "missing initial moveto in path definition";
                throw new IllegalStateException(string.toString());
            }
            pi.next();
            double movx = 0.0;
            movx = coords[0];
            double movy = 0.0;
            movy = coords[1];
            double curx = 0.0;
            curx = movx;
            double cury = 0.0;
            cury = movy;
            int crossings = 0;
            while (!pi.isDone()) {
                double endy = 0.0;
                double endx = 0.0;
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        if (!(cury == movy)) {
                            crossings += this.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                        }
                        Companion $this$pointCrossingsForPath_u24lambda_u241 = this;
                        boolean bl = false;
                        movx = curx = coords[0];
                        Companion $this$pointCrossingsForPath_u24lambda_u242 = this;
                        boolean bl2 = false;
                        movy = cury = coords[1];
                        break;
                    }
                    case 1: {
                        endx = coords[0];
                        endy = coords[1];
                        crossings += this.pointCrossingsForLine(px, py, curx, cury, endx, endy);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 2: {
                        endx = coords[2];
                        endy = coords[3];
                        crossings += this.pointCrossingsForQuad(px, py, curx, cury, coords[0], coords[1], endx, endy, 0);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 3: {
                        endx = coords[4];
                        endy = coords[5];
                        crossings += this.pointCrossingsForCubic(px, py, curx, cury, coords[0], coords[1], coords[2], coords[3], endx, endy, 0);
                        curx = endx;
                        cury = endy;
                        break;
                    }
                    case 4: {
                        if (!(cury == movy)) {
                            crossings += this.pointCrossingsForLine(px, py, curx, cury, movx, movy);
                        }
                        curx = movx;
                        cury = movy;
                    }
                }
                pi.next();
            }
            if (!(cury == movy)) {
                crossings += this.pointCrossingsForLine(px, py, curx, cury, movx, movy);
            }
            return crossings;
        }

        public final int pointCrossingsForLine(double px, double py, double x0, double y0, double x1, double y1) {
            if (py < y0 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < x1) {
                return y0 < y1 ? 1 : -1;
            }
            double xintercept = x0 + (py - y0) * (x1 - x0) / (y1 - y0);
            if (px >= xintercept) {
                return 0;
            }
            return y0 < y1 ? 1 : -1;
        }

        public final int pointCrossingsForQuad(double px, double py, double x0, double y0, double xc, double yc, double x1, double y1, int level) {
            double xc2 = xc;
            double yc2 = yc;
            if (py < y0 && py < yc2 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= yc2 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= xc2 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < xc2 && px < x1) {
                if (py >= y0) {
                    if (py < y1) {
                        return 1;
                    }
                } else if (py >= y1) {
                    return -1;
                }
                return 0;
            }
            if (level > 52) {
                return this.pointCrossingsForLine(px, py, x0, y0, x1, y1);
            }
            double x0c = (x0 + xc2) / (double)2;
            double y0c = (y0 + yc2) / (double)2;
            double xc1 = (xc2 + x1) / (double)2;
            double yc1 = (yc2 + y1) / (double)2;
            xc2 = (x0c + xc1) / (double)2;
            yc2 = (y0c + yc1) / (double)2;
            return Double.isNaN(xc2) || Double.isNaN(yc2) ? 0 : this.pointCrossingsForQuad(px, py, x0, y0, x0c, y0c, xc2, yc2, level + 1) + this.pointCrossingsForQuad(px, py, xc2, yc2, xc1, yc1, x1, y1, level + 1);
        }

        public final int pointCrossingsForCubic(double px, double py, double x0, double y0, double xc0, double yc0, double xc1, double yc1, double x1, double y1, int level) {
            double xc02 = xc0;
            double yc02 = yc0;
            double xc12 = xc1;
            double yc12 = yc1;
            if (py < y0 && py < yc02 && py < yc12 && py < y1) {
                return 0;
            }
            if (py >= y0 && py >= yc02 && py >= yc12 && py >= y1) {
                return 0;
            }
            if (px >= x0 && px >= xc02 && px >= xc12 && px >= x1) {
                return 0;
            }
            if (px < x0 && px < xc02 && px < xc12 && px < x1) {
                if (py >= y0) {
                    if (py < y1) {
                        return 1;
                    }
                } else if (py >= y1) {
                    return -1;
                }
                return 0;
            }
            if (level > 52) {
                return this.pointCrossingsForLine(px, py, x0, y0, x1, y1);
            }
            double xmid = (xc02 + xc12) / (double)2;
            double ymid = (yc02 + yc12) / (double)2;
            xc02 = (x0 + xc02) / (double)2;
            yc02 = (y0 + yc02) / (double)2;
            xc12 = (xc12 + x1) / (double)2;
            yc12 = (yc12 + y1) / (double)2;
            double xc0m = (xc02 + xmid) / (double)2;
            double yc0m = (yc02 + ymid) / (double)2;
            double xmc1 = (xmid + xc12) / (double)2;
            double ymc1 = (ymid + yc12) / (double)2;
            xmid = (xc0m + xmc1) / (double)2;
            ymid = (yc0m + ymc1) / (double)2;
            return Double.isNaN(xmid) || Double.isNaN(ymid) ? 0 : this.pointCrossingsForCubic(px, py, x0, y0, xc02, yc02, xc0m, yc0m, xmid, ymid, level + 1) + this.pointCrossingsForCubic(px, py, xmid, ymid, xmc1, ymc1, xc12, yc12, x1, y1, level + 1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

