/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.graphics.drawscope.Stroke;
import java.awt.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.ComposeTextMetrics;
import org.mkui.color.MkColor;
import org.mkui.font.CPFontFactory;
import org.mkui.graphics.GraphicsContext2D;
import org.mkui.text.CPTextMetrics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0013\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0016J8\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J@\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010\u0005\u001a\u00020\u0010H\u0016J(\u0010$\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0016J6\u0010%\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0013J \u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\n\u0010+\u001a\u00060\bj\u0002`\tJ\u0010\u0010,\u001a\u00020-2\u0006\u0010)\u001a\u00020*H\u0016J\u0018\u0010.\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J\u0018\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\u00132\u0006\u00101\u001a\u00020\u0013H\u0016J(\u00102\u001a\u00020\u00102\u0006\u00103\u001a\u00020\u00132\u0006\u00104\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0013H\u0016J(\u00105\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0016J\b\u00106\u001a\u00020\u0010H\u0016J\u0010\u00107\u001a\u00020\u00102\u0006\u00108\u001a\u00020\u0013H\u0016J\b\u00109\u001a\u00020\u0010H\u0016J\u0018\u0010:\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016J\u0010\u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0006H\u0016J\u0010\u0010=\u001a\u00020\u00102\b\u0010>\u001a\u0004\u0018\u00010?J\u0014\u0010=\u001a\u00020\u00102\n\u0010>\u001a\u00060\bj\u0002`\tH\u0016J\u0010\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\u0013H\u0016J\u0010\u0010B\u001a\u00020\u00102\u0006\u0010C\u001a\u00020\u0013H\u0016J\u0010\u0010D\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u0006H\u0016J8\u0010E\u001a\u00020\u00102\u0006\u0010F\u001a\u00020\u00132\u0006\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020\u0013H\u0016J\b\u0010\u000e\u001a\u00020\u0010H\u0016J(\u0010L\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010M\u001a\u00020\u00132\u0006\u0010N\u001a\u00020\u0013H\u0016J(\u0010O\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0013H\u0016J8\u0010P\u001a\u00020\u00102\u0006\u0010F\u001a\u00020\u00132\u0006\u0010G\u001a\u00020\u00132\u0006\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u00132\u0006\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u00020\u0013H\u0016J\u0018\u0010Q\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020\u0013H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00060\bj\u0002`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006R"}, d2={"Lorg/mkui/graphics/CPGraphicsContext2D;", "Lorg/mkui/graphics/GraphicsContext2D;", "gc", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;)V", "fill", "Lorg/mkui/color/MkColor;", "font", "Lorg/jetbrains/skia/Font;", "Lorg/mkui/font/MkFont;", "lineWidth", "Landroidx/compose/ui/graphics/drawscope/Stroke;", "path", "Landroidx/compose/ui/graphics/Path;", "stroke", "beginPath", "", "bezierCurveTo", "xc1", "", "yc1", "xc2", "yc2", "x1", "y1", "clip", "closePath", "drawGradient", "color1", "color2", "x", "y", "w", "h", "isVertical", "", "fillRect", "fillRoundRect", "arcWidth", "arcHeight", "fillText", "text", "", "getFont", "getTextMetrics", "Lorg/mkui/text/CPTextMetrics;", "lineTo", "moveTo", "x0", "y0", "quadraticCurveTo", "xc", "yc", "rect", "restore", "rotate", "degrees", "save", "scale", "setFill", "p", "setFont", "f", "Ljava/awt/Font;", "setGlobalAlpha", "alpha", "setLineWidth", "lw", "setStroke", "setTransform", "mxx", "myx", "mxy", "myy", "mxt", "myt", "strokeLine", "x2", "y2", "strokeRect", "transform", "translate", "mkui"})
@StabilityInferred(parameters=0)
public final class CPGraphicsContext2D
implements GraphicsContext2D {
    @NotNull
    private DrawScope gc;
    @Nullable
    private Path path;
    @Nullable
    private MkColor fill;
    @Nullable
    private MkColor stroke;
    @NotNull
    private Stroke lineWidth;
    @NotNull
    private org.jetbrains.skia.Font font;
    public static final int $stable = 8;

    public CPGraphicsContext2D(@NotNull DrawScope gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.gc = gc;
        this.lineWidth = new Stroke(1.0f, 0.0f, 0, 0, null, 30, null);
        this.font = CPFontFactory.Companion.getInstance().createDefaultFont();
    }

    @Override
    @NotNull
    public CPTextMetrics getTextMetrics(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new ComposeTextMetrics(this.gc, this.font, text);
    }

    @Override
    public void drawGradient(@NotNull MkColor color1, @NotNull MkColor color2, double x, double y, double w, double h, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color2");
        if (isVertical) {
            // empty if block
        }
    }

    @Override
    public void save() {
        this.gc.getDrawContext().getCanvas().save();
    }

    @Override
    public void restore() {
        this.gc.getDrawContext().getCanvas().restore();
    }

    @Override
    public void translate(double x, double y) {
        this.gc.getDrawContext().getTransform().translate((float)x, (float)y);
    }

    @Override
    public void scale(double x, double y) {
        DrawTransform.scale-0AR0LA0$default((DrawTransform)this.gc.getDrawContext().getTransform(), (float)((float)x), (float)((float)y), (long)0L, (int)4, null);
    }

    @Override
    public void rotate(double degrees) {
        DrawTransform.rotate-Uv8p0NA$default((DrawTransform)this.gc.getDrawContext().getTransform(), (float)((float)degrees), (long)0L, (int)2, null);
    }

    @Override
    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
    }

    @Override
    public void setTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
    }

    @Override
    public void setGlobalAlpha(double alpha) {
    }

    @Override
    public void setFill(@NotNull MkColor p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.fill = p;
    }

    @Override
    public void setStroke(@NotNull MkColor p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.stroke = p;
    }

    @Override
    public void setLineWidth(double lw) {
        this.lineWidth = new Stroke((float)lw, 0.0f, 0, 0, null, 30, null);
    }

    @NotNull
    public final org.jetbrains.skia.Font getFont() {
        return this.font;
    }

    public final void setFont(@Nullable Font f) {
    }

    @Override
    public void setFont(@NotNull org.jetbrains.skia.Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.font = f;
    }

    @Override
    public void fillText(@NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
    }

    @Override
    public void beginPath() {
        this.path = SkiaBackedPath_skikoKt.Path();
    }

    @Override
    public void moveTo(double x0, double y0) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.moveTo((float)x0, (float)y0);
    }

    @Override
    public void lineTo(double x1, double y1) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.lineTo((float)x1, (float)y1);
    }

    @Override
    public void quadraticCurveTo(double xc, double yc, double x1, double y1) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.quadraticBezierTo((float)xc, (float)yc, (float)x1, (float)y1);
    }

    @Override
    public void bezierCurveTo(double xc1, double yc1, double xc2, double yc2, double x1, double y1) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.cubicTo((float)xc1, (float)yc1, (float)xc2, (float)yc2, (float)x1, (float)y1);
    }

    @Override
    public void rect(double x, double y, double w, double h) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.moveTo((float)x, (float)y);
        Path path2 = this.path;
        Intrinsics.checkNotNull((Object)path2);
        path2.lineTo((float)x + (float)w, (float)y);
        Path path3 = this.path;
        Intrinsics.checkNotNull((Object)path3);
        path3.lineTo((float)x + (float)w, (float)y + (float)h);
        Path path4 = this.path;
        Intrinsics.checkNotNull((Object)path4);
        path4.lineTo((float)x, (float)y + (float)h);
        Path path5 = this.path;
        Intrinsics.checkNotNull((Object)path5);
        path5.lineTo((float)x, (float)y);
    }

    @Override
    public void closePath() {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.close();
    }

    @Override
    public void fill() {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        MkColor mkColor = this.fill;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawPath-LG529CI$default((DrawScope)this.gc, (Path)path, (long)mkColor.getNative-0d7_KjU(), (float)0.0f, null, null, (int)0, (int)60, null);
    }

    @Override
    public void stroke() {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        MkColor mkColor = this.stroke;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawPath-LG529CI$default((DrawScope)this.gc, (Path)path, (long)mkColor.getNative-0d7_KjU(), (float)0.0f, (DrawStyle)((DrawStyle)this.lineWidth), null, (int)0, (int)52, null);
    }

    @Override
    public void clip() {
    }

    @Override
    public void fillRect(double x, double y, double w, double h) {
        MkColor mkColor = this.fill;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawRect-n-J9OG0$default((DrawScope)this.gc, (long)mkColor.getNative-0d7_KjU(), (long)OffsetKt.Offset((float)((float)x), (float)((float)y)), (long)SizeKt.Size((float)((float)w), (float)((float)w)), (float)0.0f, null, null, (int)0, (int)120, null);
    }

    @Override
    public void strokeRect(double x, double y, double w, double h) {
        MkColor mkColor = this.stroke;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawRect-n-J9OG0$default((DrawScope)this.gc, (long)mkColor.getNative-0d7_KjU(), (long)OffsetKt.Offset((float)((float)x), (float)((float)y)), (long)SizeKt.Size((float)((float)w), (float)((float)w)), (float)0.0f, (DrawStyle)((DrawStyle)this.lineWidth), null, (int)0, (int)104, null);
    }

    @Override
    public void strokeLine(double x1, double y1, double x2, double y2) {
    }

    public final void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
    }
}

