/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.OffsetKt;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPaint_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.graphics.drawscope.Stroke;
import com.macrofocus.common.geom.Dimension;
import com.macrofocus.common.geom.PreferredSize;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.Paint;
import org.jetbrains.skia.Rect;
import org.jetbrains.skia.TextLine;
import org.mkui.color.MkColor;
import org.mkui.color.MkColorKt;
import org.mkui.font.CPFontFactory;
import org.mkui.font.CPFontMetrics;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIGraphics;
import org.mkui.graphics.IGraphics;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0011H\u0016J \u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u000e\u0010\u0017\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rJ\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J(\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001dH\u0016J(\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020!2\u0006\u0010\u001e\u001a\u00020!2\u0006\u0010\u001f\u001a\u00020!2\u0006\u0010 \u001a\u00020!H\u0016J\u0012\u0010\"\u001a\u00020\u00112\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J(\u0010%\u001a\u00020\u00112\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020!H\u0016J \u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u00162\u0006\u0010&\u001a\u00020,2\u0006\u0010'\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0011H\u0016J\u0010\u0010-\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J(\u0010.\u001a\u00020\u00112\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020!H\u0016J\b\u0010/\u001a\u00020\u001dH\u0016J\b\u00100\u001a\u00020\bH\u0016J\b\u00101\u001a\u00020\u001dH\u0016J\n\u00102\u001a\u0004\u0018\u000103H\u0016J\b\u00104\u001a\u00020\u001dH\u0016J\u0010\u00105\u001a\u0002062\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0010\u00107\u001a\u00020,2\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0010\u00108\u001a\u00020,2\u0006\u0010+\u001a\u00020\u0016H\u0016J\u0018\u00109\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001dH\u0016J\u0018\u0010:\u001a\u00020\u00112\u0006\u0010&\u001a\u00020\u001d2\u0006\u0010'\u001a\u00020\u001dH\u0016J0\u0010;\u001a\u00020\u00112\u0006\u0010<\u001a\u00020=2\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020!2\u0006\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020!H\u0016J\u0010\u0010@\u001a\u00020\u00112\u0006\u0010A\u001a\u00020\u001dH\u0016J\u0010\u0010B\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010C\u001a\u00020\u00112\u000e\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rH\u0016J\u0010\u0010D\u001a\u00020\u00112\u0006\u0010E\u001a\u00020\u001dH\u0016J\u0012\u0010F\u001a\u00020\u00112\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0010\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u001dH\u0016J\u0012\u0010K\u001a\u00020\u00112\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010L\u001a\u00020M2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020!2\u0006\u0010?\u001a\u00020!H\u0016J\b\u0010N\u001a\u00020\u0011H\u0016J\u0018\u0010O\u001a\u00020\u00112\u0006\u0010&\u001a\u00020!2\u0006\u0010'\u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\n\u0018\u00010\fj\u0004\u0018\u0001`\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lorg/mkui/graphics/ComposeIGraphics;", "Lorg/mkui/graphics/AbstractIGraphics;", "context", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;)V", "baseline", "Lorg/mkui/graphics/IGraphics$TextBaseline;", "color", "Lorg/mkui/color/MkColor;", "getContext", "()Landroidx/compose/ui/graphics/drawscope/DrawScope;", "font", "Lorg/jetbrains/skia/Font;", "Lorg/mkui/font/MkFont;", "path", "Landroidx/compose/ui/graphics/Path;", "beginPath", "", "closePath", "computeStringBounds", "Lcom/macrofocus/common/geom/Dimension;", "s", "", "myFont", "draw", "geometry", "Lorg/mkui/geom/Shape;", "drawLine", "x1", "", "y1", "x2", "y2", "", "drawPoint", "point", "Lorg/mkui/geom/Point2D;", "drawRectange", "x", "y", "width", "height", "drawString", "text", "", "fill", "fillRectangle", "getAscent", "getColor", "getDescent", "getFontMetrics", "Lorg/mkui/font/CPFontMetrics;", "getLineWidth", "getStringBounds", "Lorg/mkui/geom/Rectangle2D;", "getStringHeight", "getStringWidth", "lineTo", "moveTo", "paintLabel", "l", "Lorg/mkui/labeling/EnhancedLabel;", "w", "h", "rotate", "theta", "setColor", "setFont", "setGlobalAlpha", "alpha", "setLineDash", "dashPattern", "", "setLineWidth", "lineWidth", "setTextBaseline", "sizeLabel", "Lcom/macrofocus/common/geom/PreferredSize;", "stroke", "translate", "mkui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nComposeIGraphics.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeIGraphics.kt\norg/mkui/graphics/ComposeIGraphics\n+ 2 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n*L\n1#1,310:1\n246#2:311\n*S KotlinDebug\n*F\n+ 1 ComposeIGraphics.kt\norg/mkui/graphics/ComposeIGraphics\n*L\n42#1:311\n*E\n"})
public final class ComposeIGraphics
extends AbstractIGraphics {
    @Nullable
    private final DrawScope context;
    @NotNull
    private IGraphics.TextBaseline baseline;
    @Nullable
    private Path path;
    @Nullable
    private MkColor color;
    @Nullable
    private Font font;
    public static final int $stable = 8;

    public ComposeIGraphics(@Nullable DrawScope context) {
        this.context = context;
        this.baseline = IGraphics.TextBaseline.Alphabetic;
        this.font = CPFontFactory.Companion.getInstance().createDefaultFont();
    }

    @Nullable
    public final DrawScope getContext() {
        return this.context;
    }

    @Override
    public void paintLabel(@NotNull EnhancedLabel l, int x, int y, int w, int h) {
        block10: {
            Paint paint;
            Intrinsics.checkNotNullParameter((Object)l, (String)"l");
            Paint $this$paintLabel_u24lambda_u240 = paint = SkiaBackedPaint_skikoKt.Paint().asFrameworkPaint();
            boolean bl = false;
            $this$paintLabel_u24lambda_u240.setAntiAlias(true);
            MkColor mkColor = l.getForeground();
            Intrinsics.checkNotNull((Object)mkColor);
            MkColor color = mkColor;
            $this$paintLabel_u24lambda_u240.setARGB(MkColorKt.getUAlpha(color) & 0xFF, MkColorKt.getURed(color) & 0xFF, MkColorKt.getUGreen(color) & 0xFF, MkColorKt.getUBlue(color) & 0xFF);
            Paint textPaint = paint;
            if (l.isOpaque()) {
                MkColor mkColor2 = l.getBackground();
                Intrinsics.checkNotNull((Object)mkColor2);
                this.color = mkColor2;
                this.fillRectangle(x, y, w, h);
            }
            DrawScope drawScope = this.context;
            if (drawScope == null) break block10;
            DrawScope $this$drawIntoCanvas$iv = drawScope;
            boolean $i$f$drawIntoCanvas = false;
            androidx.compose.ui.graphics.Canvas it = $this$drawIntoCanvas$iv.getDrawContext().getCanvas();
            boolean bl2 = false;
            Canvas nativeCanvas = SkiaBackedCanvas_skikoKt.getNativeCanvas((androidx.compose.ui.graphics.Canvas)it);
            String text = l.getText();
            if (text != null) {
                nativeCanvas.save();
                if (l.getMinimumCharactersToDisplay() != null) {
                    Integer n = l.getMinimumCharactersToDisplay();
                    Intrinsics.checkNotNull((Object)n);
                    int minimumCharactersToDisplay = n;
                    if (text.length() > minimumCharactersToDisplay) {
                        String string = text.substring(0, minimumCharactersToDisplay);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        String s = string;
                        Font font = this.font;
                        Intrinsics.checkNotNull((Object)font);
                        float width = font.measureTextWidth(s);
                        if (width > (float)(w - l.getInsetLeft() - l.getInsetRight())) {
                            nativeCanvas.restore();
                            return;
                        }
                    }
                }
                Rect clip = new Rect((float)x, (float)y, (float)x + (float)w, (float)y + (float)h);
                nativeCanvas.clipRect(clip);
                Font font = l.getFont();
                Intrinsics.checkNotNull((Object)font);
                Rect r = Font.measureText$default((Font)font, (String)text, null, (int)2, null);
                switch (l.getHorizontalAlignment()) {
                    case 2: 
                    case 10: {
                        Font font2 = l.getFont();
                        Intrinsics.checkNotNull((Object)font2);
                        nativeCanvas.drawTextLine(TextLine.Companion.make(text, font2), (float)x + (float)l.getInsetLeft(), (float)y + (float)l.getInsetTop() + -r.getTop(), textPaint);
                        break;
                    }
                    case 4: 
                    case 11: {
                        double width = Math.max(0.0, (double)((float)(w - l.getInsetLeft() - l.getInsetRight()) - (r.getRight() - r.getLeft())));
                        Font font3 = l.getFont();
                        Intrinsics.checkNotNull((Object)font3);
                        nativeCanvas.drawTextLine(TextLine.Companion.make(text, font3), (float)x + (float)l.getInsetLeft() + (float)width, (float)y + (float)l.getInsetTop() + -r.getTop(), textPaint);
                        break;
                    }
                    case 0: {
                        double width = Math.max(0.0, (double)((float)(w - l.getInsetLeft() - l.getInsetRight()) - (r.getRight() - r.getLeft())) / (double)2);
                        Font font4 = l.getFont();
                        Intrinsics.checkNotNull((Object)font4);
                        nativeCanvas.drawTextLine(TextLine.Companion.make(text, font4), (float)x + (float)l.getInsetLeft() + (float)width, (float)y + (float)l.getInsetTop() + -r.getTop(), textPaint);
                    }
                }
                nativeCanvas.restore();
            }
        }
    }

    @Override
    @NotNull
    public PreferredSize sizeLabel(@NotNull EnhancedLabel l, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        return new PreferredSize(this, l){
            final /* synthetic */ ComposeIGraphics this$0;
            final /* synthetic */ EnhancedLabel $l;
            {
                this.this$0 = $receiver;
                this.$l = $l;
            }

            @NotNull
            public Dimension getMinimumSize() {
                return new Dimension(0, (int)this.getPreferredHeight());
            }

            public double getPreferredHeight() {
                String string = this.$l.getText();
                Font font = this.$l.getFont();
                Intrinsics.checkNotNull((Object)font);
                Dimension b = this.this$0.computeStringBounds(string, font);
                return b.getHeight();
            }

            @NotNull
            public Dimension getPreferredSize() {
                String string = this.$l.getText();
                Font font = this.$l.getFont();
                Intrinsics.checkNotNull((Object)font);
                Dimension b = this.this$0.computeStringBounds(string, font);
                return new Dimension((int)b.getWidth(), (int)b.getHeight());
            }

            @NotNull
            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
    }

    @NotNull
    public final Dimension computeStringBounds(@Nullable String s, @Nullable Font myFont) {
        Font font = myFont;
        Intrinsics.checkNotNull((Object)font);
        Rect r = Font.measureText$default((Font)font, (String)s, null, (int)2, null);
        return new Dimension((int)(r.getRight() - r.getLeft()), (int)(r.getBottom() - r.getTop()));
    }

    @Override
    public double getLineWidth() {
        return 0.0;
    }

    @Override
    public void setLineWidth(double lineWidth) {
    }

    @Override
    public void setLineDash(@Nullable float[] dashPattern) {
    }

    @Override
    public void setGlobalAlpha(double alpha) {
    }

    @Override
    @NotNull
    public MkColor getColor() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    @Override
    public void setColor(@NotNull MkColor color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.color = color;
    }

    @Override
    protected void draw(@NotNull Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        if (geometry instanceof Rectangle2D) {
            DrawScope drawScope = this.context;
            Intrinsics.checkNotNull((Object)drawScope);
            MkColor mkColor = this.color;
            Intrinsics.checkNotNull((Object)mkColor);
            DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)mkColor.getNative-0d7_KjU(), (long)OffsetKt.Offset((float)((float)((Rectangle2D)geometry).getX()), (float)((float)((Rectangle2D)geometry).getY())), (long)SizeKt.Size((float)((float)((Rectangle2D)geometry).getWidth()), (float)((float)((Rectangle2D)geometry).getHeight())), (float)0.0f, (DrawStyle)((DrawStyle)new Stroke(1.0f, 0.0f, 0, 0, null, 30, null)), null, (int)0, (int)104, null);
        }
    }

    @Override
    protected void fill(@NotNull Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        if (geometry instanceof Rectangle2D) {
            DrawScope drawScope = this.context;
            Intrinsics.checkNotNull((Object)drawScope);
            MkColor mkColor = this.color;
            Intrinsics.checkNotNull((Object)mkColor);
            DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)mkColor.getNative-0d7_KjU(), (long)OffsetKt.Offset((float)((float)((Rectangle2D)geometry).getX()), (float)((float)((Rectangle2D)geometry).getY())), (long)SizeKt.Size((float)((float)((Rectangle2D)geometry).getWidth()), (float)((float)((Rectangle2D)geometry).getHeight())), (float)0.0f, null, null, (int)0, (int)120, null);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        DrawScope drawScope = this.context;
        Intrinsics.checkNotNull((Object)drawScope);
        MkColor mkColor = this.color;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawLine-NGM6Ib0$default((DrawScope)drawScope, (long)mkColor.getNative-0d7_KjU(), (long)OffsetKt.Offset((float)((float)x1), (float)((float)y1)), (long)OffsetKt.Offset((float)((float)x2), (float)((float)y2)), (float)0.0f, (int)0, null, (float)0.0f, null, (int)0, (int)504, null);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        DrawScope drawScope = this.context;
        Intrinsics.checkNotNull((Object)drawScope);
        MkColor mkColor = this.color;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)mkColor.getNative-0d7_KjU(), (long)OffsetKt.Offset((float)x, (float)y), (long)SizeKt.Size((float)width, (float)height), (float)0.0f, null, null, (int)0, (int)120, null);
    }

    @Override
    public void drawRectange(int x, int y, int width, int height) {
        DrawScope drawScope = this.context;
        Intrinsics.checkNotNull((Object)drawScope);
        MkColor mkColor = this.color;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)mkColor.getNative-0d7_KjU(), (long)OffsetKt.Offset((float)x, (float)y), (long)SizeKt.Size((float)width, (float)height), (float)0.0f, (DrawStyle)((DrawStyle)new Stroke(1.0f, 0.0f, 0, 0, null, 30, null)), null, (int)0, (int)104, null);
    }

    @Override
    public void drawPoint(@Nullable Point2D point) {
    }

    @Override
    public void setTextBaseline(@Nullable IGraphics.TextBaseline baseline) {
        IGraphics.TextBaseline textBaseline = baseline;
        Intrinsics.checkNotNull((Object)((Object)textBaseline));
        this.baseline = textBaseline;
    }

    @Override
    public void setFont(@Nullable Font font) {
        this.font = font;
    }

    @Override
    @NotNull
    public Rectangle2D getStringBounds(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public float getStringWidth(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return 0.0f;
    }

    @Override
    public float getStringHeight(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return 0.0f;
    }

    @Override
    public double getAscent() {
        return 0.0;
    }

    @Override
    public double getDescent() {
        return 0.0;
    }

    @Override
    @Nullable
    public CPFontMetrics getFontMetrics() {
        return null;
    }

    @Override
    public void drawString(@NotNull String text, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
    }

    @Override
    public void translate(int x, int y) {
    }

    @Override
    public void rotate(double theta) {
    }

    @Override
    public void beginPath() {
        this.path = SkiaBackedPath_skikoKt.Path();
    }

    @Override
    public void moveTo(double x, double y) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.moveTo((float)x, (float)y);
    }

    @Override
    public void lineTo(double x, double y) {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.lineTo((float)x, (float)y);
    }

    @Override
    public void closePath() {
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        path.close();
    }

    @Override
    public void stroke() {
        DrawScope drawScope = this.context;
        Intrinsics.checkNotNull((Object)drawScope);
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        MkColor mkColor = this.color;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawPath-LG529CI$default((DrawScope)drawScope, (Path)path, (long)mkColor.getNative-0d7_KjU(), (float)0.0f, (DrawStyle)((DrawStyle)new Stroke(1.0f, 0.0f, 0, 0, null, 30, null)), null, (int)0, (int)52, null);
    }

    @Override
    public void fill() {
        DrawScope drawScope = this.context;
        Intrinsics.checkNotNull((Object)drawScope);
        Path path = this.path;
        Intrinsics.checkNotNull((Object)path);
        MkColor mkColor = this.color;
        Intrinsics.checkNotNull((Object)mkColor);
        DrawScope.drawPath-LG529CI$default((DrawScope)drawScope, (Path)path, (long)mkColor.getNative-0d7_KjU(), (float)0.0f, null, null, (int)0, (int)60, null);
    }
}

