/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.rubberband;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.properties.Property;
import com.macrofocus.common.selection.SingleSelectionEvent;
import com.macrofocus.common.selection.SingleSelectionListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.AbstractIDrawing;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.colortheme.ColorTheme;
import org.mkui.rubberband.RubberBand;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J2\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001e"}, d2={"Lorg/mkui/rubberband/RubberbandDrawing;", "Lorg/mkui/graphics/AbstractIDrawing;", "rubberband", "Lorg/mkui/rubberband/RubberBand;", "(Lorg/mkui/rubberband/RubberBand;)V", "colorTheme", "Lcom/macrofocus/common/properties/Property;", "Lorg/mkui/graphics/colortheme/ColorTheme;", "getColorTheme", "()Lcom/macrofocus/common/properties/Property;", "isActive", "", "()Z", "rubberbandListener", "Lcom/macrofocus/common/selection/SingleSelectionListener;", "Lorg/mkui/geom/Rectangle2D;", "getRubberbandListener", "()Lcom/macrofocus/common/selection/SingleSelectionListener;", "draw", "", "g", "Lorg/mkui/graphics/IGraphics;", "point", "Lorg/mkui/geom/Point2D;", "width", "", "height", "clipBounds", "Lorg/mkui/geom/Rectangle;", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public abstract class RubberbandDrawing
extends AbstractIDrawing {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final RubberBand rubberband;
    @NotNull
    private final SingleSelectionListener<Rectangle2D> rubberbandListener;
    public static final int $stable = 8;
    private static final double rubberbandStroke = 1.0;

    public RubberbandDrawing(@NotNull RubberBand rubberband) {
        Intrinsics.checkNotNullParameter((Object)rubberband, (String)"rubberband");
        this.rubberbandListener = (SingleSelectionListener)new SingleSelectionListener<Rectangle2D>(this){
            final /* synthetic */ RubberbandDrawing this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull SingleSelectionEvent<Rectangle2D> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                RubberbandDrawing.access$notifyIDrawingChanged(this.this$0);
            }
        };
        this.rubberband = rubberband;
        rubberband.getRubberBand().addSingleSelectionListener(this.rubberbandListener);
    }

    @NotNull
    public final SingleSelectionListener<Rectangle2D> getRubberbandListener() {
        return this.rubberbandListener;
    }

    @NotNull
    protected abstract Property<ColorTheme> getColorTheme();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isActive() {
        if (!this.rubberband.getRubberBand().isActive()) return false;
        Object object = this.rubberband.getRubberBand().getSelected();
        Intrinsics.checkNotNull((Object)object);
        if (((Rectangle2D)object).getWidth() == 0.0) {
            return false;
        }
        boolean bl = false;
        if (bl) return false;
        Object object2 = this.rubberband.getRubberBand().getSelected();
        Intrinsics.checkNotNull((Object)object2);
        if (((Rectangle2D)object2).getHeight() != 0.0) return true;
        return false;
    }

    @Override
    public void draw(@NotNull IGraphics g2, @Nullable Point2D point, double width, double height, @NotNull Rectangle clipBounds) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
        Intrinsics.checkNotNullParameter((Object)clipBounds, (String)"clipBounds");
        float[] fArray = new float[]{10.0f, 2.0f, 2.0f, 2.0f};
        float[] dashPattern = fArray;
        g2.setLineWidth(1.0);
        g2.setLineDash(dashPattern);
        if (((ColorTheme)this.getColorTheme().getValue()).isDark()) {
            g2.setColor(MkColorKt.colorOf(255, 255, 255, 220));
        } else {
            g2.setColor(MkColorKt.colorOf(0, 0, 0, 220));
        }
        Rectangle2D rectangle2D = this.rubberband.getRubberBandScreen();
        Intrinsics.checkNotNull((Object)rectangle2D);
        g2.drawShape(rectangle2D);
    }

    public static final /* synthetic */ void access$notifyIDrawingChanged(RubberbandDrawing $this) {
        $this.notifyIDrawingChanged();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/mkui/rubberband/RubberbandDrawing$Companion;", "", "()V", "rubberbandStroke", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

