/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.DrawScopeLayer;
import org.mkui.canvas.PaletteProvider;
import org.mkui.color.MkColor;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.IDrawing;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001d\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/mkui/canvas/DirectSwingLayer;", "Lorg/mkui/canvas/DrawScopeLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "color", "Lorg/mkui/color/MkColor;", "<init>", "(Lorg/mkui/graphics/IDrawing;Lorg/mkui/color/MkColor;)V", "width", "", "height", "prepare", "", "", "render", "g", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class DirectSwingLayer
implements DrawScopeLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDrawing iDrawing;
    @Nullable
    private final MkColor color;
    private double width;
    private double height;
    public static final int $stable = 8;

    @JvmOverloads
    public DirectSwingLayer(@NotNull IDrawing iDrawing, @Nullable MkColor color) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.color = color;
    }

    public /* synthetic */ DirectSwingLayer(IDrawing iDrawing, MkColor mkColor, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            mkColor = null;
        }
        this(iDrawing, mkColor);
    }

    @Override
    public void prepare(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void render(@Nullable DrawScope g2) {
        if (this.iDrawing.isActive()) {
            // empty if block
        }
    }

    @JvmOverloads
    public DirectSwingLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this(iDrawing, null, 2, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003JL\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/mkui/canvas/DirectSwingLayer$Companion;", "", "<init>", "()V", "draw", "", "g2", "Ljava/awt/Graphics2D;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "width", "", "height", "antialiasing", "", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "color", "Lorg/mkui/color/MkColor;", "composite", "Ljava/awt/Composite;", "mkui"})
    @SourceDebugExtension(value={"SMAP\nDirectSwingLayer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DirectSwingLayer.kt\norg/mkui/canvas/DirectSwingLayer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,98:1\n1#2:99\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void draw(@NotNull Graphics2D g2, @NotNull IDrawing iDrawing, double width, double height, boolean antialiasing, @Nullable PaletteProvider paletteProvider, @Nullable MkColor color, @Nullable Composite composite) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
            Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
            MkColor color2 = color;
            Composite oldComposite = g2.getComposite();
            RenderingHints hints = g2.getRenderingHints();
            if (antialiasing) {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
            }
            java.awt.Color oldColor = g2.getColor();
            if (color2 == null && paletteProvider != null) {
                MkColor start = paletteProvider.getPalette().getColor(0.0);
                MkColor end = paletteProvider.getPalette().getColor(1.0);
                float s = Color.getRed-impl((long)start.getNative-0d7_KjU()) / 255.0f;
                float e = Color.getRed-impl((long)end.getNative-0d7_KjU()) / 255.0f;
                if (e > s) {
                    color2 = end;
                    if (composite == null) {
                        boolean bl;
                        float alpha = 0.0f;
                        alpha = e > 0.0f ? s / e : 0.0f;
                        boolean bl2 = bl = alpha >= 0.0f && alpha <= 1.0f;
                        if (_Assertions.ENABLED && !bl) {
                            boolean $i$a$-assert-DirectSwingLayer$Companion$draw$32 = false;
                            String $i$a$-assert-DirectSwingLayer$Companion$draw$32 = "alpha value of " + alpha + " out of range";
                            throw new AssertionError((Object)$i$a$-assert-DirectSwingLayer$Companion$draw$32);
                        }
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                    }
                } else {
                    color2 = end;
                    if (composite == null) {
                        boolean bl;
                        float alpha = 0.0f;
                        alpha = e < 1.0f ? (1.0f - s) / (1.0f - e) : 0.0f;
                        boolean bl3 = bl = alpha >= 0.0f && alpha <= 1.0f;
                        if (_Assertions.ENABLED && !bl) {
                            boolean bl4 = false;
                            String string = "alpha value of " + alpha + " out of range " + (1.0f - s) + "/" + (1.0f - e);
                            throw new AssertionError((Object)string);
                        }
                        g2.setComposite(AlphaComposite.getInstance(3, alpha));
                    }
                }
            } else if (color2 != null) {
                // empty if block
            }
            if (composite != null) {
                g2.setComposite(composite);
            }
            java.awt.Rectangle clipBounds = g2.getClipBounds();
            Rectangle bounds = null;
            bounds = clipBounds != null ? new Rectangle(clipBounds.x, clipBounds.y, clipBounds.width, clipBounds.height) : new Rectangle(0, 0, (int)width, (int)height);
            g2.setRenderingHints(hints);
            g2.setColor(oldColor);
            g2.setComposite(oldComposite);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

