/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.ArrayFnKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Curve;
import org.mkui.geom.PathIterator;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\b'\u0018\u0000 12\u00020\u0001:\u0003/01B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0006\u0010\u001d\u001a\u00020\u001eJ&\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J.\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0012J \u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0012H&J\u001e\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0018J\u001e\u0010+\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010*\u001a\u00020\u0018J\u0018\u0010.\u001a\u00020 2\u0006\u0010'\u001a\u00020\u00032\u0006\u0010(\u001a\u00020\u0003H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010,\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u00062"}, d2={"Lorg/mkui/geom/Crossings;", "", "xLo", "", "yLo", "xHi", "yHi", "<init>", "(DDDD)V", "getXLo", "()D", "getYLo", "getXHi", "getYHi", "tmp", "", "Lorg/mkui/geom/Curve;", "limit", "", "getLimit", "()I", "setLimit", "(I)V", "yranges", "", "getYranges", "()[D", "setYranges", "([D)V", "print", "", "accumulateLine", "", "x0", "y0", "x1", "y1", "direction", "record", "ystart", "yend", "accumulateQuad", "coords", "accumulateCubic", "isEmpty", "()Z", "covers", "EvenOdd", "NonZero", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public abstract class Crossings {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double xLo;
    private final double yLo;
    private final double xHi;
    private final double yHi;
    @NotNull
    private final List<Curve> tmp;
    private int limit;
    @NotNull
    private double[] yranges;
    public static final int $stable = 8;
    public static final boolean debug = false;

    public Crossings(double xLo, double yLo, double xHi, double yHi) {
        this.xLo = xLo;
        this.yLo = yLo;
        this.xHi = xHi;
        this.yHi = yHi;
        this.tmp = new ArrayList();
        this.yranges = new double[10];
    }

    public final double getXLo() {
        return this.xLo;
    }

    public final double getYLo() {
        return this.yLo;
    }

    public final double getXHi() {
        return this.xHi;
    }

    public final double getYHi() {
        return this.yHi;
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    @NotNull
    public final double[] getYranges() {
        return this.yranges;
    }

    public final void setYranges(@NotNull double[] dArray) {
        Intrinsics.checkNotNullParameter((Object)dArray, (String)"<set-?>");
        this.yranges = dArray;
    }

    public final void print() {
        System.out.println((Object)"Crossings [");
        System.out.println((Object)("  bounds = [" + this.yLo + ", " + this.yHi + "]"));
        for (int i = 0; i < this.limit; i += 2) {
            System.out.println((Object)("  [" + this.yranges[i] + ", " + this.yranges[i + 1] + "]"));
        }
        System.out.println((Object)"]");
    }

    public final boolean accumulateLine(double x0, double y0, double x1, double y1) {
        return y0 <= y1 ? this.accumulateLine(x0, y0, x1, y1, 1) : this.accumulateLine(x1, y1, x0, y0, -1);
    }

    public final boolean accumulateLine(double x0, double y0, double x1, double y1, int direction) {
        if (this.yHi <= y0 || this.yLo >= y1) {
            return false;
        }
        if (x0 >= this.xHi && x1 >= this.xHi) {
            return false;
        }
        if (y0 == y1) {
            return x0 >= this.xLo || x1 >= this.xLo;
        }
        double xstart = 0.0;
        double ystart = 0.0;
        double dx = x1 - x0;
        double dy = y1 - y0;
        if (y0 < this.yLo) {
            xstart = x0 + (this.yLo - y0) * dx / dy;
            ystart = this.yLo;
        } else {
            xstart = x0;
            ystart = y0;
        }
        double yend = 0.0;
        double xend = 0.0;
        if (this.yHi < y1) {
            xend = x0 + (this.yHi - y0) * dx / dy;
            yend = this.yHi;
        } else {
            xend = x1;
            yend = y1;
        }
        if (xstart >= this.xHi && xend >= this.xHi) {
            return false;
        }
        if (xstart > this.xLo || xend > this.xLo) {
            return true;
        }
        this.record(ystart, yend, direction);
        return false;
    }

    public abstract void record(double var1, double var3, int var5);

    public final boolean accumulateQuad(double x0, double y0, @NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (y0 < this.yLo && coords[1] < this.yLo && coords[3] < this.yLo) {
            return false;
        }
        if (y0 > this.yHi && coords[1] > this.yHi && coords[3] > this.yHi) {
            return false;
        }
        if (x0 > this.xHi && coords[0] > this.xHi && coords[2] > this.xHi) {
            return false;
        }
        if (x0 < this.xLo && coords[0] < this.xLo && coords[2] < this.xLo) {
            if (y0 < coords[3]) {
                this.record(Math.max(y0, this.yLo), Math.min(coords[3], this.yHi), 1);
            } else if (y0 > coords[3]) {
                this.record(Math.max(coords[3], this.yLo), Math.min(y0, this.yHi), -1);
            }
            return false;
        }
        Curve.Companion.insertQuad(this.tmp, x0, y0, coords);
        for (Curve c : this.tmp) {
            if (!c.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public final boolean accumulateCubic(double x0, double y0, @NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        if (y0 < this.yLo && coords[1] < this.yLo && coords[3] < this.yLo && coords[5] < this.yLo) {
            return false;
        }
        if (y0 > this.yHi && coords[1] > this.yHi && coords[3] > this.yHi && coords[5] > this.yHi) {
            return false;
        }
        if (x0 > this.xHi && coords[0] > this.xHi && coords[2] > this.xHi && coords[4] > this.xHi) {
            return false;
        }
        if (x0 < this.xLo && coords[0] < this.xLo && coords[2] < this.xLo && coords[4] < this.xLo) {
            if (y0 <= coords[5]) {
                this.record(Math.max(y0, this.yLo), Math.min(coords[5], this.yHi), 1);
            } else {
                this.record(Math.max(coords[5], this.yLo), Math.min(y0, this.yHi), -1);
            }
            return false;
        }
        Curve.Companion.insertCubic(this.tmp, x0, y0, coords);
        for (Curve c : this.tmp) {
            if (!c.accumulateCrossings(this)) continue;
            return true;
        }
        this.tmp.clear();
        return false;
    }

    public final boolean isEmpty() {
        return this.limit == 0;
    }

    public abstract boolean covers(double var1, double var3);

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0010\u0010\b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fJ0\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/mkui/geom/Crossings$Companion;", "", "<init>", "()V", "debug", "", "findCrossings", "Lorg/mkui/geom/Crossings;", "curves", "", "Lorg/mkui/geom/Curve;", "xlo", "", "ylo", "xhi", "yhi", "pi", "Lorg/mkui/geom/PathIterator;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Crossings findCrossings(@NotNull List<? extends Curve> curves, double xlo, double ylo, double xhi, double yhi) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            Crossings cross = new EvenOdd(xlo, ylo, xhi, yhi);
            Iterator<? extends Curve> iterator = curves.iterator();
            while (iterator.hasNext()) {
                Curve c;
                Curve curve = c = iterator.next();
                Intrinsics.checkNotNull((Object)curve);
                if (!curve.accumulateCrossings(cross)) continue;
                return null;
            }
            return cross;
        }

        @Nullable
        public final Crossings findCrossings(@NotNull PathIterator pi, double xlo, double ylo, double xhi, double yhi) {
            Intrinsics.checkNotNullParameter((Object)pi, (String)"pi");
            Crossings cross = null;
            cross = pi.getWindingRule() == 0 ? (Crossings)new EvenOdd(xlo, ylo, xhi, yhi) : (Crossings)new NonZero(xlo, ylo, xhi, yhi);
            double[] coords = new double[23];
            double movx = 0.0;
            double movy = 0.0;
            double curx = 0.0;
            double cury = 0.0;
            while (!pi.isDone()) {
                int type = pi.currentSegment(coords);
                double newy = 0.0;
                double newx = 0.0;
                switch (type) {
                    case 0: {
                        if (!(movy == cury) && cross.accumulateLine(curx, cury, movx, movy)) {
                            return null;
                        }
                        Companion $this$findCrossings_u24lambda_u240 = this;
                        boolean bl = false;
                        movx = curx = coords[0];
                        Companion $this$findCrossings_u24lambda_u241 = this;
                        boolean bl2 = false;
                        movy = cury = coords[1];
                        break;
                    }
                    case 1: {
                        newx = coords[0];
                        newy = coords[1];
                        if (cross.accumulateLine(curx, cury, newx, newy)) {
                            return null;
                        }
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 2: {
                        newx = coords[2];
                        newy = coords[3];
                        if (cross.accumulateQuad(curx, cury, coords)) {
                            return null;
                        }
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 3: {
                        newx = coords[4];
                        newy = coords[5];
                        if (cross.accumulateCubic(curx, cury, coords)) {
                            return null;
                        }
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 4: {
                        if (!(movy == cury) && cross.accumulateLine(curx, cury, movx, movy)) {
                            return null;
                        }
                        curx = movx;
                        cury = movy;
                    }
                }
                pi.next();
            }
            if (!(movy == cury) && cross.accumulateLine(curx, cury, movx, movy)) {
                return null;
            }
            return cross;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/mkui/geom/Crossings$EvenOdd;", "Lorg/mkui/geom/Crossings;", "xlo", "", "ylo", "xhi", "yhi", "<init>", "(DDDD)V", "record", "", "ystart", "yend", "direction", "", "covers", "", "mkui"})
    @StabilityInferred(parameters=0)
    public static final class EvenOdd
    extends Crossings {
        public static final int $stable = 8;

        public EvenOdd(double xlo, double ylo, double xhi, double yhi) {
            super(xlo, ylo, xhi, yhi);
        }

        @Override
        public void record(double ystart, double yend, int direction) {
            int from;
            double ystart2 = ystart;
            double yend2 = yend;
            if (ystart2 >= yend2) {
                return;
            }
            for (from = 0; from < this.getLimit() && ystart2 > this.getYranges()[from + 1]; from += 2) {
            }
            int to = from;
            while (from < this.getLimit()) {
                double yrlo = this.getYranges()[from++];
                double yrhi = this.getYranges()[from++];
                if (yend2 < yrlo) {
                    this.getYranges()[to++] = ystart2;
                    this.getYranges()[to++] = yend2;
                    ystart2 = yrlo;
                    yend2 = yrhi;
                    continue;
                }
                double yll = 0.0;
                double ylh = 0.0;
                if (ystart2 < yrlo) {
                    yll = ystart2;
                    ylh = yrlo;
                } else {
                    yll = yrlo;
                    ylh = ystart2;
                }
                double yhh = 0.0;
                double yhl = 0.0;
                if (yend2 < yrhi) {
                    yhl = yend2;
                    yhh = yrhi;
                } else {
                    yhl = yrhi;
                    yhh = yend2;
                }
                if (ylh == yhl) {
                    ystart2 = yll;
                    yend2 = yhh;
                } else {
                    if (ylh > yhl) {
                        ystart2 = yhl;
                        yhl = ylh;
                        ylh = ystart2;
                    }
                    if (!(yll == ylh)) {
                        this.getYranges()[to++] = yll;
                        this.getYranges()[to++] = ylh;
                    }
                    ystart2 = yhl;
                    yend2 = yhh;
                }
                if (!(ystart2 >= yend2)) continue;
            }
            if (to < from && from < this.getLimit()) {
                ArrayFnKt.arraycopy((double[])this.getYranges(), (int)from, (double[])this.getYranges(), (int)to, (int)(this.getLimit() - from));
            }
            to += this.getLimit() - from;
            if (ystart2 < yend2) {
                if (to >= this.getYranges().length) {
                    double[] newranges = new double[to + 10];
                    ArrayFnKt.arraycopy((double[])this.getYranges(), (int)0, (double[])newranges, (int)0, (int)to);
                    this.setYranges(newranges);
                }
                this.getYranges()[to++] = ystart2;
                this.getYranges()[to++] = yend2;
            }
            this.setLimit(to);
        }

        @Override
        public boolean covers(double ystart, double yend) {
            return this.getLimit() == 2 && this.getYranges()[0] <= ystart && this.getYranges()[1] >= yend;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0003H\u0016J\u000e\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0010J&\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0006\u0010\u0018\u001a\u00020\u0010R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/mkui/geom/Crossings$NonZero;", "Lorg/mkui/geom/Crossings;", "xlo", "", "ylo", "xhi", "yhi", "<init>", "(DDDD)V", "crosscounts", "", "record", "", "ystart", "yend", "direction", "", "covers", "", "remove", "cur", "insert", "lo", "hi", "dir", "mkui"})
    @StabilityInferred(parameters=0)
    public static final class NonZero
    extends Crossings {
        @NotNull
        private int[] crosscounts = new int[this.getYranges().length / 2];
        public static final int $stable = 8;

        public NonZero(double xlo, double ylo, double xhi, double yhi) {
            super(xlo, ylo, xhi, yhi);
        }

        @Override
        public void record(double ystart, double yend, int direction) {
            int cur;
            double ystart2 = ystart;
            if (ystart2 >= yend) {
                return;
            }
            for (cur = 0; cur < this.getLimit() && ystart2 > this.getYranges()[cur + 1]; cur += 2) {
            }
            if (cur < this.getLimit()) {
                int rdir = this.crosscounts[cur / 2];
                double yrlo = this.getYranges()[cur + 0];
                double yrhi = this.getYranges()[cur + 1];
                if (yrhi == ystart2 && rdir == direction) {
                    if (cur + 2 == this.getLimit()) {
                        this.getYranges()[cur + 1] = yend;
                        return;
                    }
                    this.remove(cur);
                    ystart2 = yrlo;
                    rdir = this.crosscounts[cur / 2];
                    yrlo = this.getYranges()[cur + 0];
                    yrhi = this.getYranges()[cur + 1];
                }
                if (yend < yrlo) {
                    this.insert(cur, ystart2, yend, direction);
                    return;
                }
                if (yend == yrlo && rdir == direction) {
                    this.getYranges()[cur] = ystart2;
                    return;
                }
                if (ystart2 < yrlo) {
                    this.insert(cur, ystart2, yrlo, direction);
                    cur += 2;
                    ystart2 = yrlo;
                } else if (yrlo < ystart2) {
                    this.insert(cur, yrlo, ystart2, rdir);
                    cur += 2;
                }
                int newdir = rdir + direction;
                double newend = Math.min(yend, yrhi);
                if (newdir == 0) {
                    this.remove(cur);
                } else {
                    this.crosscounts[cur / 2] = newdir;
                    this.getYranges()[cur++] = ystart2;
                    this.getYranges()[cur++] = newend;
                }
                ystart2 = yrlo = newend;
                if (yrlo < yrhi) {
                    this.insert(cur, yrlo, yrhi, rdir);
                }
            }
            if (ystart2 < yend) {
                this.insert(cur, ystart2, yend, direction);
            }
        }

        @Override
        public boolean covers(double ystart, double yend) {
            double ystart2 = ystart;
            int i = 0;
            while (i < this.getLimit()) {
                double ylo = this.getYranges()[i++];
                double yhi = this.getYranges()[i++];
                if (ystart2 >= yhi) continue;
                if (ystart2 < ylo) {
                    return false;
                }
                if (yend <= yhi) {
                    return true;
                }
                ystart2 = yhi;
            }
            return ystart2 >= yend;
        }

        public final void remove(int cur) {
            this.setLimit(this.getLimit() - 2);
            int rem = this.getLimit() - cur;
            if (rem > 0) {
                ArrayFnKt.arraycopy((double[])this.getYranges(), (int)(cur + 2), (double[])this.getYranges(), (int)cur, (int)rem);
                ArrayFnKt.arraycopy((int[])this.crosscounts, (int)(cur / 2 + 1), (int[])this.crosscounts, (int)(cur / 2), (int)(rem / 2));
            }
        }

        public final void insert(int cur, double lo, double hi, int dir) {
            int rem = this.getLimit() - cur;
            double[] oldranges = this.getYranges();
            int[] oldcounts = this.crosscounts;
            if (this.getLimit() >= this.getYranges().length) {
                this.setYranges(new double[this.getLimit() + 10]);
                ArrayFnKt.arraycopy((double[])oldranges, (int)0, (double[])this.getYranges(), (int)0, (int)cur);
                this.crosscounts = new int[(this.getLimit() + 10) / 2];
                ArrayFnKt.arraycopy((int[])oldcounts, (int)0, (int[])this.crosscounts, (int)0, (int)(cur / 2));
            }
            if (rem > 0) {
                ArrayFnKt.arraycopy((double[])oldranges, (int)cur, (double[])this.getYranges(), (int)(cur + 2), (int)rem);
                ArrayFnKt.arraycopy((int[])oldcounts, (int)(cur / 2), (int[])this.crosscounts, (int)(cur / 2 + 1), (int)(rem / 2));
            }
            this.getYranges()[cur + 0] = lo;
            this.getYranges()[cur + 1] = hi;
            this.crosscounts[cur / 2] = dir;
            this.setLimit(this.getLimit() + 2);
        }
    }
}

