/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Curve;
import org.mkui.geom.Order0;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000J&\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010 \u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\fR\u0011\u0010$\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\fR\u0011\u0010&\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u0012R\u0011\u0010(\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u0012R\u0011\u0010*\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b+\u0010\u0012\u00a8\u0006,"}, d2={"Lorg/mkui/geom/CurveLink;", "", "curve", "Lorg/mkui/geom/Curve;", "ystart", "", "yend", "etag", "", "<init>", "(Lorg/mkui/geom/Curve;DDI)V", "getCurve", "()Lorg/mkui/geom/Curve;", "edgeTag", "getEdgeTag", "()I", "yTop", "getYTop", "()D", "setYTop", "(D)V", "yBot", "getYBot", "setYBot", "next", "getNext", "()Lorg/mkui/geom/CurveLink;", "setNext", "(Lorg/mkui/geom/CurveLink;)V", "absorb", "", "link", "isEmpty", "()Z", "subCurve", "getSubCurve", "moveto", "getMoveto", "xTop", "getXTop", "xBot", "getXBot", "x", "getX", "mkui"})
@StabilityInferred(parameters=0)
public final class CurveLink {
    @NotNull
    private final Curve curve;
    private final int edgeTag;
    private double yTop;
    private double yBot;
    @Nullable
    private CurveLink next;
    public static final int $stable = 8;

    public CurveLink(@NotNull Curve curve, double ystart, double yend, int etag) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        this.curve = curve;
        this.yTop = ystart;
        this.yBot = yend;
        this.edgeTag = etag;
        if (this.yTop < curve.getYTop() || this.yBot > curve.getYBot()) {
            throw new UnsupportedOperationException("bad curvelink [" + this.yTop + "=>" + this.yBot + "] for " + curve);
        }
    }

    @NotNull
    public final Curve getCurve() {
        return this.curve;
    }

    public final int getEdgeTag() {
        return this.edgeTag;
    }

    public final double getYTop() {
        return this.yTop;
    }

    public final void setYTop(double d) {
        this.yTop = d;
    }

    public final double getYBot() {
        return this.yBot;
    }

    public final void setYBot(double d) {
        this.yBot = d;
    }

    @Nullable
    public final CurveLink getNext() {
        return this.next;
    }

    public final void setNext(@Nullable CurveLink curveLink) {
        this.next = curveLink;
    }

    public final boolean absorb(@NotNull CurveLink link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return this.absorb(link.curve, link.yTop, link.yBot, link.edgeTag);
    }

    public final boolean absorb(@NotNull Curve curve, double ystart, double yend, int etag) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        if (this.curve != curve || this.edgeTag != etag || this.yBot < ystart || this.yTop > yend) {
            return false;
        }
        if (ystart < curve.getYTop() || yend > curve.getYBot()) {
            throw new UnsupportedOperationException("bad curvelink [" + ystart + "=>" + yend + "] for " + curve);
        }
        this.yTop = Math.min(this.yTop, ystart);
        this.yBot = Math.max(this.yBot, yend);
        return true;
    }

    public final boolean isEmpty() {
        return this.yTop == this.yBot;
    }

    @NotNull
    public final Curve getSubCurve() {
        return this.yTop == this.curve.getYTop() && this.yBot == this.curve.getYBot() ? this.curve.getWithDirection(this.edgeTag) : this.curve.getSubCurve(this.yTop, this.yBot, this.edgeTag);
    }

    @NotNull
    public final Curve getMoveto() {
        return new Order0(this.getXTop(), this.yTop);
    }

    public final double getXTop() {
        return this.curve.XforY(this.yTop);
    }

    public final double getXBot() {
        return this.curve.XforY(this.yBot);
    }

    public final double getX() {
        return this.curve.XforY(this.yTop);
    }
}

