/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.AbstractRectangle2D;
import org.mkui.geom.Path;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0017\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0005B)\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0002\u0010\u000bJ\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u001cH\u0016J\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010\u001f\u001a\u00020\u00002\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010#\u001a\u00020$H\u0016J\u0011\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0096\u0002J\b\u0010.\u001a\u00020\u001bH\u0016J(\u00101\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u001cH\u0016J(\u0010*\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001c2\u0006\u00103\u001a\u00020\u001cH\u0016J\u0018\u0010*\u001a\u00020+2\u0006\u0010\u0006\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\u001cH\u0016R\u001a\u0010\f\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001a\u0010\u0014\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001a\u0010\u0017\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010\b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010&R\u0014\u0010\t\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0014\u0010\n\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010&R\u0014\u0010/\u001a\u00020+8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00104\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b4\u00100\u00a8\u00065"}, d2={"Lorg/mkui/geom/Rectangle;", "Lorg/mkui/geom/AbstractRectangle2D;", "<init>", "()V", "rectangle", "(Lorg/mkui/geom/Rectangle;)V", "x", "", "y", "width", "height", "(IIII)V", "ix", "getIx", "()I", "setIx", "(I)V", "iy", "getIy", "setIy", "iwidth", "getIwidth", "setIwidth", "iheight", "getIheight", "setIheight", "add", "Lorg/mkui/geom/Rectangle2D;", "", "toPath", "Lorg/mkui/geom/Path;", "intersection", "r", "setX", "", "toString", "", "getX", "()D", "getY", "getWidth", "getHeight", "contains", "", "point", "Lorg/mkui/geom/Point2D;", "normalize", "isNormalized", "()Z", "intersects", "w", "h", "isEmpty", "mkui"})
@StabilityInferred(parameters=0)
public final class Rectangle
extends AbstractRectangle2D {
    private int ix;
    private int iy;
    private int iwidth;
    private int iheight;
    public static final int $stable = 8;

    public final int getIx() {
        return this.ix;
    }

    public final void setIx(int n) {
        this.ix = n;
    }

    public final int getIy() {
        return this.iy;
    }

    public final void setIy(int n) {
        this.iy = n;
    }

    public final int getIwidth() {
        return this.iwidth;
    }

    public final void setIwidth(int n) {
        this.iwidth = n;
    }

    public final int getIheight() {
        return this.iheight;
    }

    public final void setIheight(int n) {
        this.iheight = n;
    }

    public Rectangle() {
    }

    public Rectangle(@NotNull Rectangle rectangle) {
        Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
        this.ix = rectangle.ix;
        this.iy = rectangle.iy;
        this.iwidth = rectangle.iwidth;
        this.iheight = rectangle.iheight;
    }

    public Rectangle(int x, int y, int width, int height) {
        this.ix = x;
        this.iy = y;
        this.iwidth = width;
        this.iheight = height;
    }

    @Override
    @NotNull
    public Rectangle2D add(double x, double y) {
        double x1 = Math.min(this.getMinX(), x);
        double x2 = Math.max(this.getMaxX(), x);
        double y1 = Math.min(this.getMinY(), y);
        double y2 = Math.max(this.getMaxY(), y);
        return new Rectangle2D.Double(x1, y1, x2 - x1, y2 - y1);
    }

    @NotNull
    public final Path toPath() {
        Path path = new Path();
        path.moveTo(this.getX(), this.getY());
        path.lineTo(this.getX() + this.getWidth(), this.getY());
        path.lineTo(this.getX() + this.getWidth(), this.getY() + this.getHeight());
        path.lineTo(this.getX(), this.getY() + this.getHeight());
        path.close();
        return path;
    }

    @NotNull
    public final Rectangle intersection(@NotNull Rectangle r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        int tx1 = this.ix;
        int ty1 = this.iy;
        int rx1 = r.ix;
        int ry1 = r.iy;
        int tx2 = tx1;
        tx2 += this.iwidth;
        int ty2 = ty1;
        ty2 += this.iheight;
        int rx2 = rx1;
        rx2 += r.iwidth;
        int ry2 = ry1;
        ry2 += r.iheight;
        if (tx1 < rx1) {
            tx1 = rx1;
        }
        if (ty1 < ry1) {
            ty1 = ry1;
        }
        if (tx2 > rx2) {
            tx2 = rx2;
        }
        if (ty2 > ry2) {
            ty2 = ry2;
        }
        ty2 -= ty1;
        if ((tx2 -= tx1) < Integer.MIN_VALUE) {
            tx2 = Integer.MIN_VALUE;
        }
        if (ty2 < Integer.MIN_VALUE) {
            ty2 = Integer.MIN_VALUE;
        }
        return new Rectangle(tx1, ty1, tx2, ty2);
    }

    public final void setX(int x) {
        this.ix = x;
    }

    @NotNull
    public String toString() {
        return "Rectangle{x=" + this.getX() + ", y=" + this.getY() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + "}";
    }

    @Override
    public double getX() {
        return this.ix;
    }

    @Override
    public double getY() {
        return this.iy;
    }

    @Override
    public double getWidth() {
        return this.iwidth;
    }

    @Override
    public double getHeight() {
        return this.iheight;
    }

    @Override
    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return point.getY() >= this.getY() && point.getY() <= this.getY() + this.getHeight() && point.getX() >= this.getX() && point.getX() <= this.getX() + this.getWidth();
    }

    @Override
    @NotNull
    public Rectangle2D normalize() {
        if (this.isNormalized()) {
            return this;
        }
        int normalizedX = this.ix;
        int normalizedY = this.iy;
        int normalizedWidth = this.iwidth;
        int normalizedHeight = this.iheight;
        if (normalizedWidth < 0) {
            normalizedWidth = -normalizedWidth;
            normalizedX -= normalizedWidth;
        }
        if (normalizedHeight < 0) {
            normalizedHeight = -normalizedHeight;
            normalizedY -= this.iheight;
        }
        return new Rectangle(normalizedX, normalizedY, normalizedWidth, normalizedHeight);
    }

    private final boolean isNormalized() {
        return this.getWidth() >= 0.0 && this.getHeight() >= 0.0;
    }

    @Override
    public boolean intersects(double x, double y, double w, double h) {
        return this.intersects(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public boolean contains(double x, double y, double w, double h) {
        if (this.isEmpty() || w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x0 = x;
        double y0 = y;
        return x >= x0 && y >= y0 && x + w <= x0 + this.getWidth() && y + h <= y0 + this.getHeight();
    }

    @Override
    public boolean contains(double x, double y) {
        return this.contains(new Point2D.Double(x, y));
    }

    public final boolean isEmpty() {
        return this.getWidth() <= 0.0 || this.getHeight() <= 0.0;
    }
}

