/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.transform.OneDScreenTransform;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.AffineTransform;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lorg/mkui/geom/ScreenTransformHelper;", "", "<init>", "()V", "worldToScreen", "Lorg/mkui/geom/AffineTransform;", "xModel", "Lcom/macrofocus/common/transform/OneDScreenTransform;", "yModel", "mkui"})
@StabilityInferred(parameters=1)
public final class ScreenTransformHelper {
    @NotNull
    public static final ScreenTransformHelper INSTANCE = new ScreenTransformHelper();
    public static final int $stable;

    private ScreenTransformHelper() {
    }

    @NotNull
    public final AffineTransform worldToScreen(@NotNull OneDScreenTransform xModel, @NotNull OneDScreenTransform yModel) {
        AffineTransform affineTransform;
        Intrinsics.checkNotNullParameter((Object)xModel, (String)"xModel");
        Intrinsics.checkNotNullParameter((Object)yModel, (String)"yModel");
        if (yModel.isWorldCoordinatesInverted()) {
            double xs = (double)xModel.getScreenSize() / xModel.getWorldRange();
            double ys = (double)yModel.getScreenSize() / yModel.getWorldRange();
            AffineTransform at = new AffineTransform();
            at.setToScale(xs, ys);
            at.translate(-xModel.getWorldMin(), -yModel.getWorldMin());
            affineTransform = at;
        } else {
            double xs = (double)xModel.getScreenSize() / xModel.getWorldRange();
            double ys = (double)yModel.getScreenSize() / yModel.getWorldRange();
            double tx = -xModel.getWorldMin() * xs;
            double ty = yModel.getWorldMin() * ys + (double)yModel.getScreenSize();
            affineTransform = new AffineTransform(xs, 0.0, 0.0, -ys, tx, ty);
        }
        return affineTransform;
    }
}

