/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.curve.BinaryCurveApproximationAlgorithm;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ParametricCurve;
import org.mkui.geom.curve.ValueVector;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0006\b\u0017\u0018\u0000 -2\u00020\u0001:\u0001-B\u001d\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\u001d\u001a\u00020\u000eJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u000eJ\u0006\u0010 \u001a\u00020\u000eJ\u000e\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u000eJ\u0010\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\u001c2\u0006\u0010'\u001a\u00020(H\u0016J\u0016\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u000eJ\b\u0010,\u001a\u00020\u001cH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Lorg/mkui/geom/curve/BSpline;", "Lorg/mkui/geom/curve/ParametricCurve;", "cp", "Lorg/mkui/geom/curve/ControlPath;", "gi", "Lorg/mkui/geom/curve/GroupIterator;", "<init>", "(Lorg/mkui/geom/curve/ControlPath;Lorg/mkui/geom/curve/GroupIterator;)V", "knotVector", "Lorg/mkui/geom/curve/ValueVector;", "t_min", "", "t_max", "sampleLimit", "", "getSampleLimit", "()I", "setSampleLimit", "(I)V", "degree", "knotVectorType", "useDefaultInterval", "", "getUseDefaultInterval", "()Z", "setUseDefaultInterval", "(Z)V", "setInterval", "", "getDegree", "setDegree", "d", "getKnotVectorType", "setKnotVectorType", "type", "appendTo", "mp", "Lorg/mkui/geom/curve/MultiPath;", "eval", "p", "", "N", "t", "i", "resetMemory", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public class BSpline
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ValueVector knotVector;
    private double t_min;
    private double t_max;
    private int sampleLimit;
    private int degree;
    private int knotVectorType;
    private boolean useDefaultInterval;
    public static final int $stable = 8;
    private static final int UNIFORM_CLAMPED = 0;
    private static final int UNIFORM_UNCLAMPED = 1;
    private static final int NON_UNIFORM = 2;
    @NotNull
    private static int[] a = new int[0];
    @NotNull
    private static int[] c = new int[0];
    @NotNull
    private static double[] knot = new double[0];

    public BSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0};
        this.knotVector = new ValueVector(dArray, 8);
        this.t_max = 1.0;
        this.sampleLimit = 1;
        this.degree = 4;
        this.useDefaultInterval = true;
    }

    @Override
    public int getSampleLimit() {
        return this.sampleLimit;
    }

    public void setSampleLimit(int n) {
        this.sampleLimit = n;
    }

    public final boolean getUseDefaultInterval() {
        return this.useDefaultInterval;
    }

    public final void setUseDefaultInterval(boolean bl) {
        this.useDefaultInterval = bl;
    }

    public final void setInterval(double t_min, double t_max) {
        this.t_min = t_min;
        this.t_max = t_max;
    }

    public final double t_min() {
        return this.t_min;
    }

    public final double t_max() {
        return this.t_max;
    }

    public final int getDegree() {
        return this.degree - 1;
    }

    public final void setDegree(int d) {
        this.degree = d + 1;
    }

    public final int getKnotVectorType() {
        return this.knotVectorType;
    }

    public final void setKnotVectorType(int type) {
        this.knotVectorType = type;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        int numPts = groupIterator2.getGroupSize();
        int f = numPts - this.degree;
        if (f < 0) {
            return;
        }
        int x = numPts + this.degree;
        if (knot.length < x) {
            knot = new double[2 * x];
        }
        double t1 = this.t_min;
        double t2 = this.t_max;
        if (this.knotVectorType == 2) {
            if (this.knotVector.size() != x) {
                return;
            }
            BSpline.knot[0] = this.knotVector.get(0);
            for (int i = 1; i < x; ++i) {
                BSpline.knot[i] = this.knotVector.get(i);
                if (!(knot[i] < knot[i - 1])) continue;
                return;
            }
        } else if (this.knotVectorType == 1) {
            double grad = 1.0 / (double)(x - 1);
            for (int i = 0; i < x; ++i) {
                BSpline.knot[i] = (double)i * grad;
            }
            if (this.useDefaultInterval) {
                t1 = (double)(this.degree - 1) * grad;
                t2 = 1.0 - (double)(this.degree - 1) * grad;
            }
        } else if (this.knotVectorType == 0) {
            int n = this.degree;
            for (int i = 0; i < n; ++i) {
                BSpline.knot[i] = 0.0;
            }
            int j = this.degree;
            double grad = 1.0 / (double)(f + 1);
            int i = 1;
            if (i <= f) {
                while (true) {
                    BSpline.knot[j++] = (double)i * grad;
                    if (i == f) break;
                    ++i;
                }
            }
            for (i = j; i < x; ++i) {
                BSpline.knot[i] = 1.0;
            }
            if (this.useDefaultInterval) {
                t1 = 0.0;
                t2 = 1.0;
            }
        }
        if (a.length < this.degree) {
            a = new int[2 * this.degree];
            c = new int[2 * this.degree];
        }
        double[] p = new double[mp.getDimension() + 1];
        p[mp.getDimension()] = t1;
        this.eval(p);
        if (this.getConnect()) {
            mp.lineTo(p);
        } else {
            mp.moveTo(p);
        }
        BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, t1, t2, mp);
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        int dim = p.length - 1;
        double t = p[dim];
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        int numPts = groupIterator.getGroupSize();
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        groupIterator2.set(0, 0);
        for (int i = 0; i < numPts; ++i) {
            double w = this.N(t, i);
            ControlPath controlPath = this.getCp();
            Intrinsics.checkNotNull((Object)controlPath);
            GroupIterator groupIterator3 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator3);
            double[] loc = controlPath.getPoint(groupIterator3.next()).getLocation();
            for (int j = 0; j < dim; ++j) {
                int n = j;
                p[n] = p[n] + loc[j] * w;
            }
        }
    }

    public final double N(double t, int i) {
        double d = 0.0;
        int n = this.degree;
        block0: for (int j = 0; j < n; ++j) {
            int k;
            double t1 = knot[i + j];
            double t2 = knot[i + j + 1];
            if (!(t >= t1) || !(t <= t2) || t1 == t2) continue;
            int dm2 = this.degree - 2;
            for (k = this.degree - j - 1; -1 < k; --k) {
                BSpline.a[k] = 0;
            }
            if (j > 0) {
                for (k = 0; k < j; ++k) {
                    BSpline.c[k] = k;
                }
                BSpline.c[j] = Integer.MAX_VALUE;
            } else {
                BSpline.c[0] = dm2;
                BSpline.c[1] = this.degree;
            }
            int z = 0;
            while (true) {
                if (c[z] < c[z + 1] - 1) {
                    int n2;
                    double e = 1.0;
                    int bc = 0;
                    int y = dm2 - j;
                    int p = j - 1;
                    int m = dm2;
                    int n3 = this.degree;
                    while (m >= 0) {
                        if (p >= 0 && c[p] == m) {
                            w = i + bc;
                            double kd = knot[w + n3];
                            e *= (kd - t) / (kd - knot[w + 1]);
                            ++bc;
                            --p;
                        } else {
                            w = i + a[y];
                            double kw = knot[w];
                            e *= (t - kw) / (knot[w + n3 - 1] - kw);
                            --y;
                        }
                        --m;
                        --n3;
                    }
                    if (j > 0) {
                        int g2 = 0;
                        boolean reset = false;
                        while (true) {
                            int[] nArray = a;
                            int n4 = ++g2;
                            n2 = nArray[n4];
                            nArray[n4] = n2 + 1;
                            if (a[g2] <= j) break;
                            reset = true;
                        }
                        if (reset) {
                            for (int h = g2 - 1; -1 < h; --h) {
                                BSpline.a[h] = a[g2];
                            }
                        }
                    }
                    d += e;
                    int[] nArray = c;
                    int n5 = z;
                    int n6 = nArray[n5];
                    nArray[n5] = n6 + 1;
                    if (c[z] > dm2) break block0;
                    n2 = z;
                    for (int k2 = 0; k2 < n2; ++k2) {
                        BSpline.c[k2] = k2;
                    }
                    z = 0;
                    continue;
                }
                ++z;
            }
        }
        return d;
    }

    @Override
    public void resetMemory() {
        if (!(a.length == 0)) {
            a = new int[0];
            c = new int[0];
        }
        if (!(knot.length == 0)) {
            knot = new double[0];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/mkui/geom/curve/BSpline$Companion;", "", "<init>", "()V", "UNIFORM_CLAMPED", "", "UNIFORM_UNCLAMPED", "NON_UNIFORM", "a", "", "c", "knot", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

