/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.graphics.Image;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B#\b\u0016\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0005\u0010\fJ2\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\b\u0010\"\u001a\u00020\u0017H\u0016J\u0006\u0010'\u001a\u00020\bJ\u0006\u0010(\u001a\u00020\u0012J\u0010\u0010)\u001a\u00020\u00122\b\u0010\u0007\u001a\u0004\u0018\u00010\bR\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0004\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u001e\u001a\u00020\u001fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010 R\u0014\u0010!\u001a\u00020\u001fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010 R\u0014\u0010#\u001a\u00020$8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010-\u00a8\u0006."}, d2={"Lorg/mkui/graphics/CPImage;", "Lorg/mkui/graphics/Image;", "width", "", "height", "<init>", "(II)V", "g2", "Ljava/awt/Graphics2D;", "(Ljava/awt/Graphics2D;II)V", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "raster", "Ljava/awt/image/WritableRaster;", "physicalWidth", "physicalHeight", "scaleFactor", "", "getWidth", "()I", "getHeight", "setPixels", "", "x", "y", "w", "h", "iArray", "", "isOneSamplePerArrayElement", "", "()Z", "isLoaded", "flush", "_nativeImage", "Ljava/awt/Image;", "get_nativeImage", "()Ljava/awt/Image;", "createGraphics", "getScaleFactor", "findCurrentScaleFactor", "nativeImage", "", "getNativeImage", "()Ljava/lang/Object;", "mkui"})
@StabilityInferred(parameters=0)
public final class CPImage
implements Image {
    @Nullable
    private BufferedImage image;
    @Nullable
    private WritableRaster raster;
    private int physicalWidth;
    private int physicalHeight;
    private double scaleFactor;
    private final boolean isOneSamplePerArrayElement;
    private final boolean isLoaded;
    public static final int $stable = 8;

    public CPImage(int width, int height) {
        this.isOneSamplePerArrayElement = true;
        this.isLoaded = true;
        this.scaleFactor = this.findCurrentScaleFactor(null);
        this.physicalWidth = (int)Math.floor((double)width * this.scaleFactor);
        this.physicalHeight = (int)Math.floor((double)height * this.scaleFactor);
        BufferedImage bufferedImage = this.image = new BufferedImage(this.physicalWidth, this.physicalHeight, 2);
        Intrinsics.checkNotNull((Object)bufferedImage);
        this.raster = bufferedImage.getRaster();
    }

    public CPImage(@Nullable Graphics2D g2, int width, int height) {
        this.isOneSamplePerArrayElement = true;
        this.isLoaded = true;
        this.scaleFactor = this.findCurrentScaleFactor(g2);
        this.physicalWidth = (int)Math.floor((double)width * this.scaleFactor);
        this.physicalHeight = (int)Math.floor((double)height * this.scaleFactor);
        Graphics2D graphics2D = g2;
        GraphicsConfiguration gc = graphics2D != null ? graphics2D.getDeviceConfiguration() : null;
        BufferedImage bufferedImage = this.image = gc != null ? gc.createCompatibleImage(this.physicalWidth, this.physicalHeight, 3) : new BufferedImage(this.physicalWidth, this.physicalHeight, 2);
        Intrinsics.checkNotNull((Object)bufferedImage);
        this.raster = bufferedImage.getRaster();
    }

    public CPImage(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.isOneSamplePerArrayElement = true;
        this.isLoaded = true;
        this.image = image;
        this.raster = image.getRaster();
    }

    @Override
    public int getWidth() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        return bufferedImage.getWidth();
    }

    @Override
    public int getHeight() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        return bufferedImage.getHeight();
    }

    @Override
    public void setPixels(int x, int y, int w, int h, @Nullable int[] iArray) {
        WritableRaster writableRaster = this.raster;
        Intrinsics.checkNotNull((Object)writableRaster);
        writableRaster.setPixels(x, y, w, h, iArray);
    }

    @Override
    public boolean isOneSamplePerArrayElement() {
        return this.isOneSamplePerArrayElement;
    }

    @Override
    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public void flush() {
        if (this.image != null) {
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage);
            bufferedImage.flush();
        }
        this.image = null;
        this.raster = null;
    }

    private final java.awt.Image get_nativeImage() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        return bufferedImage;
    }

    @NotNull
    public final Graphics2D createGraphics() {
        BufferedImage bufferedImage = this.image;
        Intrinsics.checkNotNull((Object)bufferedImage);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
        return graphics2D;
    }

    public final double getScaleFactor() {
        return this.scaleFactor;
    }

    public final double findCurrentScaleFactor(@Nullable Graphics2D g2) {
        Object object = g2;
        return object != null && (object = ((Graphics2D)object).getDeviceConfiguration()) != null && (object = ((GraphicsConfiguration)object).getDefaultTransform()) != null ? ((AffineTransform)object).getScaleX() : 1.0;
    }

    @Override
    @NotNull
    public Object getNativeImage() {
        return this.get_nativeImage();
    }
}

