/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import java.awt.AlphaComposite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.BufferedSwingLayer;
import org.mkui.canvas.CanvasListener;
import org.mkui.canvas.ContextMenuListener;
import org.mkui.canvas.DensitySwingLayer;
import org.mkui.canvas.DirectSwingLayer;
import org.mkui.canvas.DrawScopeLayer;
import org.mkui.canvas.FunctionalCPCanvas;
import org.mkui.canvas.GraphicsContextDrawing;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.component.CPInteractiveComponent;
import org.mkui.graphics.CPGraphicsContext2D;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IDrawingListener;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.pressure.Pressure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!J.\u0010\"\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u000b2\b\u0010&\u001a\u0004\u0018\u00010'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u001a\u0010*\u001a\u00020\u001a2\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u000e\u0010+\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u0006J\u0010\u0010\u001f\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u000bH\u0016J\u0018\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020\u000b2\u0006\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\u001aH\u0016J\b\u00101\u001a\u000202H\u0016J\b\u00103\u001a\u000202H\u0016J\u0010\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u000eH\u0016J\u0018\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u000208H\u0014J\u0006\u0010:\u001a\u00020\u001aJ\u0006\u0010;\u001a\u00020\u001aJ\u0010\u0010<\u001a\u00020\u001a2\u0006\u00105\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020\u001a2\u0006\u00105\u001a\u00020?H\u0016J\u0010\u0010@\u001a\u00020\u001a2\u0006\u00105\u001a\u00020=H\u0016J\u0010\u0010A\u001a\u00020\u001a2\u0006\u00105\u001a\u00020?H\u0016J\u000e\u0010B\u001a\u00020\u001a2\u0006\u00105\u001a\u00020CJ\u000e\u0010D\u001a\u00020\u001a2\u0006\u00105\u001a\u00020EJ\u000e\u0010F\u001a\u00020\u001a2\u0006\u00105\u001a\u00020GJ\u000e\u0010L\u001a\u00020\u001a2\u0006\u00105\u001a\u00020CJ\u000e\u0010M\u001a\u00020\u001a2\u0006\u00105\u001a\u00020EJ\u000e\u0010N\u001a\u00020\u001a2\u0006\u00105\u001a\u00020GR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R%\u0010\u0018\u001a\r\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\u0002\b\u001b8VX\u0096\u0004\u00a2\u0006\f\u0012\u0004\b\u001c\u0010\u0003\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010H\u001a\u00020I8F\u00a2\u0006\u0006\u001a\u0004\bJ\u0010K\u00a8\u0006O"}, d2={"Lorg/mkui/canvas/CPCanvas;", "Lorg/mkui/component/CPInteractiveComponent;", "<init>", "()V", "layers", "", "Lorg/mkui/canvas/DrawScopeLayer;", "getLayers", "()Ljava/util/List;", "drawings", "", "Lorg/mkui/graphics/IDrawing;", "Lorg/mkui/graphics/IDrawingListener;", "listeners", "Lorg/mkui/canvas/CanvasListener;", "showTiming", "Lcom/macrofocus/common/properties/MutableProperty;", "", "getShowTiming", "()Lcom/macrofocus/common/properties/MutableProperty;", "canvas", "Lorg/mkui/canvas/FunctionalCPCanvas;", "getCanvas", "()Lorg/mkui/canvas/FunctionalCPCanvas;", "nativeComponent", "Lkotlin/Function0;", "", "Landroidx/compose/runtime/Composable;", "getNativeComponent$annotations", "getNativeComponent", "()Lkotlin/jvm/functions/Function2;", "addLayer", "d", "Lorg/mkui/canvas/GraphicsContextDrawing;", "addDensityLayer", "rendering", "Lorg/mkui/canvas/Rendering;", "iDrawing", "pressure", "Lorg/mkui/graphics/pressure/Pressure;", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "addAveragingLayer", "addNativeLayer", "addBufferedLayer", "registerDrawing", "drawing", "listener", "removeAllLayers", "getWidth", "", "getHeight", "addCanvasListener", "l", "notifySizeChanged", "width", "", "height", "refresh", "redraw", "addMouseListener", "Lorg/mkui/canvas/MouseListener;", "addMouseMotionListener", "Lorg/mkui/canvas/MouseMotionListener;", "removeMouseListener", "removeMouseMotionListener", "addMouseWheelListener", "Lorg/mkui/canvas/MouseWheelListener;", "addKeyListener", "Lorg/mkui/canvas/KeyListener;", "addContextMenuListener", "Lorg/mkui/canvas/ContextMenuListener;", "igraphics", "Lorg/mkui/graphics/IGraphics;", "getIgraphics", "()Lorg/mkui/graphics/IGraphics;", "removeMouseWheelListener", "removeKeyListener", "removeContextMenuListener", "mkui"})
@StabilityInferred(parameters=0)
public class CPCanvas
implements CPInteractiveComponent {
    @NotNull
    private final List<DrawScopeLayer> layers = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    @NotNull
    private final Map<IDrawing, IDrawingListener> drawings = CollectionFactory.INSTANCE.concurrentHashMap();
    @NotNull
    private final List<CanvasListener> listeners = new ArrayList();
    @NotNull
    private final MutableProperty<Boolean> showTiming = (MutableProperty)new SimpleProperty((Object)false);
    @NotNull
    private final FunctionalCPCanvas canvas = new FunctionalCPCanvas(this.layers, this.listeners, this.showTiming);
    public static final int $stable = 8;

    @NotNull
    public final List<DrawScopeLayer> getLayers() {
        return this.layers;
    }

    @NotNull
    public final MutableProperty<Boolean> getShowTiming() {
        return this.showTiming;
    }

    @NotNull
    public final FunctionalCPCanvas getCanvas() {
        return this.canvas;
    }

    @Override
    @NotNull
    public Function2<Composer, Integer, Unit> getNativeComponent() {
        return this.canvas.getNativeComponent();
    }

    public static /* synthetic */ void getNativeComponent$annotations() {
    }

    public final void addLayer(@NotNull GraphicsContextDrawing d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(new DrawScopeLayer(d, this){
            final /* synthetic */ GraphicsContextDrawing $d;
            final /* synthetic */ CPCanvas this$0;
            {
                this.$d = $d;
                this.this$0 = $receiver;
            }

            public void prepare(int width, int height) {
            }

            public void render(DrawScope g2) {
                DrawScope drawScope = g2;
                Intrinsics.checkNotNull((Object)drawScope);
                this.$d.draw(new CPGraphicsContext2D(drawScope), this.this$0.getWidth(), this.this$0.getHeight());
            }
        });
    }

    public void addDensityLayer(@Nullable Rendering rendering, @NotNull IDrawing iDrawing, @Nullable Pressure pressure, @Nullable PaletteProvider paletteProvider) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        DrawScopeLayer layer = null;
        Rendering rendering2 = rendering;
        switch (rendering2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering2.ordinal()]) {
            case 1: {
                Pressure pressure2 = pressure;
                Intrinsics.checkNotNull((Object)pressure2);
                PaletteProvider paletteProvider2 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider2);
                layer = new DensitySwingLayer(iDrawing, 0, 0, true, pressure2, paletteProvider2);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 2: {
                float alpha = 0.5f;
                PaletteProvider paletteProvider3 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider3);
                layer = new BufferedSwingLayer(iDrawing, true, paletteProvider3.getPalette().getColor(1.0), AlphaComposite.getInstance(3, alpha));
                boolean bl = this.layers.add(layer);
                break;
            }
            case 3: {
                PaletteProvider paletteProvider4 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider4);
                layer = new BufferedSwingLayer(iDrawing, true, paletteProvider4.getPalette().getColor(1.0), null);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 4: {
                PaletteProvider paletteProvider5 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider5);
                layer = new DirectSwingLayer(iDrawing, paletteProvider5.getPalette().getColor(1.0));
                boolean bl = this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(this, layer){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ DrawScopeLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().schedulePrepare(this.$layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addAveragingLayer(@Nullable Rendering rendering, @NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
    }

    public final void addNativeLayer(@NotNull DrawScopeLayer d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(d);
    }

    public void addLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
    }

    public void addBufferedLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
    }

    private final void registerDrawing(IDrawing drawing, IDrawingListener listener2) {
        this.drawings.put(drawing, listener2);
        drawing.addIDrawingListener(listener2);
    }

    public void removeAllLayers() {
        this.layers.clear();
        for (Map.Entry<IDrawing, IDrawingListener> entry : this.drawings.entrySet()) {
            IDrawing key = entry.getKey();
            IDrawingListener value = entry.getValue();
            key.removeIDrawingListener(value);
        }
        this.drawings.clear();
    }

    public double getWidth() {
        return this.canvas.getWidth();
    }

    public double getHeight() {
        return this.canvas.getHeight();
    }

    public void addCanvasListener(@NotNull CanvasListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    protected void notifySizeChanged(int width, int height) {
        for (CanvasListener listener2 : this.listeners) {
            listener2.sizeChange(width, height);
        }
    }

    public final void refresh() {
        this.canvas.schedulePrepare();
    }

    public final void redraw() {
        this.canvas.redraw();
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseMotionListener(l);
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.removeMouseListener(l);
    }

    @Override
    public void removeMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.removeMouseMotionListener(l);
    }

    public final void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addMouseWheelListener(l);
    }

    public final void addKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addKeyListener(l);
    }

    public final void addContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.canvas.addContextMenuListener(l);
    }

    @NotNull
    public final IGraphics getIgraphics() {
        String string = "Not yet implemented";
        throw new NotImplementedError("An operation is not implemented: " + string);
    }

    public final void removeMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    public final void removeKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    public final void removeContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Rendering.values().length];
            try {
                nArray[Rendering.Density.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.AlphaBlended.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.Opaque.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.Print.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

