/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.color.crossplatform;

import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UnsignedKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.crossplatform.CPColor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u0002\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\n\u0010\u0004\u001a\u00020\u0001*\u00020\u0001\u001a\u001a\u0010\u0005\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u001a(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\b\u0010\u000e\u001a\u0004\u0018\u00010\t\u001a\u001e\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003\u00a8\u0006\u0011"}, d2={"brighter", "Lorg/mkui/color/crossplatform/CPColor;", "alpha", "", "darker", "brightenAndSaturate", "brightness", "saturation", "RGBtoHSB", "", "r", "", "g", "b", "hsbvals", "HSBtoRGB", "hue", "mkui"})
public final class CPColorKt {
    @NotNull
    public static final CPColor brighter(@NotNull CPColor $this$brighter) {
        Intrinsics.checkNotNullParameter((Object)$this$brighter, (String)"<this>");
        double FACTOR = 0.7;
        int r = $this$brighter.getRed-w2LRezQ() & 0xFF;
        int g2 = $this$brighter.getGreen-w2LRezQ() & 0xFF;
        int b = $this$brighter.getBlue-w2LRezQ() & 0xFF;
        int alpha = $this$brighter.getAlpha-w2LRezQ() & 0xFF;
        int i = (int)(1.0 / (1.0 - FACTOR));
        if (r == 0 && g2 == 0 && b == 0) {
            return new CPColor(i, i, i, alpha);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g2 > 0 && g2 < i) {
            g2 = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new CPColor(Math.min((int)((double)r / FACTOR), 255), Math.min((int)((double)g2 / FACTOR), 255), Math.min((int)((double)b / FACTOR), 255), alpha);
    }

    @NotNull
    public static final CPColor alpha(@NotNull CPColor $this$alpha, float alpha) {
        Intrinsics.checkNotNullParameter((Object)$this$alpha, (String)"<this>");
        return new CPColor($this$alpha.getRed-w2LRezQ(), $this$alpha.getGreen-w2LRezQ(), $this$alpha.getBlue-w2LRezQ(), UByte.constructor-impl((byte)((byte)UnsignedKt.doubleToUInt((double)((float)255 * alpha)))), null);
    }

    @NotNull
    public static final CPColor darker(@NotNull CPColor $this$darker) {
        Intrinsics.checkNotNullParameter((Object)$this$darker, (String)"<this>");
        double FACTOR = 0.7;
        return new CPColor(Math.max((int)(UnsignedKt.uintToDouble((int)($this$darker.getRed-w2LRezQ() & 0xFF)) * FACTOR), 0), Math.max((int)(UnsignedKt.uintToDouble((int)($this$darker.getGreen-w2LRezQ() & 0xFF)) * FACTOR), 0), Math.max((int)(UnsignedKt.uintToDouble((int)($this$darker.getBlue-w2LRezQ() & 0xFF)) * FACTOR), 0), $this$darker.getAlpha-w2LRezQ() & 0xFF);
    }

    @NotNull
    public static final CPColor brightenAndSaturate(@NotNull CPColor $this$brightenAndSaturate, float brightness, float saturation) {
        Intrinsics.checkNotNullParameter((Object)$this$brightenAndSaturate, (String)"<this>");
        float[] hsb = CPColorKt.RGBtoHSB($this$brightenAndSaturate.getRed-w2LRezQ() & 0xFF, $this$brightenAndSaturate.getGreen-w2LRezQ() & 0xFF, $this$brightenAndSaturate.getBlue-w2LRezQ() & 0xFF, null);
        if (!(brightness == 0.0f)) {
            hsb[2] = Math.max(0.0f, Math.min(1.0f, hsb[2] + brightness));
        }
        if (!(saturation == 0.0f)) {
            hsb[1] = Math.max(0.0f, Math.min(1.0f, hsb[1] + saturation));
        }
        return new CPColor(CPColorKt.HSBtoRGB(hsb[0], hsb[1], hsb[2]));
    }

    @NotNull
    public static final float[] RGBtoHSB(int r, int g2, int b, @Nullable float[] hsbvals) {
        int cmin;
        int cmax;
        float[] hsbvals2 = hsbvals;
        float hue = 0.0f;
        float saturation = 0.0f;
        float brightness = 0.0f;
        if (hsbvals2 == null) {
            hsbvals2 = new float[3];
        }
        int n = cmax = r > g2 ? r : g2;
        if (b > cmax) {
            cmax = b;
        }
        int n2 = cmin = r < g2 ? r : g2;
        if (b < cmin) {
            cmin = b;
        }
        brightness = (float)cmax / 255.0f;
        saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
        if (saturation == 0.0f) {
            hue = 0.0f;
        } else {
            float redc = (float)(cmax - r) / (float)(cmax - cmin);
            float greenc = (float)(cmax - g2) / (float)(cmax - cmin);
            float bluec = (float)(cmax - b) / (float)(cmax - cmin);
            hue = r == cmax ? bluec - greenc : (g2 == cmax ? 2.0f + redc - bluec : 4.0f + greenc - redc);
            if ((hue /= 6.0f) < 0.0f) {
                hue += 1.0f;
            }
        }
        hsbvals2[0] = hue;
        hsbvals2[1] = saturation;
        hsbvals2[2] = brightness;
        return hsbvals2;
    }

    public static final int HSBtoRGB(float hue, float saturation, float brightness) {
        int r = 0;
        int g2 = 0;
        int b = 0;
        if (saturation == 0.0f) {
            r = g2 = (b = (int)(brightness * 255.0f + 0.5f));
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g2 = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g2 = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g2 = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g2 = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g2 = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g2 = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        return 0xFF000000 | r << 16 | g2 << 8 | b << 0;
    }
}

