/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.math.MathKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.ArcIterator;
import org.mkui.geom.FlatteningPathIterator;
import org.mkui.geom.Line2D;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\bf\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0012\u0010\u000e\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\tR\u0012\u0010\u0010\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\tR\u0012\u0010\u0012\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\tR\u0012\u0010\u0014\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\tR\u0012\u0010\u0016\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\tR\u0012\u0010\u0018\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0012\u0010\u001c\u001a\u00020\u0019X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001b\u00a8\u0006 \u00c0\u0006\u0003"}, d2={"Lorg/mkui/geom/Arc2D;", "Lorg/mkui/geom/Shape;", "arcType", "", "getArcType", "()I", "x", "", "getX", "()D", "y", "getY", "width", "getWidth", "height", "getHeight", "centerX", "getCenterX", "centerY", "getCenterY", "angleStart", "getAngleStart", "angleExtent", "getAngleExtent", "startPoint", "Lorg/mkui/geom/Point2D;", "getStartPoint", "()Lorg/mkui/geom/Point2D;", "endPoint", "getEndPoint", "Double", "Companion", "mkui"})
public interface Arc2D
extends Shape {
    @NotNull
    public static final Companion Companion = org.mkui.geom.Arc2D$Companion.$$INSTANCE;
    public static final int OPEN = 0;
    public static final int CHORD = 1;
    public static final int PIE = 2;

    public int getArcType();

    public double getX();

    public double getY();

    public double getWidth();

    public double getHeight();

    public double getCenterX();

    public double getCenterY();

    public double getAngleStart();

    public double getAngleExtent();

    @NotNull
    public Point2D getStartPoint();

    @NotNull
    public Point2D getEndPoint();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/mkui/geom/Arc2D$Companion;", "", "<init>", "()V", "OPEN", "", "CHORD", "PIE", "mkui"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        public static final int OPEN = 0;
        public static final int CHORD = 1;
        public static final int PIE = 2;

        private Companion() {
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class DefaultImpls {
        @Deprecated
        @NotNull
        public static Rectangle getBounds(@NotNull Arc2D $this) {
            return $this.getBounds();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0014\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\b\u0007\u0018\u0000 =2\u00020\u0001:\u0001=B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nBA\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\u0005\u0012\u0006\u0010\f\u001a\u00020\u0005\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u000fJ\u0006\u0010\u001b\u001a\u00020\u0003J\u0011\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020!H\u0096\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0003H\u0016J\u0012\u0010&\u001a\u00020%2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016J\u0010\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020\u0005H\u0016J\u0006\u00107\u001a\u00020!J\u0006\u0010:\u001a\u00020!J\u000e\u0010;\u001a\u00020\u001d2\u0006\u0010<\u001a\u00020\u0005R\u0014\u0010\u000b\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\r\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u000e\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001eR\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010,\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u0011R\u0014\u0010.\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u0011R\u0014\u00100\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u0011R\u0014\u00102\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u0010\u0011R\u0014\u00104\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106R\u0014\u00108\u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b9\u00106\u00a8\u0006>"}, d2={"Lorg/mkui/geom/Arc2D$Double;", "Lorg/mkui/geom/Arc2D;", "bounds", "Lorg/mkui/geom/Rectangle2D;", "start", "", "extent", "type", "", "<init>", "(Lorg/mkui/geom/Rectangle2D;DDI)V", "x", "y", "width", "height", "(DDDDDDI)V", "getX", "()D", "getY", "getWidth", "getHeight", "arcType", "getArcType", "()I", "bounds2D", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "computeBounds2D", "isEmpty", "", "()Z", "contains", "point", "Lorg/mkui/geom/Point2D;", "intersects", "r", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "at", "Lorg/mkui/geom/AffineTransform;", "getFlattenPathIterator", "flatness", "centerX", "getCenterX", "centerY", "getCenterY", "angleStart", "getAngleStart", "angleExtent", "getAngleExtent", "startPoint", "getStartPoint", "()Lorg/mkui/geom/Point2D;", "computeStartPoint", "endPoint", "getEndPoint", "computeEndPoint", "containsAngle", "angle", "Companion", "mkui"})
    @StabilityInferred(parameters=1)
    public static final class Double
    implements Arc2D {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final double x;
        private final double y;
        private final double width;
        private final double height;
        private final double start;
        private final double extent;
        private final int arcType;
        public static final int $stable;

        @Override
        public double getX() {
            return this.x;
        }

        @Override
        public double getY() {
            return this.y;
        }

        @Override
        public double getWidth() {
            return this.width;
        }

        @Override
        public double getHeight() {
            return this.height;
        }

        @Override
        public int getArcType() {
            return this.arcType;
        }

        public Double(@NotNull Rectangle2D bounds, double start, double extent, int type) {
            Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
            this.x = bounds.getX();
            this.y = bounds.getY();
            this.width = bounds.getWidth();
            this.height = bounds.getHeight();
            this.start = start;
            this.extent = extent;
            this.arcType = type;
        }

        public Double(double x, double y, double width, double height, double start, double extent, int type) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.start = start;
            this.extent = extent;
            this.arcType = type;
        }

        @Override
        @NotNull
        public Rectangle2D getBounds2D() {
            return this.computeBounds2D();
        }

        @NotNull
        public final Rectangle2D computeBounds2D() {
            if (this.isEmpty()) {
                return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
            }
            double x1 = 0.0;
            double y1 = 0.0;
            double x2 = 0.0;
            double y2 = 0.0;
            if (this.getArcType() == 2) {
                x1 = y1 = (x2 = (y2 = 0.0));
            } else {
                x1 = y1 = 1.0;
                x2 = y2 = -1.0;
            }
            double angle = 0.0;
            for (int i = 0; i < 6; ++i) {
                if (i < 4) {
                    if (!this.containsAngle(angle += 90.0)) {
                        continue;
                    }
                } else {
                    angle = i == 4 ? this.getAngleStart() : (angle += this.getAngleExtent());
                }
                double rads = MathKt.convertDegreesToRadians((double)(-angle));
                double xe = Math.cos(rads);
                x1 = Math.min(x1, xe);
                double ye = Math.sin(rads);
                y1 = Math.min(y1, ye);
                x2 = Math.max(x2, xe);
                y2 = Math.max(y2, ye);
            }
            double w = this.getWidth();
            double h = this.getHeight();
            x2 = (x2 - x1) * 0.5 * w;
            y2 = (y2 - y1) * 0.5 * h;
            x1 = this.getX() + (x1 * 0.5 + 0.5) * w;
            y1 = this.getY() + (y1 * 0.5 + 0.5) * h;
            return new Rectangle2D.Double(x1, y1, x2, y2);
        }

        public final boolean isEmpty() {
            return this.getWidth() <= 0.0 || this.getHeight() <= 0.0;
        }

        @Override
        public boolean contains(@NotNull Point2D point) {
            Intrinsics.checkNotNullParameter((Object)point, (String)"point");
            double x = point.getX();
            double y = point.getY();
            double ellw = this.getWidth();
            if (ellw <= 0.0) {
                return false;
            }
            double normx = (x - x) / ellw - 0.5;
            double ellh = this.getHeight();
            if (ellh <= 0.0) {
                return false;
            }
            double normy = (y - y) / ellh - 0.5;
            double distSq = normx * normx + normy * normy;
            if (distSq >= 0.25) {
                return false;
            }
            double angExt = Math.abs(this.getAngleExtent());
            if (angExt >= 360.0) {
                return true;
            }
            boolean inarc = this.containsAngle(-MathKt.convertRadiansToDegrees((double)Math.atan2(normy, normx)));
            if (this.getArcType() == 2) {
                return inarc;
            }
            if (inarc) {
                if (angExt >= 180.0) {
                    return true;
                }
            } else if (angExt <= 180.0) {
                return false;
            }
            double angle = MathKt.convertDegreesToRadians((double)(-this.getAngleStart()));
            double x1 = Math.cos(angle);
            double y1 = Math.sin(angle);
            double x2 = Math.cos(angle += MathKt.convertDegreesToRadians((double)(-this.getAngleExtent())));
            double y2 = Math.sin(angle);
            boolean inside = Line2D.Companion.relativeCCW(x1, y1, x2, y2, (double)2 * normx, (double)2 * normy) * Line2D.Companion.relativeCCW(x1, y1, x2, y2, 0.0, 0.0) >= 0;
            return inarc != inside;
        }

        @Override
        public boolean intersects(@NotNull Rectangle2D r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            double x = r.getX();
            double y = r.getY();
            double w = r.getWidth();
            double h = r.getHeight();
            double aw = this.getWidth();
            double ah = this.getHeight();
            if (w <= 0.0 || h <= 0.0 || aw <= 0.0 || ah <= 0.0) {
                return false;
            }
            double ext = this.getAngleExtent();
            if (ext == 0.0) {
                return false;
            }
            double ax = x;
            double ay = y;
            double axw = ax + aw;
            double ayh = ay + ah;
            double xw = x + w;
            double yh = y + h;
            if (x >= axw || y >= ayh || xw <= ax || yh <= ay) {
                return false;
            }
            double axc = this.getCenterX();
            double ayc = this.getCenterY();
            Point2D sp = this.getStartPoint();
            Point2D ep = this.getEndPoint();
            double sx = sp.getX();
            double sy = sp.getY();
            double ex = ep.getX();
            double ey = ep.getY();
            if (ayc >= y && ayc <= yh && (sx < xw && ex < xw && axc < xw && axw > x && this.containsAngle(0.0) || sx > x && ex > x && axc > x && ax < xw && this.containsAngle(180.0))) {
                return true;
            }
            if (axc >= x && axc <= xw && (sy > y && ey > y && ayc > y && ay < yh && this.containsAngle(90.0) || sy < yh && ey < yh && ayc < yh && ayh > y && this.containsAngle(270.0))) {
                return true;
            }
            Rectangle2D rect = new Rectangle2D.Double(x, y, w, h);
            if (this.getArcType() == 2 || Math.abs(ext) > 180.0 ? rect.intersectsLine(axc, ayc, sx, sy) || rect.intersectsLine(axc, ayc, ex, ey) : rect.intersectsLine(sx, sy, ex, ey)) {
                return true;
            }
            return this.contains(new Point2D.Double(x, y)) || this.contains(new Point2D.Double(x + w, y)) || this.contains(new Point2D.Double(x, y + h)) || this.contains(new Point2D.Double(x + w, y + h));
        }

        @Override
        @NotNull
        public PathIterator getPathIterator() {
            return this.getPathIterator(null);
        }

        @Override
        @NotNull
        public PathIterator getPathIterator(@Nullable AffineTransform at) {
            return new ArcIterator(this, at);
        }

        @Override
        @NotNull
        public PathIterator getFlattenPathIterator(double flatness) {
            return new FlatteningPathIterator(this.getPathIterator(), flatness);
        }

        @Override
        public double getCenterX() {
            return this.getX() + this.getWidth() / 2.0;
        }

        @Override
        public double getCenterY() {
            return this.getY() + this.getHeight() / 2.0;
        }

        @Override
        public double getAngleStart() {
            return this.start;
        }

        @Override
        public double getAngleExtent() {
            return this.extent;
        }

        @Override
        @NotNull
        public Point2D getStartPoint() {
            return this.computeStartPoint();
        }

        @NotNull
        public final Point2D computeStartPoint() {
            double angle = MathKt.convertDegreesToRadians((double)(-this.getAngleStart()));
            double x = this.getX() + (Math.cos(angle) * 0.5 + 0.5) * this.getWidth();
            double y = this.getY() + (Math.sin(angle) * 0.5 + 0.5) * this.getHeight();
            return new Point2D.Double(x, y);
        }

        @Override
        @NotNull
        public Point2D getEndPoint() {
            return this.computeEndPoint();
        }

        @NotNull
        public final Point2D computeEndPoint() {
            double angle = MathKt.convertDegreesToRadians((double)(-this.getAngleStart() - this.getAngleExtent()));
            double x = this.getX() + (Math.cos(angle) * 0.5 + 0.5) * this.getWidth();
            double y = this.getY() + (Math.sin(angle) * 0.5 + 0.5) * this.getHeight();
            return new Point2D.Double(x, y);
        }

        public final boolean containsAngle(double angle) {
            boolean backwards;
            double angle2 = angle;
            double angExt = this.getAngleExtent();
            boolean bl = backwards = angExt < 0.0;
            if (backwards) {
                angExt = -angExt;
            }
            if (angExt >= 360.0) {
                return true;
            }
            angle2 = Companion.normalizeDegrees(angle2) - Companion.normalizeDegrees(this.getAngleStart());
            if (backwards) {
                angle2 = -angle2;
            }
            if (angle2 < 0.0) {
                angle2 += 360.0;
            }
            return angle2 >= 0.0 && angle2 < angExt;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J6\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0007J\u0016\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u0007\u00a8\u0006\u0013"}, d2={"Lorg/mkui/geom/Arc2D$Double$Companion;", "", "<init>", "()V", "getArcByCenter", "Lorg/mkui/geom/Arc2D$Double;", "x", "", "y", "radius", "angSt", "angExt", "closure", "", "normalizeDegrees", "angle", "IEEEremainder", "f1", "f2", "mkui"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Double getArcByCenter(double x, double y, double radius, double angSt, double angExt, int closure) {
                return new Double(x - radius, y - radius, radius * 2.0, radius * 2.0, angSt, angExt, closure);
            }

            public final double normalizeDegrees(double angle) {
                double angle2 = angle;
                if (angle2 > 180.0) {
                    if (angle2 <= 540.0) {
                        angle2 -= 360.0;
                    } else if ((angle2 = this.IEEEremainder(angle2, 360.0)) == -180.0) {
                        angle2 = 180.0;
                    }
                } else if (angle2 <= -180.0) {
                    if (angle2 > -540.0) {
                        angle2 += 360.0;
                    } else if ((angle2 = this.IEEEremainder(angle2, 360.0)) == -180.0) {
                        angle2 = 180.0;
                    }
                }
                return angle2;
            }

            public final double IEEEremainder(double f1, double f2) {
                double r = Math.abs(f1 % f2);
                return java.lang.Double.isNaN(r) || r == f2 || r <= Math.abs(f2) / 2.0 ? r : Math.signum(f1) * (r - f2);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

