/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.curve.BinaryCurveApproximationAlgorithm;
import org.mkui.geom.curve.ControlPath;
import org.mkui.geom.curve.GroupIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ParametricCurve;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/mkui/geom/curve/CubicBSpline;", "Lorg/mkui/geom/curve/ParametricCurve;", "cp", "Lorg/mkui/geom/curve/ControlPath;", "gi", "Lorg/mkui/geom/curve/GroupIterator;", "<init>", "(Lorg/mkui/geom/curve/ControlPath;Lorg/mkui/geom/curve/GroupIterator;)V", "interpolateEndpoints", "", "getInterpolateEndpoints", "()Z", "setInterpolateEndpoints", "(Z)V", "appendTo", "", "mp", "Lorg/mkui/geom/curve/MultiPath;", "eval", "p", "", "sampleLimit", "", "getSampleLimit", "()I", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class CubicBSpline
extends ParametricCurve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean interpolateEndpoints;
    public static final int $stable = 8;
    private static final int FIRST_SECTION = 0;
    private static final int SECOND_SECTION = 1;
    private static final int MIDDLE_SECTION = 2;
    private static final int SECOND_LAST_SECTION = 3;
    private static final int LAST_SECTION = 4;
    @NotNull
    private static final double[][] pt = new double[4][];
    @NotNull
    private static final double[] b = new double[4];
    private static int currentSection;

    public CubicBSpline(@Nullable ControlPath cp, @Nullable GroupIterator gi) {
        super(cp, gi);
    }

    public final boolean getInterpolateEndpoints() {
        return this.interpolateEndpoints;
    }

    public final void setInterpolateEndpoints(boolean bl) {
        this.interpolateEndpoints = bl;
    }

    @Override
    public void appendTo(@NotNull MultiPath mp) {
        int n;
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        GroupIterator groupIterator = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator);
        ControlPath controlPath = this.getCp();
        Intrinsics.checkNotNull((Object)controlPath);
        if (!groupIterator.isInRange(0, controlPath.numPoints())) {
            return;
        }
        GroupIterator groupIterator2 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator2);
        int n2 = groupIterator2.getGroupSize();
        if (n2 < 4) {
            return;
        }
        if (this.interpolateEndpoints) {
            if (n2 < 7) {
                return;
            }
            n = 0;
        } else {
            n = 2;
        }
        currentSection = n;
        GroupIterator groupIterator3 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator3);
        groupIterator3.set(0, 0);
        for (int i = 0; i < 4; ++i) {
            ControlPath controlPath2 = this.getCp();
            Intrinsics.checkNotNull((Object)controlPath2);
            GroupIterator groupIterator4 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator4);
            CubicBSpline.pt[i] = controlPath2.getPoint(groupIterator4.next()).getLocation();
        }
        double[] d = new double[mp.getDimension() + 1];
        this.eval(d);
        if (this.getConnect()) {
            mp.lineTo(d);
        } else {
            mp.moveTo(d);
        }
        GroupIterator groupIterator5 = this.getGi();
        Intrinsics.checkNotNull((Object)groupIterator5);
        groupIterator5.set(0, 0);
        int j = 0;
        while (true) {
            int n3;
            GroupIterator groupIterator6 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator6);
            int index_i = groupIterator6.index_i();
            GroupIterator groupIterator7 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator7);
            int count_j = groupIterator7.count_j();
            for (int i = 0; i < 4; ++i) {
                GroupIterator groupIterator8 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator8);
                if (!groupIterator8.hasNext()) {
                    return;
                }
                ControlPath controlPath3 = this.getCp();
                Intrinsics.checkNotNull((Object)controlPath3);
                GroupIterator groupIterator9 = this.getGi();
                Intrinsics.checkNotNull((Object)groupIterator9);
                CubicBSpline.pt[i] = controlPath3.getPoint(groupIterator9.next()).getLocation();
            }
            GroupIterator groupIterator10 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator10);
            groupIterator10.set(index_i, count_j);
            GroupIterator groupIterator11 = this.getGi();
            Intrinsics.checkNotNull((Object)groupIterator11);
            groupIterator11.next();
            BinaryCurveApproximationAlgorithm.INSTANCE.genPts(this, 0.0, 1.0, mp);
            if (!this.interpolateEndpoints) continue;
            if (currentSection != 2) {
                n3 = currentSection;
                currentSection = n3 + 1;
            }
            if (currentSection == 2 && j == n2 - 6) {
                n3 = currentSection;
                currentSection = n3 + 1;
            }
            ++j;
        }
    }

    @Override
    public void eval(@NotNull double[] p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        double t = p[p.length - 1];
        if (currentSection == 3 || currentSection == 4) {
            t = 1.0 - t;
        }
        double t2 = t * t;
        double t3 = t2 * t;
        double u = 1.0 - t;
        double u3 = u * u * u;
        switch (currentSection) {
            case 0: {
                CubicBSpline.b[0] = u3;
                CubicBSpline.b[1] = (double)21 * t3 / (double)12 - (double)9 * t2 / (double)2 + (double)3 * t;
                CubicBSpline.b[2] = (double)-11 * t3 / (double)12 + (double)3 * t2 / (double)2;
                CubicBSpline.b[3] = t3 / (double)6;
                break;
            }
            case 1: {
                CubicBSpline.b[0] = u3 / (double)4;
                CubicBSpline.b[1] = (double)7 * t3 / (double)12 - (double)5 * t2 / (double)4 + t / (double)4 + 0.5833333333333334;
                CubicBSpline.b[2] = -t3 / (double)2 + t2 / (double)2 + t / (double)2 + 0.16666666666666666;
                CubicBSpline.b[3] = t3 / (double)6;
                break;
            }
            case 2: {
                CubicBSpline.b[0] = u3 / (double)6;
                CubicBSpline.b[1] = t3 / (double)2 - t2 + 0.6666666666666666;
                CubicBSpline.b[2] = (-t3 + t2 + t) / (double)2 + 0.16666666666666666;
                CubicBSpline.b[3] = t3 / (double)6;
                break;
            }
            case 3: {
                CubicBSpline.b[0] = t3 / (double)6;
                CubicBSpline.b[1] = -t3 / (double)2 + t2 / (double)2 + t / (double)2 + 0.16666666666666666;
                CubicBSpline.b[2] = (double)7 * t3 / (double)12 - (double)5 * t2 / (double)4 + t / (double)4 + 0.5833333333333334;
                CubicBSpline.b[3] = u3 / (double)4;
                break;
            }
            case 4: {
                CubicBSpline.b[0] = t3 / (double)6;
                CubicBSpline.b[1] = (double)-11 * t3 / (double)12 + (double)3 * t2 / (double)2;
                CubicBSpline.b[2] = (double)21 * t3 / (double)12 - (double)9 * t2 / (double)2 + (double)3 * t;
                CubicBSpline.b[3] = u3;
            }
        }
        for (int i = 0; i < 4; ++i) {
            int n = p.length - 1;
            for (int j = 0; j < n; ++j) {
                int n2 = j;
                double d = p[n2];
                double[] dArray = pt[i];
                Intrinsics.checkNotNull((Object)dArray);
                p[n2] = d + dArray[j] * b[i];
            }
        }
    }

    @Override
    public int getSampleLimit() {
        return 1;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/mkui/geom/curve/CubicBSpline$Companion;", "", "<init>", "()V", "FIRST_SECTION", "", "SECOND_SECTION", "MIDDLE_SECTION", "SECOND_LAST_SECTION", "LAST_SECTION", "pt", "", "", "[[D", "b", "currentSection", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

