/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.labeling;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.color.MkColor;
import org.mkui.color.MkColorKt;
import org.mkui.labeling.EnhancedLabelKt;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \b2\u00020\u0001:\u0005\b\t\n\u000b\fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H&\u0082\u0001\u0004\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/mkui/labeling/ContrastEnhancement;", "", "<init>", "()V", "adjustLabelColor", "Lorg/mkui/color/MkColor;", "foreground", "background", "Companion", "Off", "Brightness", "BlackWhite", "Complement", "Lorg/mkui/labeling/ContrastEnhancement$BlackWhite;", "Lorg/mkui/labeling/ContrastEnhancement$Brightness;", "Lorg/mkui/labeling/ContrastEnhancement$Complement;", "Lorg/mkui/labeling/ContrastEnhancement$Off;", "mkui"})
@StabilityInferred(parameters=1)
public abstract class ContrastEnhancement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    public static final float COLOR_SIMILARITY_THRESHOLD = 0.5f;
    @NotNull
    private static final List<ContrastEnhancement> values;

    private ContrastEnhancement() {
    }

    @NotNull
    public abstract MkColor adjustLabelColor(@NotNull MkColor var1, @NotNull MkColor var2);

    public /* synthetic */ ContrastEnhancement(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Object[] objectArray = new ContrastEnhancement[]{Off.INSTANCE, Brightness.INSTANCE, BlackWhite.INSTANCE, Complement.INSTANCE};
        values = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lorg/mkui/labeling/ContrastEnhancement$BlackWhite;", "Lorg/mkui/labeling/ContrastEnhancement;", "<init>", "()V", "adjustLabelColor", "Lorg/mkui/color/MkColor;", "foreground", "background", "toString", "", "mkui"})
    @StabilityInferred(parameters=1)
    public static final class BlackWhite
    extends ContrastEnhancement {
        @NotNull
        public static final BlackWhite INSTANCE = new BlackWhite();
        public static final int $stable;

        private BlackWhite() {
            super(null);
        }

        @Override
        @NotNull
        public MkColor adjustLabelColor(@NotNull MkColor foreground, @NotNull MkColor background) {
            double backgroundLuminance;
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            float diff = EnhancedLabelKt.diff(foreground, background);
            return diff <= 0.5f ? ((backgroundLuminance = EnhancedLabelKt.lum(background)) >= 186.0 ? EnhancedLabelKt.getBlack() : EnhancedLabelKt.getWhite()) : foreground;
        }

        @NotNull
        public String toString() {
            return "Black&White";
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/mkui/labeling/ContrastEnhancement$Brightness;", "Lorg/mkui/labeling/ContrastEnhancement;", "<init>", "()V", "adjustLabelColor", "Lorg/mkui/color/MkColor;", "foreground", "background", "mkui"})
    @StabilityInferred(parameters=1)
    public static final class Brightness
    extends ContrastEnhancement {
        @NotNull
        public static final Brightness INSTANCE = new Brightness();
        public static final int $stable;

        private Brightness() {
            super(null);
        }

        @Override
        @NotNull
        public MkColor adjustLabelColor(@NotNull MkColor foreground, @NotNull MkColor background) {
            MkColor mkColor;
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            MkColor foreground2 = foreground;
            float diff = EnhancedLabelKt.diff(foreground2, background);
            if (diff <= 0.5f) {
                float darkerDiff;
                double foregroundBrightness = EnhancedLabelKt.brightness(foreground2);
                MkColor brighterForeground = EnhancedLabelKt.replaceBrightness(foreground2, Math.min(1.0, foregroundBrightness + (double)(0.5f - diff)));
                MkColor darkerForeground = EnhancedLabelKt.replaceBrightness(foreground2, Math.max(0.0, foregroundBrightness - (double)(0.5f - diff)));
                float backgroundLuminance = EnhancedLabelKt.luminance(background);
                float brighterDiff = Math.abs(EnhancedLabelKt.luminance(brighterForeground) - backgroundLuminance);
                mkColor = foreground2 = brighterDiff > (darkerDiff = Math.abs(EnhancedLabelKt.luminance(darkerForeground) - backgroundLuminance)) ? brighterForeground : darkerForeground;
            } else {
                mkColor = foreground2;
            }
            return mkColor;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/mkui/labeling/ContrastEnhancement$Companion;", "", "<init>", "()V", "COLOR_SIMILARITY_THRESHOLD", "", "values", "", "Lorg/mkui/labeling/ContrastEnhancement;", "getValues", "()Ljava/util/List;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<ContrastEnhancement> getValues() {
            return values;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/mkui/labeling/ContrastEnhancement$Complement;", "Lorg/mkui/labeling/ContrastEnhancement;", "<init>", "()V", "adjustLabelColor", "Lorg/mkui/color/MkColor;", "foreground", "background", "mkui"})
    @StabilityInferred(parameters=1)
    public static final class Complement
    extends ContrastEnhancement {
        @NotNull
        public static final Complement INSTANCE = new Complement();
        public static final int $stable;

        private Complement() {
            super(null);
        }

        @Override
        @NotNull
        public MkColor adjustLabelColor(@NotNull MkColor foreground, @NotNull MkColor background) {
            MkColor mkColor;
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            MkColor foreground2 = foreground;
            float diff = EnhancedLabelKt.diff(foreground2, background);
            if (diff <= 0.5f) {
                float darkerDiff;
                byte alpha = MkColorKt.getUAlpha(foreground2);
                byte red = MkColorKt.getURed(foreground2);
                byte blue = MkColorKt.getUBlue(foreground2);
                byte green = MkColorKt.getUBlue(foreground2);
                red = UByte.constructor-impl((byte)(~red));
                blue = UByte.constructor-impl((byte)(~blue));
                green = UByte.constructor-impl((byte)(~green));
                MkColor complement = MkColorKt.colorOf-bW95L_I(red, green, blue, alpha);
                float backgroundLuminance = EnhancedLabelKt.luminance(background);
                float brighterDiff = Math.abs(EnhancedLabelKt.luminance(foreground2) - backgroundLuminance);
                mkColor = foreground2 = brighterDiff > (darkerDiff = Math.abs(EnhancedLabelKt.luminance(complement) - backgroundLuminance)) ? foreground2 : complement;
            } else {
                mkColor = foreground2;
            }
            return mkColor;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lorg/mkui/labeling/ContrastEnhancement$Off;", "Lorg/mkui/labeling/ContrastEnhancement;", "<init>", "()V", "adjustLabelColor", "Lorg/mkui/color/MkColor;", "foreground", "background", "mkui"})
    @StabilityInferred(parameters=1)
    public static final class Off
    extends ContrastEnhancement {
        @NotNull
        public static final Off INSTANCE = new Off();
        public static final int $stable;

        private Off() {
            super(null);
        }

        @Override
        @NotNull
        public MkColor adjustLabelColor(@NotNull MkColor foreground, @NotNull MkColor background) {
            Intrinsics.checkNotNullParameter((Object)foreground, (String)"foreground");
            Intrinsics.checkNotNullParameter((Object)background, (String)"background");
            return foreground;
        }
    }
}

