/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.labeling;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.color.MkColor;
import org.mkui.color.MkColorKt;
import org.mkui.color.crossplatform.CPColorKt;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\r\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u001e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u001a\n\u0010\t\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\n\u001a\u00020\u0003*\u00020\u0001\u001a\n\u0010\u000b\u001a\u00020\u0006*\u00020\u0001\u001a\u0012\u0010\f\u001a\u00020\u0006*\u00020\u00012\u0006\u0010\r\u001a\u00020\u0001\"\u0011\u0010\u000e\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0011\u0010\u0011\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010\u00a8\u0006\u0013"}, d2={"replaceBrightness", "Lorg/mkui/color/MkColor;", "min", "", "getHSBColor", "h", "", "s", "b", "brightness", "lum", "luminance", "diff", "background", "Black", "getBlack", "()Lorg/mkui/color/MkColor;", "White", "getWhite", "mkui"})
public final class EnhancedLabelKt {
    @NotNull
    private static final MkColor Black = MkColorKt.colorOf-bW95L_I((byte)0, (byte)0, (byte)0, (byte)-1);
    @NotNull
    private static final MkColor White = MkColorKt.colorOf-bW95L_I((byte)-1, (byte)-1, (byte)-1, (byte)-1);

    @NotNull
    public static final MkColor replaceBrightness(@NotNull MkColor $this$replaceBrightness, double min) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceBrightness, (String)"<this>");
        float[] hsb = CPColorKt.RGBtoHSB(MkColorKt.getURed($this$replaceBrightness) & 0xFF, MkColorKt.getUGreen($this$replaceBrightness) & 0xFF, MkColorKt.getUBlue($this$replaceBrightness) & 0xFF, null);
        return EnhancedLabelKt.getHSBColor(hsb[0], hsb[1], (float)min);
    }

    @NotNull
    public static final MkColor getHSBColor(float h, float s, float b) {
        return MkColorKt.colorOf(CPColorKt.HSBtoRGB(h, s, b));
    }

    public static final double brightness(@NotNull MkColor $this$brightness) {
        Intrinsics.checkNotNullParameter((Object)$this$brightness, (String)"<this>");
        float[] hsb = CPColorKt.RGBtoHSB(MkColorKt.getURed($this$brightness) & 0xFF, MkColorKt.getUGreen($this$brightness) & 0xFF, MkColorKt.getUBlue($this$brightness) & 0xFF, null);
        return hsb[2];
    }

    public static final double lum(@NotNull MkColor $this$lum) {
        Intrinsics.checkNotNullParameter((Object)$this$lum, (String)"<this>");
        int r = MkColorKt.getURed($this$lum) & 0xFF;
        int g2 = MkColorKt.getUGreen($this$lum) & 0xFF;
        int b = MkColorKt.getUBlue($this$lum) & 0xFF;
        return 0.299 * (double)r + 0.587 * (double)g2 + 0.114 * (double)b;
    }

    public static final float luminance(@NotNull MkColor $this$luminance) {
        Intrinsics.checkNotNullParameter((Object)$this$luminance, (String)"<this>");
        int r = MkColorKt.getURed($this$luminance) & 0xFF;
        int g2 = MkColorKt.getUGreen($this$luminance) & 0xFF;
        int b = MkColorKt.getUBlue($this$luminance) & 0xFF;
        return (0.299f * (float)r + 0.587f * (float)g2 + 0.114f * (float)b) / 255.0f;
    }

    public static final float diff(@NotNull MkColor $this$diff, @NotNull MkColor background) {
        Intrinsics.checkNotNullParameter((Object)$this$diff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        int r = Math.abs((MkColorKt.getURed($this$diff) & 0xFF) - (MkColorKt.getURed(background) & 0xFF));
        int g2 = Math.abs((MkColorKt.getUGreen($this$diff) & 0xFF) - (MkColorKt.getUGreen(background) & 0xFF));
        int b = Math.abs((MkColorKt.getUBlue($this$diff) & 0xFF) - (MkColorKt.getUBlue(background) & 0xFF));
        return (float)Math.max(r, Math.max(g2, b)) / 255.0f;
    }

    @NotNull
    public static final MkColor getBlack() {
        return Black;
    }

    @NotNull
    public static final MkColor getWhite() {
        return White;
    }
}

