/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.color.MkColor;
import org.mkui.palette.AbstractMutablePalette;
import org.mkui.palette.Cycle;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\u0003\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0017\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0010\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\bR\u001a\u0010\r\u001a\u00020\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0015\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00148TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lorg/mkui/palette/DynamicPalette;", "Lorg/mkui/palette/AbstractMutablePalette;", "colors", "", "Lorg/mkui/color/MkColor;", "<init>", "([Lorg/mkui/color/MkColor;)V", "", "(Ljava/util/List;)V", "", "getColors", "()Ljava/util/List;", "setColors", "isInverted", "", "()Z", "setInverted", "(Z)V", "getColor", "fraction", "", "lowestFraction", "getLowestFraction", "()D", "highestFraction", "getHighestFraction", "getColorAt", "index", "", "mkui"})
@StabilityInferred(parameters=0)
public class DynamicPalette
extends AbstractMutablePalette {
    @NotNull
    private List<MkColor> colors;
    private boolean isInverted;
    public static final int $stable = 8;

    @NotNull
    protected final List<MkColor> getColors() {
        return this.colors;
    }

    protected final void setColors(@NotNull List<MkColor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colors = list;
    }

    @Override
    public final boolean isInverted() {
        return this.isInverted;
    }

    public final void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    public DynamicPalette(MkColor ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.colors = ArraysKt.toMutableList((Object[])colors);
        this.setColorCount(this.colors.size());
    }

    public DynamicPalette(@NotNull List<MkColor> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.colors = CollectionsKt.toMutableList((Collection)colors);
        this.setColorCount(this.colors.size());
    }

    @Override
    @NotNull
    public MkColor getColor(double fraction) {
        MkColor mkColor;
        double fraction2 = fraction;
        boolean inverted = this.isInverted;
        Cycle cycle = this.getCycle();
        switch (cycle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cycle.ordinal()]) {
            case 1: {
                inverted = (int)fraction2 % 2 == 0;
                fraction2 -= (double)((int)fraction2);
                break;
            }
            case 2: {
                fraction2 -= (double)((int)fraction2);
                break;
            }
            default: {
            }
        }
        if (fraction2 < this.getLowestFraction()) {
            mkColor = this.getColor(this.getLowestFraction());
        } else if (fraction2 > this.getHighestFraction()) {
            mkColor = this.getColor(this.getHighestFraction());
        } else {
            int index = this.getEntry(!inverted ? fraction2 : 1.0 - fraction2, this.getColorCount(), this.colors.size());
            mkColor = this.colors.get(index);
        }
        return mkColor;
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    @Override
    @NotNull
    public MkColor getColorAt(int index) {
        return this.getColorCount() == this.colors.size() ? (index < 0 ? this.getColorAt(0) : (index > this.getColorCount() - 1 ? this.getColorAt(this.getColorCount() - 1) : this.colors.get(index))) : this.getColor((double)this.getColorCount() / (double)index);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Cycle.values().length];
            try {
                nArray[Cycle.REFLECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Cycle.REPEAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

