/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.ArrayFnKt;
import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIGraphics;
import org.mkui.graphics.Edge;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.line.BresenhamLineDrawer;
import org.mkui.graphics.line.LineDrawer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0014\n\u0002\b\u000b\b\u0017\u0018\u0000 ,2\u00020\u0001:\u0002+,B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001a\u0010\f\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001a\u0010\u000f\u001a\u00020\u0004X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u0014\u0010\u0012\u001a\u00020\u0013X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R$\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0006\"\u0004\b\u0019\u0010\bR\u001a\u0010\u001a\u001a\u00020\u001bX\u0084.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\"\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0084.\u00a2\u0006\u0010\n\u0002\u0010'\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010(\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0006\"\u0004\b*\u0010\b\u00a8\u0006-"}, d2={"Lorg/mkui/canvas/AbstractAveragingLayer;", "", "()V", "cx1", "", "getCx1", "()I", "setCx1", "(I)V", "cx2", "getCx2", "setCx2", "cy1", "getCy1", "setCy1", "cy2", "getCy2", "setCy2", "g", "Lorg/mkui/graphics/IGraphics;", "getG", "()Lorg/mkui/graphics/IGraphics;", "<set-?>", "height", "getHeight", "setHeight", "overlay", "", "getOverlay", "()[I", "setOverlay", "([I)V", "rgb", "", "", "getRgb", "()[[F", "setRgb", "([[F)V", "[[F", "width", "getWidth", "setWidth", "AveragingGraphics", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public class AbstractAveragingLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    protected int[] overlay;
    protected float[][] rgb;
    private int width;
    private int height;
    private int cx1;
    private int cy1;
    private int cx2;
    private int cy2;
    @NotNull
    private final IGraphics g = new AveragingGraphics();
    public static final int $stable = 8;
    @NotNull
    private static final LineDrawer lineDrawer = new BresenhamLineDrawer();
    private static final double flatness = 0.33333;

    @NotNull
    protected final int[] getOverlay() {
        if (this.overlay != null) {
            return this.overlay;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"overlay");
        return null;
    }

    protected final void setOverlay(@NotNull int[] nArray) {
        Intrinsics.checkNotNullParameter((Object)nArray, (String)"<set-?>");
        this.overlay = nArray;
    }

    @NotNull
    protected final float[][] getRgb() {
        if (this.rgb != null) {
            return this.rgb;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"rgb");
        return null;
    }

    protected final void setRgb(@NotNull float[][] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.rgb = fArray;
    }

    public final int getWidth() {
        return this.width;
    }

    protected final void setWidth(int n) {
        this.width = n;
    }

    public final int getHeight() {
        return this.height;
    }

    protected final void setHeight(int n) {
        this.height = n;
    }

    protected final int getCx1() {
        return this.cx1;
    }

    protected final void setCx1(int n) {
        this.cx1 = n;
    }

    protected final int getCy1() {
        return this.cy1;
    }

    protected final void setCy1(int n) {
        this.cy1 = n;
    }

    protected final int getCx2() {
        return this.cx2;
    }

    protected final void setCx2(int n) {
        this.cx2 = n;
    }

    protected final int getCy2() {
        return this.cy2;
    }

    protected final void setCy2(int n) {
        this.cy2 = n;
    }

    @NotNull
    protected final IGraphics getG() {
        return this.g;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b(\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001_B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J-\u0010\r\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010\u0014J3\u0010\u0015\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001aJ3\u0010\u001b\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001c\u001a\u00020\fH\u0016J\u000e\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u0010J\u0010\u0010\u001f\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0014J(\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020$2\u0006\u0010'\u001a\u00020$H\u0016J(\u0010\"\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010%\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012H\u0016J\u0012\u0010(\u001a\u00020\f2\b\u0010)\u001a\u0004\u0018\u00010*H\u0016J\b\u0010+\u001a\u00020\fH\u0016J\u0010\u0010+\u001a\u00020\f2\u0006\u0010 \u001a\u00020!H\u0014J\u0010\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020.H\u0016J\f\u00101\u001a\u00060\u0004j\u0002`\u0005H\u0016J\b\u00102\u001a\u00020$H\u0016J\u001e\u00103\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012J\u0018\u00104\u001a\u00020\f2\b\u00105\u001a\u0004\u0018\u00010\u00102\u0006\u00106\u001a\u00020\u0010J\b\u00107\u001a\u000208H\u0016J\u0018\u00109\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020$H\u0016JK\u0010:\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00122\u0006\u0010=\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010>JK\u0010?\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010;\u001a\u00020\u00122\u0006\u0010<\u001a\u00020\u00122\u0006\u0010@\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0002\u0010>J\u0018\u0010A\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020$2\u0006\u0010\u0018\u001a\u00020$H\u0016J\u0018\u0010B\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0002J \u0010C\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012H\u0002J \u0010D\u001a\u00020\f2\u0006\u0010#\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u0012H\u0002J\u0016\u0010D\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J \u0010E\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012H\u0002J \u0010F\u001a\u00020\f2\u0006\u0010%\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u0012H\u0002J\u0016\u0010F\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J#\u0010G\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0004\u00a2\u0006\u0002\u0010HJ\u000e\u0010I\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0010J\u0010\u0010J\u001a\u00020\f2\u0006\u0010K\u001a\u00020$H\u0016JE\u0010L\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010M\u001a\u00020\u00122\u0006\u0010N\u001a\u00020\u0012H\u0004\u00a2\u0006\u0002\u0010OJC\u0010P\u001a\u00020\f2\u000e\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010Q\u001a\u00020\u00122\u0006\u0010R\u001a\u00020\u0012\u00a2\u0006\u0002\u0010OJ\u0014\u0010S\u001a\u00020\f2\n\u0010T\u001a\u00060\u0004j\u0002`\u0005H\u0016J\u0010\u0010U\u001a\u00020\f2\u0006\u0010V\u001a\u00020$H\u0016J\u0010\u0010W\u001a\u00020\f2\u0006\u0010X\u001a\u00020$H\u0016J\b\u0010Y\u001a\u00020\fH\u0016J\u0018\u0010Z\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0012H\u0016J\u0016\u0010[\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010J(\u0010\\\u001a\u00020\u00122\u0006\u0010]\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0019\u001a\u00020\u0012J(\u0010^\u001a\u00020\u00122\u0006\u0010]\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u0012R\u0016\u0010\u0003\u001a\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n0\u0007R\u00060\u0000R\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006`"}, d2={"Lorg/mkui/canvas/AbstractAveragingLayer$AveragingGraphics;", "Lorg/mkui/graphics/AbstractIGraphics;", "(Lorg/mkui/canvas/AbstractAveragingLayer;)V", "color", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "lineVisitor", "Lorg/mkui/canvas/AbstractAveragingLayer$AveragingGraphics$MoveLineLineVisitor;", "Lorg/mkui/canvas/AbstractAveragingLayer;", "getLineVisitor", "()Lorg/mkui/canvas/AbstractAveragingLayer$AveragingGraphics$MoveLineLineVisitor;", "beginPath", "", "buildActiveList", "edges", "", "Lorg/mkui/graphics/Edge;", "scan", "", "active", "([Lorg/mkui/graphics/Edge;ILorg/mkui/graphics/Edge;)V", "buildEdgeListHorizontal", "x", "", "y", "cnt", "([Lorg/mkui/graphics/Edge;[I[II)V", "buildEdgeListVertical", "closePath", "deleteAfter", "q", "draw", "s", "Lorg/mkui/geom/Shape;", "drawLine", "x1", "", "y1", "x2", "y2", "drawPoint", "point", "Lorg/mkui/geom/Point2D;", "fill", "fillCircle", "r", "Lorg/mkui/geom/Rectangle2D;", "fillRectangle2D", "rectangle", "getColor", "getLineWidth", "horizontalLine", "insertEdge", "list", "edge", "isThreadSafe", "", "lineTo", "makeEdgeRecHorizontal", "lower", "upper", "yComp", "([Lorg/mkui/graphics/Edge;IIILorg/mkui/graphics/Edge;[I[I)V", "makeEdgeRecVertical", "xComp", "moveTo", "plot", "plotH", "plotHClipped", "plotV", "plotVClipped", "prepareEdgeList", "([Lorg/mkui/graphics/Edge;I)V", "resortActiveList", "rotate", "theta", "scanFillHorizontal", "miny", "maxy", "([Lorg/mkui/graphics/Edge;[I[IIII)V", "scanFillVertical", "minx", "maxx", "setColor", "c", "setGlobalAlpha", "alpha", "setLineWidth", "lineWidth", "stroke", "translate", "updateActiveList", "xNext", "k", "yNext", "MoveLineLineVisitor", "mkui"})
    private final class AveragingGraphics
    extends AbstractIGraphics {
        @Nullable
        private Color color;
        @NotNull
        private final MoveLineLineVisitor lineVisitor = new MoveLineLineVisitor();

        @NotNull
        public final MoveLineLineVisitor getLineVisitor() {
            return this.lineVisitor;
        }

        @Override
        public boolean isThreadSafe() {
            return false;
        }

        @Override
        public double getLineWidth() {
            return 0.0;
        }

        @Override
        public void setLineWidth(double lineWidth) {
        }

        @Override
        public void setGlobalAlpha(double alpha) {
        }

        @Override
        @NotNull
        public Color getColor() {
            Color color = this.color;
            Intrinsics.checkNotNull((Object)color);
            return color;
        }

        @Override
        public void setColor(@NotNull Color c) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            this.color = c;
        }

        @Override
        protected void draw(@NotNull Shape s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            PathIterator pi = Shape.DefaultImpls.getPathIterator$default(s, null, 1, null);
            float[] data = new float[6];
            int previousX = 0;
            int previousY = 0;
            boolean firstPoint = true;
            while (!pi.isDone()) {
                switch (pi.currentSegment(data)) {
                    case 0: {
                        previousX = (int)data[0];
                        previousY = (int)data[1];
                        firstPoint = true;
                        break;
                    }
                    case 1: {
                        int currentX = (int)data[0];
                        int currentY = (int)data[1];
                        lineDrawer.drawLine(previousX, previousY, currentX, currentY, AbstractAveragingLayer.this.getWidth(), AbstractAveragingLayer.this.getHeight(), this.lineVisitor, firstPoint);
                        firstPoint = false;
                        previousX = currentX;
                        previousY = currentY;
                        break;
                    }
                    case 4: {
                        break;
                    }
                    default: {
                        throw new Error("Segmented type unsupported");
                    }
                }
                pi.next();
            }
        }

        @Override
        public void drawLine(int x1, int y1, int x2, int y2) {
            lineDrawer.drawLine(x1, y1, x2, y2, AbstractAveragingLayer.this.getWidth(), AbstractAveragingLayer.this.getHeight(), this.lineVisitor, true);
        }

        @Override
        public void drawLine(double x1, double y1, double x2, double y2) {
            this.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        }

        private final void plot(int x, int y) {
            this.lineVisitor.process(x, y);
        }

        private final void plotH(int x1, int y, int x2) {
            for (int x = x1; x < x2; ++x) {
                this.plot(x, y);
            }
        }

        private final void plotHClipped(int x1, int y, int x2) {
            if (x1 <= AbstractAveragingLayer.this.getCx2() && x2 >= AbstractAveragingLayer.this.getCx1()) {
                this.plotH(x1 < AbstractAveragingLayer.this.getCx1() ? AbstractAveragingLayer.this.getCx1() : x1, y, x2 > AbstractAveragingLayer.this.getCx2() ? AbstractAveragingLayer.this.getCx2() : x2);
            }
        }

        private final void plotV(int y1, int x, int y2) {
            int y = y1;
            if (y <= y2) {
                while (true) {
                    this.plot(x, y);
                    if (y == y2) break;
                    ++y;
                }
            }
        }

        private final void plotVClipped(int y1, int x, int y2) {
            int y12 = y1;
            int y22 = y2;
            if (y12 <= AbstractAveragingLayer.this.getCy2() && y22 >= AbstractAveragingLayer.this.getCy1()) {
                int n;
                int y;
                if (y12 < AbstractAveragingLayer.this.getCy1()) {
                    y12 = AbstractAveragingLayer.this.getCy1();
                }
                if (y22 > AbstractAveragingLayer.this.getCy2()) {
                    y22 = AbstractAveragingLayer.this.getCy2();
                }
                if ((y = y12) <= (n = y22)) {
                    while (true) {
                        this.plot(x, y);
                        if (y == n) break;
                        ++y;
                    }
                }
            }
        }

        @Override
        protected void fill(@NotNull Shape s) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            Rectangle2D b = s.getBounds2D();
            int x1 = (int)b.getX();
            int y1 = (int)b.getY();
            int x2 = (int)(b.getX() + b.getWidth() - 1.0);
            int y2 = (int)(b.getY() + b.getHeight() - 1.0);
            if (x1 > AbstractAveragingLayer.this.getCx2() || y1 > AbstractAveragingLayer.this.getCy2() || x2 < AbstractAveragingLayer.this.getCx1() || y2 < AbstractAveragingLayer.this.getCy1()) {
                return;
            }
            PathIterator i = s.getFlattenPathIterator(0.33333);
            while (!i.isDone()) {
                int[] x = null;
                x = new int[100];
                int[] y = null;
                y = new int[100];
                int closeX = 0;
                int closeY = 0;
                int count = 0;
                float[] coords = new float[6];
                boolean didClose = true;
                while (!i.isDone()) {
                    int segment = i.currentSegment(coords);
                    switch (segment) {
                        case 0: {
                            int n;
                            if (!didClose) {
                                x[count] = closeX;
                                y[count] = closeY;
                                n = count;
                                count = n + 1;
                            }
                            AveragingGraphics $this$fill_u24lambda_u240 = this;
                            boolean bl = false;
                            x[count] = closeX = (int)coords[0];
                            AveragingGraphics $this$fill_u24lambda_u241 = this;
                            boolean bl2 = false;
                            y[count] = closeY = (int)coords[1];
                            didClose = false;
                            n = count;
                            count = n + 1;
                            break;
                        }
                        case 1: {
                            x[count] = (int)coords[0];
                            y[count] = (int)coords[1];
                            didClose = false;
                            int n = count;
                            count = n + 1;
                            break;
                        }
                        case 4: {
                            x[count] = closeX;
                            y[count] = closeY;
                            int n = count;
                            count = n + 1;
                            didClose = true;
                            break;
                        }
                        default: {
                            System.out.println((Object)("Unsupported type " + segment));
                        }
                    }
                    if (count >= x.length) {
                        int[] tmp = x;
                        x = new int[x.length * 2];
                        ArrayFnKt.arraycopy((int[])tmp, (int)0, (int[])x, (int)0, (int)tmp.length);
                        tmp = y;
                        y = new int[y.length * 2];
                        ArrayFnKt.arraycopy((int[])tmp, (int)0, (int[])y, (int)0, (int)tmp.length);
                    }
                    if (didClose) {
                        if (i.isDone()) break;
                        i.next();
                        break;
                    }
                    i.next();
                }
                if (!didClose) {
                    x[count] = closeX;
                    y[count] = closeY;
                    int tmp = count;
                    count = tmp + 1;
                }
                Edge[] edges = null;
                int n = Math.max(AbstractAveragingLayer.this.getHeight(), AbstractAveragingLayer.this.getWidth());
                edges = new Edge[n];
                for (int j = 0; j < n; ++j) {
                    edges[j] = new Edge();
                }
                if (count <= 2) continue;
                this.scanFillVertical(edges, x, y, count, Math.max((int)b.getX(), AbstractAveragingLayer.this.getCx1()), Math.min((int)b.getX() + (int)b.getWidth() - 1, AbstractAveragingLayer.this.getCx2()));
            }
        }

        protected final void scanFillHorizontal(@NotNull Edge[] edges, @NotNull int[] x, @NotNull int[] y, int cnt, int miny, int maxy) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Edge active = new Edge();
            this.buildEdgeListHorizontal(edges, x, y, cnt);
            int scan = miny;
            if (scan <= maxy) {
                while (true) {
                    this.buildActiveList(edges, scan, active);
                    this.plotHClipped(scan, active);
                    this.updateActiveList(scan, active);
                    this.resortActiveList(active);
                    Edge edge = edges[scan];
                    Intrinsics.checkNotNull((Object)edge);
                    edge.setNext(null);
                    if (scan == maxy) break;
                    ++scan;
                }
            }
        }

        public final void scanFillVertical(@NotNull Edge[] edges, @NotNull int[] x, @NotNull int[] y, int cnt, int minx, int maxx) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Edge active = new Edge();
            this.buildEdgeListVertical(edges, x, y, cnt);
            int scan = minx;
            if (scan <= maxx) {
                while (true) {
                    this.buildActiveList(edges, scan, active);
                    this.plotVClipped(scan, active);
                    this.updateActiveList(scan, active);
                    this.resortActiveList(active);
                    Edge edge = edges[scan];
                    Intrinsics.checkNotNull((Object)edge);
                    edge.setNext(null);
                    if (scan == maxx) break;
                    ++scan;
                }
            }
        }

        public final void insertEdge(@Nullable Edge list, @NotNull Edge edge) {
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Edge p = null;
            Edge q = null;
            Edge edge2 = q = list;
            Intrinsics.checkNotNull((Object)edge2);
            p = edge2.getNext();
            while (p != null) {
                if (edge.getIntersect() < p.getIntersect()) {
                    p = null;
                    continue;
                }
                q = p;
                p = p.getNext();
            }
            edge.setNext(q.getNext());
            q.setNext(edge);
        }

        public final void buildEdgeListHorizontal(@NotNull Edge[] edges, @NotNull int[] x, @NotNull int[] y, int cnt) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Edge edge = null;
            int v1 = 0;
            int v2 = 0;
            int yPrev = 0;
            yPrev = y[cnt - 2];
            for (v1 = cnt - 1; v1 >= 1 && (yPrev = y[v1 - 1]) == y[v1]; --v1) {
            }
            for (int i = 0; i < cnt; ++i) {
                v2 = i;
                if (y[v1] != y[v2]) {
                    edge = new Edge();
                    if (y[v1] < y[v2]) {
                        this.makeEdgeRecHorizontal(edges, v1, v2, this.yNext(i, x, y, cnt), edge, x, y);
                    } else {
                        this.makeEdgeRecHorizontal(edges, v2, v1, yPrev, edge, x, y);
                    }
                    yPrev = y[v1];
                }
                v1 = v2;
            }
        }

        public final void buildEdgeListVertical(@NotNull Edge[] edges, @NotNull int[] x, @NotNull int[] y, int cnt) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            Edge edge = null;
            int v1 = 0;
            int v2 = 0;
            int xPrev = 0;
            xPrev = x[cnt - 2];
            for (v1 = cnt - 1; v1 >= 1 && (xPrev = x[v1 - 1]) == x[v1]; --v1) {
            }
            for (int i = 0; i < cnt; ++i) {
                v2 = i;
                if (x[v1] != x[v2]) {
                    edge = new Edge();
                    if (x[v1] < x[v2]) {
                        this.makeEdgeRecVertical(edges, v1, v2, this.xNext(i, x, y, cnt), edge, x, y);
                    } else {
                        this.makeEdgeRecVertical(edges, v2, v1, xPrev, edge, x, y);
                    }
                    xPrev = x[v1];
                }
                v1 = v2;
            }
        }

        public final int yNext(int k, @Nullable int[] x, @NotNull int[] y, int cnt) {
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            int j = 0;
            int n = j = k + 1 >= cnt ? 0 : k + 1;
            while (y[k] == y[j]) {
                if (j + 1 >= cnt) {
                    j = 0;
                    continue;
                }
                ++j;
            }
            return y[j];
        }

        public final int xNext(int k, @NotNull int[] x, @Nullable int[] y, int cnt) {
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            int j = 0;
            int n = j = k + 1 >= cnt ? 0 : k + 1;
            while (x[k] == x[j]) {
                if (j + 1 >= cnt) {
                    j = 0;
                    continue;
                }
                ++j;
            }
            return x[j];
        }

        public final void makeEdgeRecHorizontal(@NotNull Edge[] edges, int lower, int upper, int yComp, @NotNull Edge edge, @NotNull int[] x, @NotNull int[] y) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            edge.setDPerScan((float)(x[upper] - x[lower]) / (float)(y[upper] - y[lower]));
            edge.setIntersect(x[lower]);
            if (y[lower] < AbstractAveragingLayer.this.getCy1()) {
                edge.setIntersect(edge.getIntersect() + edge.getDPerScan() * (float)(AbstractAveragingLayer.this.getCy1() - y[lower]));
            }
            if (y[upper] < yComp) {
                edge.setUpper(y[upper] - 1);
            } else {
                edge.setUpper(y[upper]);
            }
            if (y[lower] <= AbstractAveragingLayer.this.getCy2() && edge.getUpper() >= AbstractAveragingLayer.this.getCy1()) {
                this.insertEdge(edges[Math.max(AbstractAveragingLayer.this.getCy1(), y[lower])], edge);
            }
        }

        public final void makeEdgeRecVertical(@NotNull Edge[] edges, int lower, int upper, int xComp, @NotNull Edge edge, @NotNull int[] x, @NotNull int[] y) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Intrinsics.checkNotNullParameter((Object)edge, (String)"edge");
            Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            Intrinsics.checkNotNullParameter((Object)y, (String)"y");
            edge.setDPerScan((float)(y[upper] - y[lower]) / (float)(x[upper] - x[lower]));
            edge.setIntersect(y[lower]);
            if (x[lower] < AbstractAveragingLayer.this.getCx1()) {
                edge.setIntersect(edge.getIntersect() + edge.getDPerScan() * (float)(AbstractAveragingLayer.this.getCx1() - x[lower]));
            }
            if (x[upper] < xComp) {
                edge.setUpper(x[upper] - 1);
            } else {
                edge.setUpper(x[upper]);
            }
            if (x[lower] <= AbstractAveragingLayer.this.getCx2() && edge.getUpper() >= AbstractAveragingLayer.this.getCx1()) {
                this.insertEdge(edges[Math.max(AbstractAveragingLayer.this.getCx1(), x[lower])], edge);
            }
        }

        public final void buildActiveList(@NotNull Edge[] edges, int scan, @Nullable Edge active) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Edge p = null;
            Edge q = null;
            Edge edge = edges[scan];
            Intrinsics.checkNotNull((Object)edge);
            p = edge.getNext();
            while (p != null) {
                Intrinsics.checkNotNull((Object)p.getNext());
                this.insertEdge(active, p);
                p = q;
            }
        }

        public final void plotHClipped(int scan, @NotNull Edge active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Edge p1 = null;
            Edge p2 = null;
            p1 = active.getNext();
            while (p1 != null) {
                Intrinsics.checkNotNull((Object)p1.getNext());
                int x1 = (int)(p1.getIntersect() + 0.5f);
                int x2 = (int)p2.getIntersect();
                this.plotHClipped(x1, scan, x2);
                Intrinsics.checkNotNull((Object)p2.getNext());
            }
        }

        public final void plotVClipped(int scan, @NotNull Edge active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Edge p1 = null;
            Edge p2 = null;
            p1 = active.getNext();
            while (p1 != null) {
                Intrinsics.checkNotNull((Object)p1.getNext());
                int y1 = (int)(p1.getIntersect() + 0.5f);
                int y2 = (int)p2.getIntersect();
                this.plotVClipped(y1, scan, y2);
                p1 = p2.getNext();
            }
        }

        public final void updateActiveList(int scan, @NotNull Edge active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Edge p = null;
            Edge q = null;
            q = active;
            p = active.getNext();
            while (p != null) {
                if (scan >= p.getUpper()) {
                    p = p.getNext();
                    this.deleteAfter(q);
                    continue;
                }
                Edge edge = p;
                edge.setIntersect(edge.getIntersect() + p.getDPerScan());
                q = p;
                p = p.getNext();
            }
        }

        protected final void prepareEdgeList(@NotNull Edge[] edges, int scan) {
            Intrinsics.checkNotNullParameter((Object)edges, (String)"edges");
            Edge p = null;
            Edge q = null;
            q = edges[scan];
            p = q.getNext();
            while (p != null) {
                if (scan >= p.getUpper()) {
                    p = p.getNext();
                    this.deleteAfter(q);
                    continue;
                }
                q = p;
                p = p.getNext();
            }
        }

        public final void deleteAfter(@NotNull Edge q) {
            Intrinsics.checkNotNullParameter((Object)q, (String)"q");
            Edge edge = q.getNext();
            Intrinsics.checkNotNull((Object)edge);
            Edge p = edge;
            q.setNext(p.getNext());
        }

        public final void resortActiveList(@NotNull Edge active) {
            Intrinsics.checkNotNullParameter((Object)active, (String)"active");
            Edge p = null;
            Edge q = null;
            p = active.getNext();
            active.setNext(null);
            while (p != null) {
                Intrinsics.checkNotNull((Object)p.getNext());
                this.insertEdge(active, p);
                p = q;
            }
        }

        @Override
        public void drawPoint(@Nullable Point2D point) {
            if (point != null) {
                this.lineVisitor.process((int)point.getX(), (int)point.getY());
            }
        }

        @Override
        public void fillCircle(@NotNull Rectangle2D r) {
            Intrinsics.checkNotNullParameter((Object)r, (String)"r");
            if (r.getWidth() <= 2.0 || r.getHeight() <= 2.0) {
                this.fillRectangle2D(r);
                return;
            }
            int a = (int)(r.getWidth() / (double)2);
            int b = (int)(r.getHeight() / (double)2);
            int x = 0;
            int y = b;
            long a2 = a * a;
            long b2 = b * b;
            long xcrit = (long)3 * a2 / (long)4 + 1L;
            long ycrit = (long)3 * b2 / (long)4 + 1L;
            long t = b2 + a2 - (long)2 * a2 * (long)b;
            long dxt = b2 * (long)(3 + x + x);
            long dyt = a2 * (long)(3 - y - y);
            long d2xt = b2 + b2;
            long d2yt = a2 + a2;
            Rectangle r1 = new Rectangle((int)r.getX() + a, (int)r.getY(), (int)r.getWidth() & 1, 1);
            Rectangle r2 = new Rectangle((int)r.getX() + a, (int)r.getY() + (int)r.getHeight() - 1, (int)r.getWidth() & 1, 1);
            while (y > 0) {
                if (t + a2 * (long)y < xcrit) {
                    ++x;
                    t += dxt;
                    dxt += d2xt;
                    r1.setIx(r1.getIx() - 1);
                    r1.setIwidth(r1.getIwidth() + 2);
                    r2.setIx(r2.getIx() - 1);
                    r2.setIwidth(r2.getIwidth() + 2);
                    continue;
                }
                if (t - b2 * (long)x >= ycrit) {
                    --y;
                    t += dyt;
                    dyt += d2yt;
                    r1.setIheight(r1.getIheight() + 1);
                    r2.setIheight(r2.getIheight() + 1);
                    r2.setIy(r2.getIy() - 1);
                    continue;
                }
                ++x;
                --y;
                t += dxt + dyt;
                dxt += d2xt;
                dyt += d2yt;
                if (r1.getWidth() > 0.0 && r1.getHeight() > 0.0) {
                    if (r1.getY() + r1.getHeight() < r2.getY()) {
                        this.fillRectangle2D(r1);
                        this.fillRectangle2D(r2);
                    }
                    r1.setIy(r1.getIy() + (int)r1.getHeight());
                    r1.setIheight(1);
                    r2.setIy(r2.getIy() - 1);
                    r2.setIheight(1);
                } else {
                    r1.setIheight(r1.getIheight() + 1);
                    r2.setIheight(r2.getIheight() + 1);
                    r2.setIy(r2.getIy() - 1);
                }
                r1.setIx(r1.getIx() - 1);
                r1.setIwidth(r1.getIwidth() + 2);
                r2.setIx(r2.getIx() - 1);
                r2.setIwidth(r2.getIwidth() + 2);
            }
            if (r1.getY() < r2.getY()) {
                r1.setIx((int)r.getX());
                r1.setIwidth((int)r.getWidth());
                r1.setIheight((int)(r2.getY() + r2.getHeight() - r1.getY()));
                this.fillRectangle2D(r1);
            } else if (x <= a) {
                r1.setIx((int)r.getX());
                r1.setIwidth((int)r.getWidth());
                r1.setIheight((int)(r1.getY() + r1.getHeight() - r2.getY()));
                r1.setIy((int)r2.getY());
                this.fillRectangle2D(r1);
            }
        }

        public final void horizontalLine(int x1, int y, int x2) {
            int x = x1;
            if (x <= x2) {
                while (true) {
                    this.lineVisitor.process(x, y);
                    if (x == x2) break;
                    ++x;
                }
            }
        }

        @Override
        public void fillRectangle2D(@NotNull Rectangle2D rectangle) {
            Intrinsics.checkNotNullParameter((Object)rectangle, (String)"rectangle");
            int x2 = (int)(rectangle.getX() + rectangle.getWidth()) - 1;
            int n = (int)rectangle.getHeight();
            for (int y = 0; y < n; ++y) {
                this.horizontalLine((int)rectangle.getX(), (int)(rectangle.getY() + (double)y), x2);
            }
        }

        @Override
        public void translate(int x, int y) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void rotate(double theta) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void beginPath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void moveTo(double x, double y) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void lineTo(double x, double y) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void closePath() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void stroke() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void fill() {
            throw new UnsupportedOperationException();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lorg/mkui/canvas/AbstractAveragingLayer$AveragingGraphics$MoveLineLineVisitor;", "Lorg/mkui/graphics/line/LineDrawer$LineVisitor;", "(Lorg/mkui/canvas/AbstractAveragingLayer$AveragingGraphics;)V", "process", "", "x", "", "y", "mkui"})
        private final class MoveLineLineVisitor
        implements LineDrawer.LineVisitor {
            @Override
            public void process(int x, int y) {
                if (x >= 0 && y >= 0 && x < AbstractAveragingLayer.this.getWidth() && y < AbstractAveragingLayer.this.getHeight() && AveragingGraphics.this.color != null) {
                    int i = y * AbstractAveragingLayer.this.getWidth() + x;
                    float[] c = AbstractAveragingLayer.this.getRgb()[i];
                    int[] nArray = AbstractAveragingLayer.this.getOverlay();
                    int n = nArray[i];
                    nArray[i] = n + 1;
                    Color color = AveragingGraphics.this.color;
                    Intrinsics.checkNotNull((Object)color);
                    float r = (float)(MkColorKt.getURed(color) & 0xFF) / 255.0f;
                    Color color2 = AveragingGraphics.this.color;
                    Intrinsics.checkNotNull((Object)color2);
                    float g2 = (float)(MkColorKt.getUGreen(color2) & 0xFF) / 255.0f;
                    Color color3 = AveragingGraphics.this.color;
                    Intrinsics.checkNotNull((Object)color3);
                    float b = (float)(MkColorKt.getUBlue(color3) & 0xFF) / 255.0f;
                    c[0] = c[0] + r;
                    c[1] = c[1] + g2;
                    c[2] = c[2] + b;
                    float f = c[0] / (float)AbstractAveragingLayer.this.getOverlay()[i];
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lorg/mkui/canvas/AbstractAveragingLayer$Companion;", "", "()V", "flatness", "", "lineDrawer", "Lorg/mkui/graphics/line/LineDrawer;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

