/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.FlatteningPathIterator;
import org.mkui.geom.Line2D;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.QuadIterator;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b'\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0011\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0096\u0002J\u0010\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0004H\u0016J\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0016J&\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#H\u0016R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0012\u0010\u0007\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0012\u0010\r\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0012\u0010\u000f\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0006R\u0012\u0010\u0011\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0006R\u0012\u0010\u0013\u001a\u00020\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0006\u00a8\u0006&"}, d2={"Lorg/mkui/geom/QuadCurve2D;", "Lorg/mkui/geom/Shape;", "()V", "ctrlX", "", "getCtrlX", "()D", "ctrlY", "getCtrlY", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "x1", "getX1", "x2", "getX2", "y1", "getY1", "y2", "getY2", "contains", "", "x", "y", "point", "Lorg/mkui/geom/Point2D;", "getFlattenPathIterator", "flatness", "at", "Lorg/mkui/geom/AffineTransform;", "intersects", "w", "h", "r", "Lorg/mkui/geom/Rectangle2D;", "Companion", "Double", "mkui"})
@StabilityInferred(parameters=1)
public abstract class QuadCurve2D
implements Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    @Override
    public boolean contains(@NotNull Point2D point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.contains(point.getX(), point.getY());
    }

    public final boolean contains(double x, double y) {
        double dyl;
        double dxl;
        double kx;
        double dy;
        double x1 = this.getX1();
        double y1 = this.getY1();
        double xc = this.getCtrlX();
        double yc = this.getCtrlY();
        double x2 = this.getX2();
        double dx = x - x1;
        double y2 = this.getY2();
        double ky = y1 - (double)2 * yc + y2;
        double t0 = (dx * ky - (dy = y - y1) * (kx = x1 - (double)2 * xc + x2)) / ((dxl = x2 - x1) * ky - (dyl = y2 - y1) * kx);
        if (t0 < 0.0 || t0 > 1.0 || !(t0 == t0)) {
            return false;
        }
        double xb = kx * t0 * t0 + (double)2 * (xc - x1) * t0 + x1;
        double yb = ky * t0 * t0 + (double)2 * (yc - y1) * t0 + y1;
        double xl = dxl * t0 + x1;
        double yl = dyl * t0 + y1;
        return x >= xb && x < xl || x >= xl && x < xb || y >= yb && y < yl || y >= yl && y < yb;
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract double getCtrlX();

    public abstract double getCtrlY();

    public abstract double getX2();

    public abstract double getY2();

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        boolean xoverlap;
        boolean yoverlap;
        if (w <= 0.0 || h <= 0.0) {
            return false;
        }
        double x1 = this.getX1();
        double y1 = this.getY1();
        int x1tag = QuadCurve2D.Companion.getTag(x1, x, x + w);
        int y1tag = QuadCurve2D.Companion.getTag(y1, y, y + h);
        if (x1tag == 0 && y1tag == 0) {
            return true;
        }
        double x2 = this.getX2();
        double y2 = this.getY2();
        int x2tag = QuadCurve2D.Companion.getTag(x2, x, x + w);
        int y2tag = QuadCurve2D.Companion.getTag(y2, y, y + h);
        if (x2tag == 0 && y2tag == 0) {
            return true;
        }
        double ctrlx = this.getCtrlX();
        double ctrly = this.getCtrlY();
        int ctrlxtag = QuadCurve2D.Companion.getTag(ctrlx, x, x + w);
        int ctrlytag = QuadCurve2D.Companion.getTag(ctrly, y, y + h);
        if (x1tag < 0 && x2tag < 0 && ctrlxtag < 0) {
            return false;
        }
        if (y1tag < 0 && y2tag < 0 && ctrlytag < 0) {
            return false;
        }
        if (x1tag > 0 && x2tag > 0 && ctrlxtag > 0) {
            return false;
        }
        if (y1tag > 0 && y2tag > 0 && ctrlytag > 0) {
            return false;
        }
        if (QuadCurve2D.Companion.inwards(x1tag, x2tag, ctrlxtag) && QuadCurve2D.Companion.inwards(y1tag, y2tag, ctrlytag)) {
            return true;
        }
        if (QuadCurve2D.Companion.inwards(x2tag, x1tag, ctrlxtag) && QuadCurve2D.Companion.inwards(y2tag, y1tag, ctrlytag)) {
            return true;
        }
        boolean bl = yoverlap = y1tag * y2tag <= 0;
        if (x1tag == 0 && x2tag == 0 && yoverlap) {
            return true;
        }
        boolean bl2 = xoverlap = x1tag * x2tag <= 0;
        if (y1tag == 0 && y2tag == 0 && xoverlap) {
            return true;
        }
        double[] eqn = new double[3];
        double[] res = new double[3];
        if (!yoverlap) {
            QuadCurve2D.Companion.fillEqn(eqn, y1tag < 0 ? y : y + h, y1, ctrly, y2);
            return Companion.solveQuadratic(eqn, res) == 2 && QuadCurve2D.Companion.evalQuadratic(res, 2, true, true, null, x1, ctrlx, x2) == 2 && QuadCurve2D.Companion.getTag(res[0], x, x + w) * QuadCurve2D.Companion.getTag(res[1], x, x + w) <= 0;
        }
        if (!xoverlap) {
            QuadCurve2D.Companion.fillEqn(eqn, x1tag < 0 ? x : x + w, x1, ctrlx, x2);
            return Companion.solveQuadratic(eqn, res) == 2 && QuadCurve2D.Companion.evalQuadratic(res, 2, true, true, null, y1, ctrly, y2) == 2 && QuadCurve2D.Companion.getTag(res[0], y, y + h) * QuadCurve2D.Companion.getTag(res[1], y, y + h) <= 0;
        }
        double dx = x2 - x1;
        double dy = y2 - y1;
        double k = y2 * x1 - x2 * y1;
        int c1tag = 0;
        c1tag = y1tag == 0 ? x1tag : QuadCurve2D.Companion.getTag((k + dx * (y1tag < 0 ? y : y + h)) / dy, x, x + w);
        int c2tag = 0;
        int n = y2tag == 0 ? x2tag : (c2tag = QuadCurve2D.Companion.getTag((k + dx * (y2tag < 0 ? y : y + h)) / dy, x, x + w));
        if (c1tag * c2tag <= 0) {
            return true;
        }
        c1tag = c1tag * x1tag <= 0 ? y1tag : y2tag;
        QuadCurve2D.Companion.fillEqn(eqn, c2tag < 0 ? x : x + w, x1, ctrlx, x2);
        int num = Companion.solveQuadratic(eqn, res);
        QuadCurve2D.Companion.evalQuadratic(res, num, true, true, null, y1, ctrly, y2);
        c2tag = QuadCurve2D.Companion.getTag(res[0], y, y + h);
        return c1tag * c2tag <= 0;
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        return this.getPathIterator(null);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        return new QuadIterator(this, at);
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(), flatness);
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return Shape.DefaultImpls.getBounds(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0018\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u0012H\u0002J\u0016\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u0004J \u0010\u001d\u001a\u00020\u00042\u0006\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0002J \u0010!\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u00042\u0006\u0010#\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0004H\u0002J\u0016\u0010%\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u000bJ:\u0010'\u001a\u00020\u00162\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u00042\b\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010+\u001a\u00020\u00042\b\u0010,\u001a\u0004\u0018\u00010\u000b2\u0006\u0010-\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lorg/mkui/geom/QuadCurve2D$Companion;", "", "()V", "ABOVE", "", "BELOW", "HIGHEDGE", "INSIDE", "LOWEDGE", "evalQuadratic", "vals", "", "num", "include0", "", "include1", "inflect", "c1", "", "ctrl", "c2", "fillEqn", "", "eqn", "val", "cp", "getFlatnessSq", "coords", "offset", "getTag", "coord", "low", "high", "inwards", "pttag", "opt1tag", "opt2tag", "solveQuadratic", "res", "subdivide", "src", "srcoff", "left", "leftoff", "right", "rightoff", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public final double getFlatnessSq(@NotNull double[] coords, int offset) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            return Line2D.Companion.ptSegDistSq(coords[offset + 0], coords[offset + 1], coords[offset + 4], coords[offset + 5], coords[offset + 2], coords[offset + 3]);
        }

        public final void subdivide(@NotNull double[] src, int srcoff, @Nullable double[] left, int leftoff, @Nullable double[] right, int rightoff) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            double x1 = src[srcoff + 0];
            double y1 = src[srcoff + 1];
            double ctrlx = src[srcoff + 2];
            double ctrly = src[srcoff + 3];
            double x2 = src[srcoff + 4];
            double y2 = src[srcoff + 5];
            if (left != null) {
                left[leftoff + 0] = x1;
                left[leftoff + 1] = y1;
            }
            if (right != null) {
                right[rightoff + 4] = x2;
                right[rightoff + 5] = y2;
            }
            x1 = (x1 + ctrlx) / 2.0;
            y1 = (y1 + ctrly) / 2.0;
            x2 = (x2 + ctrlx) / 2.0;
            y2 = (y2 + ctrly) / 2.0;
            ctrlx = (x1 + x2) / 2.0;
            ctrly = (y1 + y2) / 2.0;
            if (left != null) {
                left[leftoff + 2] = x1;
                left[leftoff + 3] = y1;
                left[leftoff + 4] = ctrlx;
                left[leftoff + 5] = ctrly;
            }
            if (right != null) {
                right[rightoff + 0] = ctrlx;
                right[rightoff + 1] = ctrly;
                right[rightoff + 2] = x2;
                right[rightoff + 3] = y2;
            }
        }

        public final int solveQuadratic(@NotNull double[] eqn, @NotNull double[] res) {
            Intrinsics.checkNotNullParameter((Object)eqn, (String)"eqn");
            Intrinsics.checkNotNullParameter((Object)res, (String)"res");
            double a = eqn[2];
            double b = eqn[1];
            double c = eqn[0];
            int roots = 0;
            if (a == 0.0) {
                if (b == 0.0) {
                    return -1;
                }
                res[roots++] = -c / b;
            } else {
                double d = b * b - 4.0 * a * c;
                if (d < 0.0) {
                    return 0;
                }
                d = Math.sqrt(d);
                if (b < 0.0) {
                    d = -d;
                }
                double q = (b + d) / -2.0;
                res[roots++] = q / a;
                if (!(q == 0.0)) {
                    res[roots++] = c / q;
                }
            }
            return roots;
        }

        private final void fillEqn(double[] eqn, double val, double c1, double cp, double c2) {
            eqn[0] = c1 - val;
            eqn[1] = cp + cp - c1 - c1;
            eqn[2] = c1 - cp - cp + c2;
        }

        private final int evalQuadratic(double[] vals, int num, boolean include0, boolean include1, double[] inflect, double c1, double ctrl, double c2) {
            int j = 0;
            for (int i = 0; i < num; ++i) {
                double t = vals[i];
                boolean bl = include0 ? t >= 0.0 : t > 0.0;
                if (!bl) continue;
                boolean bl2 = include1 ? t <= 1.0 : t < 1.0;
                if (!bl2 || inflect != null && inflect[1] + (double)2 * inflect[2] * t == 0.0) continue;
                double u = 1.0 - t;
                vals[j++] = c1 * u * u + (double)2 * ctrl * t * u + c2 * t * t;
            }
            return j;
        }

        private final int getTag(double coord, double low, double high) {
            if (coord <= low) {
                return coord < low ? -2 : -1;
            }
            return coord >= high ? (coord > high ? 2 : 1) : 0;
        }

        private final boolean inwards(int pttag, int opt1tag, int opt2tag) {
            return switch (pttag) {
                case -2, 2 -> false;
                case -1 -> {
                    if (opt1tag >= 0 || opt2tag >= 0) {
                        yield true;
                    }
                    yield false;
                }
                case 0 -> true;
                case 1 -> {
                    if (opt1tag <= 0 || opt2tag <= 0) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B7\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\u0004\u0012\u0006\u0010\t\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u001f\u001a\u00020\fJ6\u0010 \u001a\u00020!2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004R\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0003\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013R\u001a\u0010\b\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u0013R\u001a\u0010\u0005\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R\u001a\u0010\t\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0011\"\u0004\b\u001e\u0010\u0013\u00a8\u0006\""}, d2={"Lorg/mkui/geom/QuadCurve2D$Double;", "Lorg/mkui/geom/QuadCurve2D;", "()V", "x1", "", "y1", "ctrlx", "ctrly", "x2", "y2", "(DDDDDD)V", "bounds2D", "Lorg/mkui/geom/Rectangle2D;", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "ctrlX", "getCtrlX", "()D", "setCtrlX", "(D)V", "ctrlY", "getCtrlY", "setCtrlY", "getX1", "setX1", "getX2", "setX2", "getY1", "setY1", "getY2", "setY2", "computeBounds2D", "setCurve", "", "mkui"})
    @StabilityInferred(parameters=0)
    public static final class Double
    extends QuadCurve2D {
        private double x1;
        private double y1;
        private double ctrlX;
        private double ctrlY;
        private double x2;
        private double y2;
        public static final int $stable = 8;

        @Override
        public double getX1() {
            return this.x1;
        }

        public void setX1(double d) {
            this.x1 = d;
        }

        @Override
        public double getY1() {
            return this.y1;
        }

        public void setY1(double d) {
            this.y1 = d;
        }

        @Override
        public double getCtrlX() {
            return this.ctrlX;
        }

        public void setCtrlX(double d) {
            this.ctrlX = d;
        }

        @Override
        public double getCtrlY() {
            return this.ctrlY;
        }

        public void setCtrlY(double d) {
            this.ctrlY = d;
        }

        @Override
        public double getX2() {
            return this.x2;
        }

        public void setX2(double d) {
            this.x2 = d;
        }

        @Override
        public double getY2() {
            return this.y2;
        }

        public void setY2(double d) {
            this.y2 = d;
        }

        public Double() {
        }

        public Double(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
            this.setCurve(x1, y1, ctrlx, ctrly, x2, y2);
        }

        public final void setCurve(double x1, double y1, double ctrlx, double ctrly, double x2, double y2) {
            this.setX1(x1);
            this.setY1(y1);
            this.setCtrlX(ctrlx);
            this.setCtrlY(ctrly);
            this.setX2(x2);
            this.setY2(y2);
        }

        @Override
        @NotNull
        public Rectangle2D getBounds2D() {
            return this.computeBounds2D();
        }

        @NotNull
        public final Rectangle2D computeBounds2D() {
            double left = Math.min(Math.min(this.getX1(), this.getX2()), this.getCtrlX());
            double top = Math.min(Math.min(this.getY1(), this.getY2()), this.getCtrlY());
            double right = Math.max(Math.max(this.getX1(), this.getX2()), this.getCtrlX());
            double bottom = Math.max(Math.max(this.getY1(), this.getY2()), this.getCtrlY());
            return new Rectangle2D.Double(left, top, right - left, bottom - top);
        }
    }
}

