/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.ArrayFnKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.curve.Geom;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ParametricCurve;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a2\u0006\u0002\u0010\tJ&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012\u00a8\u0006\u0013"}, d2={"Lorg/mkui/geom/curve/BinaryCurveApproximationAlgorithm;", "", "()V", "checkSpace", "", "", "stack", "size", "", "([[DI)[[D", "genPts", "", "pc", "Lorg/mkui/geom/curve/ParametricCurve;", "t_min", "", "t_max", "mp", "Lorg/mkui/geom/curve/MultiPath;", "mkui"})
@StabilityInferred(parameters=1)
public final class BinaryCurveApproximationAlgorithm {
    @NotNull
    public static final BinaryCurveApproximationAlgorithm INSTANCE = new BinaryCurveApproximationAlgorithm();
    public static final int $stable;

    private BinaryCurveApproximationAlgorithm() {
    }

    public final void genPts(@NotNull ParametricCurve pc, double t_min, double t_max, @NotNull MultiPath mp) {
        double t2;
        Intrinsics.checkNotNullParameter((Object)pc, (String)"pc");
        Intrinsics.checkNotNullParameter((Object)mp, (String)"mp");
        int n = mp.getDimension();
        double t1 = t_min;
        double[] rdy = new double[n + 1];
        rdy[n] = t1;
        pc.eval(rdy);
        double[] p = new double[n + 1];
        p[n] = t2 = t_max;
        pc.eval(p);
        int count = 0;
        Object stack = new double[10][];
        stack[count++] = p;
        double[][] limit = new double[pc.getSampleLimit()][];
        double flatSq = mp.getFlatness() * mp.getFlatness();
        double[] d = new double[n + 1];
        while (true) {
            double m = (t1 + t2) / (double)2;
            double[] pt = new double[n + 1];
            pt[n] = m;
            pc.eval(pt);
            double dist = Geom.INSTANCE.ptSegDistSq(rdy, stack[count - 1], pt, d, n);
            if (Double.isNaN(dist) || Double.isInfinite(dist)) {
                String msg = "NaN or infinity resulted from calling the eval method of the " + Reflection.getOrCreateKotlinClass(pc.getClass()) + " class.";
                throw new RuntimeException(msg);
            }
            boolean flag = false;
            if (dist < flatSq) {
                int i;
                double mm = 0.0;
                for (i = 0; i < ((Object[])limit).length; ++i) {
                    mm = (t1 + m) / (double)2;
                    double[] q = new double[n + 1];
                    limit[i] = q;
                    q[n] = mm;
                    pc.eval(q);
                    if (Geom.INSTANCE.ptSegDistSq(rdy, pt, q, d, n) >= flatSq) break;
                    m = mm;
                }
                if (i == ((Object[])limit).length) {
                    flag = true;
                } else {
                    stack = this.checkSpace((double[][])stack, count);
                    stack[count++] = pt;
                    int j = 0;
                    int n2 = i;
                    if (j <= n2) {
                        while (true) {
                            stack = this.checkSpace((double[][])stack, count);
                            stack[count++] = limit[j];
                            if (j == n2) break;
                            ++j;
                        }
                    }
                    t2 = mm;
                }
            }
            if (flag) {
                mp.lineTo(rdy);
                mp.lineTo(pt);
                Intrinsics.checkNotNull((Object)stack[--count]);
                if (count == 0) break;
                pt = stack[count - 1];
                t1 = t2;
                Intrinsics.checkNotNull((Object)pt);
                t2 = pt[n];
                continue;
            }
            if (!(t2 > m)) continue;
            stack = this.checkSpace((double[][])stack, count);
            stack[count++] = pt;
            t2 = m;
        }
        mp.lineTo(rdy);
    }

    private final double[][] checkSpace(double[][] stack, int size) {
        if (size == ((Object[])stack).length) {
            double[][] arr = new double[2 * size][];
            ArrayFnKt.arraycopy((Object[])((Object[])stack), (int)0, (Object[])((Object[])arr), (int)0, (int)size);
            return arr;
        }
        return stack;
    }
}

