/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.Arrays;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Paint;
import javafx.scene.paint.Stop;
import javafx.scene.shape.ArcType;
import javafx.scene.text.Font;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.graphics.GraphicsContext2D;
import org.mkui.graphics.JavaFXTextMetrics;
import org.mkui.text.CPTextMetrics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u001e\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nJ.\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\rJ\b\u0010\u0012\u001a\u00020\bH\u0016J8\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J&\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rJ\b\u0010\u001d\u001a\u00020\bH\u0016J\b\u0010\u001e\u001a\u00020\bH\u0016JH\u0010\u001f\u001a\u00020\b2\n\u0010 \u001a\u00060!j\u0002`\"2\n\u0010#\u001a\u00060!j\u0002`\"2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\bH\u0016J@\u0010'\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010+J&\u0010,\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rJ\"\u0010-\u001a\u00020\b2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010/2\u0006\u00101\u001a\u000202J(\u00103\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016J6\u00104\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\rJ \u00107\u001a\u00020\b2\u0006\u00108\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0016J(\u00107\u001a\u00020\b2\b\u00108\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u00109\u001a\u00020\rJ\u0006\u0010:\u001a\u00020!J\b\u0010;\u001a\u0004\u0018\u00010<J\u0006\u0010=\u001a\u00020\rJ\u0006\u0010>\u001a\u00020\rJ\b\u0010?\u001a\u0004\u0018\u00010/J\u0006\u0010@\u001a\u00020\rJ\u0006\u0010A\u001a\u00020\rJ\u0006\u0010B\u001a\u00020!J\u0010\u0010C\u001a\u00020D2\u0006\u00108\u001a\u00020\nH\u0016J\u0016\u0010E\u001a\u00020%2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rJ\u0018\u0010F\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J\u0018\u0010G\u001a\u00020\b2\u0006\u0010H\u001a\u00020\r2\u0006\u0010I\u001a\u00020\rH\u0016J(\u0010J\u001a\u00020\b2\u0006\u0010K\u001a\u00020\r2\u0006\u0010L\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016J(\u0010M\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016J\b\u0010N\u001a\u00020\bH\u0016J\u0010\u0010O\u001a\u00020\b2\u0006\u0010P\u001a\u00020\rH\u0016J\b\u0010Q\u001a\u00020\bH\u0016J\u0018\u0010R\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0016J\u0014\u0010S\u001a\u00020\b2\n\u0010T\u001a\u00060!j\u0002`\"H\u0016J\u0014\u0010U\u001a\u00020\b2\n\u0010V\u001a\u00060<j\u0002`WH\u0016J\u0010\u0010X\u001a\u00020\b2\u0006\u0010Y\u001a\u00020\rH\u0016J\u000e\u0010Z\u001a\u00020\b2\u0006\u0010[\u001a\u00020\rJ\u0012\u0010\\\u001a\u00020\b2\n\u0010]\u001a\u00020/\"\u00020\rJ\u0010\u0010^\u001a\u00020\b2\u0006\u0010_\u001a\u00020\rH\u0016J\u000e\u0010`\u001a\u00020\b2\u0006\u0010a\u001a\u00020\rJ\u0014\u0010b\u001a\u00020\b2\n\u0010T\u001a\u00060!j\u0002`\"H\u0016J8\u0010c\u001a\u00020\b2\u0006\u0010d\u001a\u00020\r2\u0006\u0010e\u001a\u00020\r2\u0006\u0010f\u001a\u00020\r2\u0006\u0010g\u001a\u00020\r2\u0006\u0010h\u001a\u00020\r2\u0006\u0010i\u001a\u00020\rH\u0016J\b\u0010j\u001a\u00020\bH\u0016J@\u0010k\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010(\u001a\u00020\r2\u0006\u0010)\u001a\u00020\r2\b\u0010*\u001a\u0004\u0018\u00010+J(\u0010l\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\rH\u0016J&\u0010m\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rJ\"\u0010n\u001a\u00020\b2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010/2\u0006\u00101\u001a\u000202J\"\u0010o\u001a\u00020\b2\b\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u00010/2\u0006\u00101\u001a\u000202J(\u0010p\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\rH\u0016J6\u0010q\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u00105\u001a\u00020\r2\u0006\u00106\u001a\u00020\rJ \u0010r\u001a\u00020\b2\b\u00108\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rJ(\u0010r\u001a\u00020\b2\b\u00108\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u00109\u001a\u00020\rJ8\u0010s\u001a\u00020\b2\u0006\u0010d\u001a\u00020\r2\u0006\u0010e\u001a\u00020\r2\u0006\u0010f\u001a\u00020\r2\u0006\u0010g\u001a\u00020\r2\u0006\u0010h\u001a\u00020\r2\u0006\u0010i\u001a\u00020\rH\u0016J\u0018\u0010t\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006u"}, d2={"Lorg/mkui/graphics/CPGraphicsContext2D;", "Lorg/mkui/graphics/GraphicsContext2D;", "gc", "Ljavafx/scene/canvas/GraphicsContext;", "(Ljavafx/scene/canvas/GraphicsContext;)V", "getGc", "()Ljavafx/scene/canvas/GraphicsContext;", "appendSVGPath", "", "svgpath", "", "arcTo", "x1", "", "y1", "x2", "y2", "radius", "beginPath", "bezierCurveTo", "xc1", "yc1", "xc2", "yc2", "clearRect", "x", "y", "w", "h", "clip", "closePath", "drawGradient", "color1", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "color2", "isVertical", "", "fill", "fillArc", "startAngle", "arcExtent", "closure", "Ljavafx/scene/shape/ArcType;", "fillOval", "fillPolygon", "xPoints", "", "yPoints", "nPoints", "", "fillRect", "fillRoundRect", "arcWidth", "arcHeight", "fillText", "text", "maxWidth", "getFill", "getFont", "Ljavafx/scene/text/Font;", "getGlobalAlpha", "getLineDashOffset", "getLineDashes", "getLineWidth", "getMiterLimit", "getStroke", "getTextMetrics", "Lorg/mkui/text/CPTextMetrics;", "isPointInPath", "lineTo", "moveTo", "x0", "y0", "quadraticCurveTo", "xc", "yc", "rect", "restore", "rotate", "degrees", "save", "scale", "setFill", "p", "setFont", "f", "Lorg/mkui/font/MkFont;", "setGlobalAlpha", "alpha", "setLineDashOffset", "dashOffset", "setLineDashes", "dashes", "setLineWidth", "lw", "setMiterLimit", "ml", "setStroke", "setTransform", "mxx", "myx", "mxy", "myy", "mxt", "myt", "stroke", "strokeArc", "strokeLine", "strokeOval", "strokePolygon", "strokePolyline", "strokeRect", "strokeRoundRect", "strokeText", "transform", "translate", "mkui"})
@StabilityInferred(parameters=0)
public final class CPGraphicsContext2D
implements GraphicsContext2D {
    @NotNull
    private final GraphicsContext gc;
    public static final int $stable = 8;

    public CPGraphicsContext2D(@NotNull GraphicsContext gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.gc = gc;
    }

    @NotNull
    public final GraphicsContext getGc() {
        return this.gc;
    }

    @Override
    @NotNull
    public CPTextMetrics getTextMetrics(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new JavaFXTextMetrics(this.gc, text);
    }

    @Override
    public void drawGradient(@NotNull Color color1, @NotNull Color color2, double x, double y, double w, double h, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color2");
        if (isVertical) {
            Stop[] stopArray = new Stop[]{new Stop(0.0, color1), new Stop(1.0, color2)};
            this.gc.setFill((Paint)new LinearGradient(0.0, y, 0.0, y + h, false, CycleMethod.NO_CYCLE, stopArray));
            this.gc.fillRect(x, y, w, h);
        } else {
            Stop[] stopArray = new Stop[]{new Stop(0.0, color1), new Stop(1.0, color2)};
            this.gc.setFill((Paint)new LinearGradient(x, 0.0, x + w, 0.0, false, CycleMethod.NO_CYCLE, stopArray));
            this.gc.fillRect(x, y, w, h);
        }
    }

    @Override
    public void save() {
        this.gc.save();
    }

    @Override
    public void restore() {
        this.gc.restore();
    }

    @Override
    public void translate(double x, double y) {
        this.gc.translate(x, y);
    }

    @Override
    public void scale(double x, double y) {
        this.gc.scale(x, y);
    }

    @Override
    public void rotate(double degrees) {
        this.gc.rotate(degrees);
    }

    @Override
    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.gc.transform(mxx, myx, mxy, myy, mxt, myt);
    }

    @Override
    public void setTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.gc.setTransform(mxx, myx, mxy, myy, mxt, myt);
    }

    public final double getGlobalAlpha() {
        return this.gc.getGlobalAlpha();
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.gc.setGlobalAlpha(alpha);
    }

    @NotNull
    public final Color getFill() {
        Paint paint = this.gc.getFill();
        Intrinsics.checkNotNull((Object)paint, (String)"null cannot be cast to non-null type javafx.scene.paint.Color");
        return (Color)paint;
    }

    @Override
    public void setFill(@NotNull Color p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.gc.setFill((Paint)p);
    }

    @NotNull
    public final Color getStroke() {
        Paint paint = this.gc.getStroke();
        Intrinsics.checkNotNull((Object)paint, (String)"null cannot be cast to non-null type javafx.scene.paint.Color");
        return (Color)paint;
    }

    @Override
    public void setStroke(@NotNull Color p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.gc.setStroke((Paint)p);
    }

    public final double getLineWidth() {
        return this.gc.getLineWidth();
    }

    @Override
    public void setLineWidth(double lw) {
        this.gc.setLineWidth(lw);
    }

    public final double getMiterLimit() {
        return this.gc.getMiterLimit();
    }

    public final void setMiterLimit(double ml) {
        this.gc.setMiterLimit(ml);
    }

    @Nullable
    public final double[] getLineDashes() {
        return this.gc.getLineDashes();
    }

    public final void setLineDashes(double ... dashes) {
        Intrinsics.checkNotNullParameter((Object)dashes, (String)"dashes");
        this.gc.setLineDashes(Arrays.copyOf(dashes, dashes.length));
    }

    public final double getLineDashOffset() {
        return this.gc.getLineDashOffset();
    }

    public final void setLineDashOffset(double dashOffset) {
        this.gc.setLineDashOffset(dashOffset);
    }

    @Nullable
    public final Font getFont() {
        return this.gc.getFont();
    }

    @Override
    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.gc.setFont(f);
    }

    @Override
    public void fillText(@NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.gc.fillText(text, x, y);
    }

    @Override
    public void beginPath() {
        this.gc.beginPath();
    }

    @Override
    public void moveTo(double x0, double y0) {
        this.gc.moveTo(x0, y0);
    }

    @Override
    public void lineTo(double x1, double y1) {
        this.gc.lineTo(x1, y1);
    }

    @Override
    public void quadraticCurveTo(double xc, double yc, double x1, double y1) {
        this.gc.quadraticCurveTo(xc, yc, x1, y1);
    }

    @Override
    public void bezierCurveTo(double xc1, double yc1, double xc2, double yc2, double x1, double y1) {
        this.gc.bezierCurveTo(xc1, yc1, xc2, yc2, x1, y1);
    }

    @Override
    public void rect(double x, double y, double w, double h) {
        this.gc.rect(x, y, w, h);
    }

    @Override
    public void closePath() {
        this.gc.closePath();
    }

    @Override
    public void fill() {
        this.gc.fill();
    }

    @Override
    public void stroke() {
        this.gc.stroke();
    }

    @Override
    public void clip() {
        this.gc.clip();
    }

    @Override
    public void fillRect(double x, double y, double w, double h) {
        this.gc.fillRect(x, y, w, h);
    }

    @Override
    public void strokeRect(double x, double y, double w, double h) {
        this.gc.strokeRect(x, y, w, h);
    }

    @Override
    public void strokeLine(double x1, double y1, double x2, double y2) {
        this.gc.strokeLine(x1, y1, x2, y2);
    }

    public final void strokeText(@Nullable String text, double x, double y) {
        this.gc.strokeText(text, x, y);
    }

    public final void fillText(@Nullable String text, double x, double y, double maxWidth) {
        this.gc.fillText(text, x, y, maxWidth);
    }

    public final void strokeText(@Nullable String text, double x, double y, double maxWidth) {
        this.gc.strokeText(text, x, y, maxWidth);
    }

    public final void arcTo(double x1, double y1, double x2, double y2, double radius) {
        this.gc.arcTo(x1, y1, x2, y2, radius);
    }

    public final void appendSVGPath(@Nullable String svgpath) {
        this.gc.appendSVGPath(svgpath);
    }

    public final boolean isPointInPath(double x, double y) {
        return this.gc.isPointInPath(x, y);
    }

    public final void clearRect(double x, double y, double w, double h) {
        this.gc.clearRect(x, y, w, h);
    }

    public final void fillOval(double x, double y, double w, double h) {
        this.gc.fillOval(x, y, w, h);
    }

    public final void strokeOval(double x, double y, double w, double h) {
        this.gc.strokeOval(x, y, w, h);
    }

    public final void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, @Nullable ArcType closure) {
        this.gc.fillArc(x, y, w, h, startAngle, arcExtent, closure);
    }

    public final void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, @Nullable ArcType closure) {
        this.gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure);
    }

    public final void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        this.gc.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
    }

    public final void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        this.gc.strokeRoundRect(x, y, w, h, arcWidth, arcHeight);
    }

    public final void fillPolygon(@Nullable double[] xPoints, @Nullable double[] yPoints, int nPoints) {
        this.gc.fillPolygon(xPoints, yPoints, nPoints);
    }

    public final void strokePolygon(@Nullable double[] xPoints, @Nullable double[] yPoints, int nPoints) {
        this.gc.strokePolygon(xPoints, yPoints, nPoints);
    }

    public final void strokePolyline(@Nullable double[] xPoints, @Nullable double[] yPoints, int nPoints) {
        this.gc.strokePolyline(xPoints, yPoints, nPoints);
    }
}

