/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.javafx;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SelectionEvent;
import com.macrofocus.common.selection.SelectionListener;
import com.macrofocus.common.selection.SimpleSingleSelection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.ComboBox;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.layout.VBox;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.javafx.SingleSelectionSingleSelectionModel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0018B#\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J\u001d\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\b\u0010\u0012\u001a\u0004\u0018\u00018\u0000H\u0004\u00a2\u0006\u0002\u0010\u0013J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015H\u0004J\u0006\u0010\u0016\u001a\u00020\u0017R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\f0\fR\b\u0012\u0004\u0012\u00028\u00000\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lorg/mkui/javafx/VerticalHierarchicalComboBox;", "E", "Ljavafx/scene/layout/VBox;", "selection", "Lcom/macrofocus/common/selection/MutableSelection;", "values", "", "(Lcom/macrofocus/common/selection/MutableSelection;Ljava/lang/Iterable;)V", "comboBoxes", "", "Ljavafx/scene/control/ComboBox;", "itemListener", "Lorg/mkui/javafx/VerticalHierarchicalComboBox$GroupByItemListener;", "getSelection", "()Lcom/macrofocus/common/selection/MutableSelection;", "getValues", "()Ljava/lang/Iterable;", "createComboBox", "element", "(Ljava/lang/Object;)Ljavafx/scene/control/ComboBox;", "comboBoxModel", "Lorg/mkui/javafx/SingleSelectionSingleSelectionModel;", "createComboBoxes", "", "GroupByItemListener", "mkui"})
@StabilityInferred(parameters=0)
public class VerticalHierarchicalComboBox<E>
extends VBox {
    @NotNull
    private final MutableSelection<E> selection;
    @NotNull
    private final Iterable<E> values;
    @NotNull
    private final List<ComboBox<E>> comboBoxes;
    @NotNull
    private final GroupByItemListener itemListener;
    public static final int $stable = 8;

    public VerticalHierarchicalComboBox(@NotNull MutableSelection<E> selection, @NotNull Iterable<? extends E> values) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.selection = selection;
        this.values = values;
        this.comboBoxes = new ArrayList();
        this.itemListener = new GroupByItemListener();
        this.selection.addSelectionListener(new SelectionListener<E>(){

            public void selectionChanged(@NotNull SelectionEvent<E> event) {
                Intrinsics.checkNotNullParameter(event, (String)"event");
                this.createComboBoxes();
            }
        });
        this.createComboBoxes();
    }

    @NotNull
    public final MutableSelection<E> getSelection() {
        return this.selection;
    }

    @NotNull
    public final Iterable<E> getValues() {
        return this.values;
    }

    public final void createComboBoxes() {
        for (ComboBox<E> comboBox : this.comboBoxes) {
            comboBox.getSelectionModel().selectedItemProperty().removeListener((ChangeListener)this.itemListener);
        }
        this.getChildren().clear();
        this.comboBoxes.clear();
        MutableSelection<E> groupByTreeMapFields = this.selection;
        for (Object e : groupByTreeMapFields) {
            ComboBox comboBox2 = this.createComboBox(e);
            this.comboBoxes.add(comboBox2);
        }
        ComboBox<Object> comboBox = this.createComboBox((E)null);
        this.comboBoxes.add(comboBox);
        for (ComboBox comboBox2 : this.comboBoxes) {
            this.getChildren().add(comboBox2);
            comboBox2.getSelectionModel().selectedItemProperty().addListener((ChangeListener)this.itemListener);
        }
    }

    @NotNull
    protected final ComboBox<E> createComboBox(@Nullable E element) {
        MutableSingleSelection selection = element != null ? (MutableSingleSelection)new SimpleSingleSelection(element) : (MutableSingleSelection)new SimpleSingleSelection();
        SingleSelectionSingleSelectionModel<E> comboBoxModel = new SingleSelectionSingleSelectionModel<E>(selection, this.values);
        return this.createComboBox(comboBoxModel);
    }

    @NotNull
    protected final ComboBox<E> createComboBox(@NotNull SingleSelectionSingleSelectionModel<E> comboBoxModel) {
        Intrinsics.checkNotNullParameter(comboBoxModel, (String)"comboBoxModel");
        ComboBox comboBox = new ComboBox();
        comboBox.setItems(comboBoxModel.getList());
        comboBox.getSelectionModel().select(comboBoxModel.getSelectedItem());
        comboBox.setSelectionModel((SingleSelectionModel)comboBoxModel);
        return comboBox;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\u00020\u00042\u0010\u0010\u0005\u001a\f\u0012\u0006\b\u0001\u0012\u00028\u0000\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00028\u00002\u0006\u0010\b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lorg/mkui/javafx/VerticalHierarchicalComboBox$GroupByItemListener;", "Ljavafx/beans/value/ChangeListener;", "(Lorg/mkui/javafx/VerticalHierarchicalComboBox;)V", "changed", "", "observable", "Ljavafx/beans/value/ObservableValue;", "oldValue", "newValue", "(Ljavafx/beans/value/ObservableValue;Ljava/lang/Object;Ljava/lang/Object;)V", "mkui"})
    private final class GroupByItemListener
    implements ChangeListener<E> {
        public void changed(@Nullable ObservableValue<? extends E> observable2, E oldValue, E newValue) {
            ComboBox comboBox;
            Object item;
            ArrayList<Object> groupBy = new ArrayList<Object>();
            Set selected = new HashSet();
            Iterator iterator = VerticalHierarchicalComboBox.this.comboBoxes.iterator();
            while (iterator.hasNext() && (item = (comboBox = (ComboBox)iterator.next()).getSelectionModel().getSelectedItem()) != null && !selected.contains(item)) {
                selected.add(item);
                groupBy.add(item);
                if (observable2 != comboBox.getSelectionModel().selectedItemProperty()) continue;
            }
            VerticalHierarchicalComboBox.this.getSelection().setSelectedIterable((Iterable)groupBy);
        }
    }
}

