/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.labeling;

import javafx.scene.paint.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.color.MkColorKt;
import org.mkui.color.crossplatform.CPColorKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0007\u001a\"\u0010\u0007\u001a\u00060\u0001j\u0002`\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t\u001a\u000e\u0010\f\u001a\u00020\r*\u00060\u0001j\u0002`\u0002\u001a\u001a\u0010\u000e\u001a\u00020\t*\u00060\u0001j\u0002`\u00022\n\u0010\u000f\u001a\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010\u0010\u001a\u00020\r*\u00060\u0001j\u0002`\u0002\u001a\u000e\u0010\u0011\u001a\u00020\t*\u00060\u0001j\u0002`\u0002\u001a\u001a\u0010\u0012\u001a\u00060\u0001j\u0002`\u0002*\u00060\u0001j\u0002`\u00022\u0006\u0010\u0013\u001a\u00020\r\"\u0015\u0010\u0000\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00060\u0001j\u0002`\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0014"}, d2={"Black", "Ljavafx/scene/paint/Color;", "Lorg/mkui/color/MkColor;", "getBlack", "()Ljavafx/scene/paint/Color;", "White", "getWhite", "getHSBColor", "h", "", "s", "b", "brightness", "", "diff", "background", "lum", "luminance", "replaceBrightness", "min", "mkui"})
public final class EnhancedLabelKt {
    @NotNull
    private static final Color Black = MkColorKt.colorOf-bW95L_I((byte)0, (byte)0, (byte)0, (byte)-1);
    @NotNull
    private static final Color White = MkColorKt.colorOf-bW95L_I((byte)-1, (byte)-1, (byte)-1, (byte)-1);

    @NotNull
    public static final Color replaceBrightness(@NotNull Color $this$replaceBrightness, double min) {
        Intrinsics.checkNotNullParameter((Object)$this$replaceBrightness, (String)"<this>");
        float[] hsb = CPColorKt.RGBtoHSB(MkColorKt.getURed($this$replaceBrightness) & 0xFF, MkColorKt.getUGreen($this$replaceBrightness) & 0xFF, MkColorKt.getUBlue($this$replaceBrightness) & 0xFF, null);
        return EnhancedLabelKt.getHSBColor(hsb[0], hsb[1], (float)min);
    }

    @NotNull
    public static final Color getHSBColor(float h, float s, float b) {
        return MkColorKt.colorOf(CPColorKt.HSBtoRGB(h, s, b));
    }

    public static final double brightness(@NotNull Color $this$brightness) {
        Intrinsics.checkNotNullParameter((Object)$this$brightness, (String)"<this>");
        float[] hsb = CPColorKt.RGBtoHSB(MkColorKt.getURed($this$brightness) & 0xFF, MkColorKt.getUGreen($this$brightness) & 0xFF, MkColorKt.getUBlue($this$brightness) & 0xFF, null);
        return hsb[2];
    }

    public static final double lum(@NotNull Color $this$lum) {
        Intrinsics.checkNotNullParameter((Object)$this$lum, (String)"<this>");
        int r = MkColorKt.getURed($this$lum) & 0xFF;
        int g2 = MkColorKt.getUGreen($this$lum) & 0xFF;
        int b = MkColorKt.getUBlue($this$lum) & 0xFF;
        return 0.299 * (double)r + 0.587 * (double)g2 + 0.114 * (double)b;
    }

    public static final float luminance(@NotNull Color $this$luminance) {
        Intrinsics.checkNotNullParameter((Object)$this$luminance, (String)"<this>");
        int r = MkColorKt.getURed($this$luminance) & 0xFF;
        int g2 = MkColorKt.getUGreen($this$luminance) & 0xFF;
        int b = MkColorKt.getUBlue($this$luminance) & 0xFF;
        return (0.299f * (float)r + 0.587f * (float)g2 + 0.114f * (float)b) / 255.0f;
    }

    public static final float diff(@NotNull Color $this$diff, @NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)$this$diff, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
        int r = Math.abs((MkColorKt.getURed($this$diff) & 0xFF) - (MkColorKt.getURed(background) & 0xFF));
        int g2 = Math.abs((MkColorKt.getUGreen($this$diff) & 0xFF) - (MkColorKt.getUGreen(background) & 0xFF));
        int b = Math.abs((MkColorKt.getUBlue($this$diff) & 0xFF) - (MkColorKt.getUBlue(background) & 0xFF));
        return (float)Math.max(r, Math.max(g2, b)) / 255.0f;
    }

    @NotNull
    public static final Color getBlack() {
        return Black;
    }

    @NotNull
    public static final Color getWhite() {
        return White;
    }
}

