package org.mkui.svg

public expect class DOMRect {
    internal var x     : Double
    internal var y     : Double
    internal var width : Double
    internal var height: Double
}

public expect abstract class Element: Node {
    public open var id        : String
    public open var className : String
    public open var scrollTop : Double
    public open var scrollLeft: Double

    public open val clientWidth : Int
    public open val clientHeight: Int

    public fun getBoundingClientRect(): DOMRect

    public fun setAttribute   (                    qualifiedName: String, value: String)
    public fun setAttributeNS (namespace: String?, qualifiedName: String, value: String)
    public fun removeAttribute(                    qualifiedName: String               )

    public fun scrollTo(x: Double, y: Double)
}