import org.apache.batik.anim.dom.SAXSVGDocumentFactory
import org.apache.batik.anim.dom.SVGDOMImplementation
import org.apache.batik.transcoder.TranscoderException
import org.apache.batik.transcoder.TranscoderInput
import org.apache.batik.transcoder.TranscoderOutput
import org.apache.batik.transcoder.svg2svg.SVGTranscoder
import org.apache.batik.util.XMLResourceDescriptor
import org.w3c.dom.DOMImplementation
import org.w3c.dom.Document
import org.w3c.dom.Element
import java.io.*

fun main() {
    val impl: DOMImplementation = SVGDOMImplementation.getDOMImplementation()
    val svgNS = SVGDOMImplementation.SVG_NAMESPACE_URI
    val doc: Document = impl.createDocument(svgNS, "svg", null)

// Get the root element (the 'svg' element).

// Get the root element (the 'svg' element).
    val svgRoot: Element = doc.getDocumentElement()

// Set the width and height attributes on the root 'svg' element.

// Set the width and height attributes on the root 'svg' element.
    svgRoot.setAttributeNS(null, "width", "400")
    svgRoot.setAttributeNS(null, "height", "450")

// Create the rectangle.

// Create the rectangle.
    val rectangle: Element = doc.createElementNS(svgNS, "rect")
    rectangle.setAttributeNS(null, "x", "10")
    rectangle.setAttributeNS(null, "y", "20")
    rectangle.setAttributeNS(null, "width", "100")
    rectangle.setAttributeNS(null, "height", "50")
    rectangle.setAttributeNS(null, "fill", "red")

// Attach the rectangle to the root 'svg' element.

// Attach the rectangle to the root 'svg' element.
    svgRoot.appendChild(rectangle)

    val uri = "/Users/luc/kotlin/macrofocus/eflux/preprocessing/input/netzschema.svg"
//    DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(uri);

//    System.setProperty("org.xml.sax.driver", "org.apache.xerces.parsers.SAXParser")
    XMLResourceDescriptor.setXMLParserClassName("org.apache.xerces.parsers.SAXParser")
    val parser: String = XMLResourceDescriptor.getXMLParserClassName()
    val factory = SAXSVGDocumentFactory(parser)
    val x = factory.createDocument(uri)
    println(x)

    val fileData = transcodeToSVG(doc)
    val fileSave = FileOutputStream("/Users/luc/kotlin/macrofocus/eflux/preprocessing/netzschema.svg")
    println(fileData!!.size)
    fileSave.write(fileData)
    fileSave.close()
}

@Throws(TranscoderException::class)
fun transcodeToSVG(doc: Document?): ByteArray? {
    try {
        //Determine output type:
        val t = SVGTranscoder()

        //Set transcoder input/output
        val input = TranscoderInput(doc)
        val bytestream = ByteArrayOutputStream()
        val ostream = OutputStreamWriter(bytestream)
        val output = TranscoderOutput(ostream)

        //Perform transcoding
        t.transcode(input, output)
        ostream.flush()
        ostream.close()
        return bytestream.toByteArray()
    } catch (e: IOException) {
        // TODO Auto-generated catch block
        e.printStackTrace()
    }
    return null
}