package org.mkui.svg

import org.apache.batik.anim.dom.SAXSVGDocumentFactory
import org.apache.batik.anim.dom.SVGDOMImplementation
import org.apache.batik.anim.dom.SVGOMDocument
import org.apache.batik.bridge.*
import org.apache.batik.transcoder.print.PrintTranscoder
import org.apache.batik.util.XMLResourceDescriptor
import org.w3c.dom.DOMImplementation


public actual interface ElementCreationOptions

class DocumentTranscoder : PrintTranscoder() {

    public  var userAgent: UserAgent? = null

    override fun createUserAgent(): UserAgent {
        userAgent = super.createUserAgent()

        return userAgent
    }
}

public actual class Document(private val document: org.w3c.dom.Document) {

//    init {
//    }

//    public actual var body: HTMLElement?     = null
//    public actual val head: HTMLHeadElement? = null

    constructor(b: Boolean) : this(SVGDOMImplementation.getDOMImplementation().createDocument("http://www.w3.org/2000/svg", "svg", null) as SVGOMDocument) {
//        val impl: DOMImplementation = SVGDOMImplementation.getDOMImplementation()
//        document = impl.createDocument("http://www.w3.org/2000/svg", "svg", null) as SVGOMDocument

        val document = document as SVGOMDocument

        val svgDocumentBridge = SVGDocumentBridge()
        document.svgContext = svgDocumentBridge
        println(document.svgContext)

        val e: org.w3c.dom.Element = document.createElementNS("http://www.w3.org/2000/svg", "g")
        println(e)

        val transcoder = DocumentTranscoder()
        val userAgent = transcoder.userAgent
        println(svgDocumentBridge.createGraphicsNode(BridgeContext(userAgent, DocumentLoader(userAgent)), document))
    }

    public actual fun createElement(localName: String, options: ElementCreationOptions): Element = document.createElement(localName)

//    public actual fun createTextNode(data: String): Text = Text()
    public actual fun createElementNS(namespace: String?, qualifiedName: String, options: ElementCreationOptions): Element {
        return document.createElementNS(namespace, qualifiedName)
    }
//    public actual val styleSheets: StyleSheetList = object: StyleSheetList() {
//        override val length get() = values.size
//    }
    actual val rootElement: SVGSVGElement?
        get() = document.documentElement as SVGSVGElement


}

//public actual abstract class CharacterData   : Node()
//public actual          class Text            : CharacterData()
actual fun String.toDocument(): Document {
    XMLResourceDescriptor.setXMLParserClassName("org.apache.xerces.parsers.SAXParser")
    val parser: String = XMLResourceDescriptor.getXMLParserClassName()
    val factory = SAXSVGDocumentFactory(parser)
    val doc = factory.createDocument(null, this.byteInputStream())

    val userAgent = UserAgentAdapter()
    val loader = DocumentLoader(userAgent)
    val ctx = BridgeContext(userAgent, loader)
    ctx.setDynamicState(BridgeContext.DYNAMIC)
    val builder = GVTBuilder()
    val rootGN = builder.build(ctx, doc)
    return Document(doc)
}