/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.DirectSwingLayer;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.SwingLayer;
import org.mkui.graphics.IDrawing;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\n\u001a\u00060\u000bj\u0002`\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0018\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0016\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0018\u00010\u000bj\u0004\u0018\u0001`\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/mkui/canvas/BufferedSwingLayer;", "Lorg/mkui/canvas/SwingLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "antialiasing", "", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "(Lorg/mkui/graphics/IDrawing;ZLorg/mkui/canvas/PaletteProvider;)V", "(Lorg/mkui/graphics/IDrawing;Z)V", "color", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "composite", "Ljava/awt/Composite;", "(Lorg/mkui/graphics/IDrawing;ZLjava/awt/Color;Ljava/awt/Composite;)V", "height", "", "image", "Ljava/awt/image/BufferedImage;", "screenImage", "width", "clear", "", "prepare", "render", "g", "Ljava/awt/Graphics2D;", "resize", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class BufferedSwingLayer
implements SwingLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    @Nullable
    private PaletteProvider paletteProvider;
    @Nullable
    private Color color;
    @Nullable
    private Composite composite;
    private int width;
    private int height;
    @Nullable
    private BufferedImage image;
    @Nullable
    private BufferedImage screenImage;
    public static final int $stable = 8;

    public BufferedSwingLayer(@NotNull IDrawing iDrawing, boolean antialiasing, @Nullable PaletteProvider paletteProvider) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.paletteProvider = paletteProvider;
    }

    public BufferedSwingLayer(@NotNull IDrawing iDrawing, boolean antialiasing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
    }

    public BufferedSwingLayer(@NotNull IDrawing iDrawing, boolean antialiasing, @NotNull Color color, @Nullable Composite composite) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.color = color;
        this.composite = composite;
    }

    @Override
    public void prepare(int width, int height) {
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.resize(width, height);
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
            Graphics2D g2 = graphics2D;
            DirectSwingLayer.Companion.draw(g2, this.iDrawing, this.width, this.height, this.antialiasing, this.paletteProvider, this.color, this.composite);
            g2.dispose();
            BufferedImage bufferedImage2 = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage2);
            BufferedImage bufferedImage3 = this.screenImage;
            Intrinsics.checkNotNull((Object)bufferedImage3);
            BufferedSwingLayer.Companion.copySrcIntoDstAt(bufferedImage2, bufferedImage3);
        }
    }

    public final void resize(int width, int height) {
        if (this.width != width || this.height != height) {
            this.image = new BufferedImage(width, height, 2);
            this.screenImage = new BufferedImage(width, height, 2);
            this.width = width;
            this.height = height;
        } else {
            this.clear();
        }
    }

    public final void clear() {
        if (this.image != null) {
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"createGraphics(...)");
            Graphics2D g2 = graphics2D;
            g2.setComposite(AlphaComposite.Clear);
            g2.setColor(new Color(255, 255, 255, 0));
            BufferedImage bufferedImage2 = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage2);
            int n = bufferedImage2.getWidth();
            BufferedImage bufferedImage3 = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage3);
            g2.fillRect(0, 0, n, bufferedImage3.getHeight());
            g2.dispose();
        }
    }

    @Override
    public void render(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
        if (this.iDrawing.isActive() && this.image != null) {
            g2.drawImage((Image)this.screenImage, 0, 0, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\b"}, d2={"Lorg/mkui/canvas/BufferedSwingLayer$Companion;", "", "()V", "copySrcIntoDstAt", "", "src", "Ljava/awt/image/BufferedImage;", "dst", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final void copySrcIntoDstAt(BufferedImage src, BufferedImage dst) {
            DataBuffer dataBuffer = src.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getData(...)");
            int[] srcbuf = nArray;
            DataBuffer dataBuffer2 = dst.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer2, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            int[] nArray2 = ((DataBufferInt)dataBuffer2).getData();
            Intrinsics.checkNotNullExpressionValue((Object)nArray2, (String)"getData(...)");
            int[] dstbuf = nArray2;
            System.arraycopy(srcbuf, 0, dstbuf, 0, srcbuf.length);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

