/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.coloring.implementation;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.collection.WeakReference;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.coloring.Coloring;
import org.mkui.coloring.ColoringListener;
import org.mkui.coloring.implementation.ColoringEvent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b'\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0016\u0010\n\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\u0016\u0010\u000b\u001a\u00020\b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0004J\u0016\u0010\u000e\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0016J\b\u0010\u000f\u001a\u00020\bH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/mkui/coloring/implementation/AbstractColoring;", "E", "Lorg/mkui/coloring/Coloring;", "()V", "listeners", "", "Lorg/mkui/coloring/ColoringListener;", "addColoringListener", "", "listener", "addWeakColoringListener", "notifyColoringChanged", "event", "Lorg/mkui/coloring/implementation/ColoringEvent;", "removeColoringListener", "removeColoringListeners", "WeakColoringListener", "mkui"})
@StabilityInferred(parameters=0)
public abstract class AbstractColoring<E>
implements Coloring<E> {
    @NotNull
    private final List<ColoringListener<E>> listeners = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    public static final int $stable = 8;

    @Override
    public void addColoringListener(@NotNull ColoringListener<E> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.add(listener);
    }

    @Override
    public void addWeakColoringListener(@NotNull ColoringListener<E> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        this.listeners.add(new WeakColoringListener(listener));
    }

    @Override
    public void removeColoringListener(@NotNull ColoringListener<E> listener) {
        Intrinsics.checkNotNullParameter(listener, (String)"listener");
        if (listener instanceof WeakColoringListener) {
            boolean bl = this.listeners.remove(listener);
        } else {
            ColoringListener<E> toRemove = null;
            for (ColoringListener<E> filterListener : this.listeners) {
                ColoringListener<E> comparable = null;
                comparable = filterListener instanceof WeakColoringListener ? ((WeakColoringListener)filterListener).getReference() : filterListener;
                if (!Intrinsics.areEqual(listener, comparable)) continue;
                toRemove = filterListener;
            }
            if (toRemove != null) {
                boolean bl = this.listeners.remove(toRemove);
            }
        }
    }

    @Override
    public void removeColoringListeners() {
        this.listeners.clear();
    }

    protected final void notifyColoringChanged(@NotNull ColoringEvent<E> event2) {
        Intrinsics.checkNotNullParameter(event2, (String)"event");
        for (ColoringListener<E> listener : this.listeners) {
            listener.coloringChanged(event2);
        }
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00028\u00000\u0001\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00018F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lorg/mkui/coloring/implementation/AbstractColoring$WeakColoringListener;", "Lorg/mkui/coloring/ColoringListener;", "listener", "(Lorg/mkui/coloring/implementation/AbstractColoring;Lorg/mkui/coloring/ColoringListener;)V", "l_ref", "Lcom/macrofocus/common/collection/WeakReference;", "reference", "getReference", "()Lorg/mkui/coloring/ColoringListener;", "coloringChanged", "", "event", "Lorg/mkui/coloring/implementation/ColoringEvent;", "mkui"})
    private final class WeakColoringListener
    implements ColoringListener<E> {
        @NotNull
        private final WeakReference<ColoringListener<E>> l_ref;

        public WeakColoringListener(ColoringListener<E> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            this.l_ref = new WeakReference(listener);
        }

        @Nullable
        public final ColoringListener<E> getReference() {
            return (ColoringListener)this.l_ref.get();
        }

        @Override
        public void coloringChanged(@NotNull ColoringEvent<E> event2) {
            Intrinsics.checkNotNullParameter(event2, (String)"event");
            ColoringListener l = this.getReference();
            if (l != null) {
                l.coloringChanged(event2);
            } else {
                Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type org.mkui.coloring.ColoringListener<E of org.mkui.coloring.implementation.AbstractColoring>");
                AbstractColoring.this.removeColoringListener(this);
            }
        }
    }
}

