/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.RoundRectangle2D;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020&H\u0016J\t\u0010'\u001a\u00020(H\u0096\u0002R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rR\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\rR\u0014\u0010\u001d\u001a\u00020\u00138VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0015R\u0011\u0010\u001f\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\rR\u0011\u0010!\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\r\u00a8\u0006*"}, d2={"Lorg/mkui/geom/RoundRectIterator;", "Lorg/mkui/geom/PathIterator;", "rr", "Lorg/mkui/geom/RoundRectangle2D;", "at", "Lorg/mkui/geom/AffineTransform;", "(Lorg/mkui/geom/RoundRectangle2D;Lorg/mkui/geom/AffineTransform;)V", "affine", "getAffine", "()Lorg/mkui/geom/AffineTransform;", "ah", "", "getAh", "()D", "aw", "getAw", "h", "getH", "index", "", "getIndex", "()I", "setIndex", "(I)V", "isDone", "", "()Z", "w", "getW", "windingRule", "getWindingRule", "x", "getX", "y", "getY", "currentSegment", "coords", "", "", "next", "", "Companion", "mkui"})
public final class RoundRectIterator
implements PathIterator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    private final double w;
    private final double h;
    private final double aw;
    private final double ah;
    @Nullable
    private final AffineTransform affine;
    private int index;
    private static final double angle = 0.7853981633974483;
    private static final double a = 1.0 - Math.cos(0.7853981633974483);
    private static final double b = Math.tan(0.7853981633974483);
    private static final double c = Math.sqrt(1.0 + b * b) - 1.0 + a;
    private static final double cv = 1.3333333333333333 * a * b / c;
    private static final double acv = (1.0 - cv) / 2.0;
    @NotNull
    private static final double[][] ctrlpts;
    @NotNull
    private static final int[] types;

    public RoundRectIterator(@NotNull RoundRectangle2D rr, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)rr, (String)"rr");
        this.x = rr.getX();
        this.y = rr.getY();
        this.w = rr.getWidth();
        this.h = rr.getHeight();
        this.aw = Math.min(this.w, Math.abs(rr.getArcWidth()));
        this.ah = Math.min(this.h, Math.abs(rr.getArcHeight()));
        this.affine = at;
        if (this.aw < 0.0 || this.ah < 0.0) {
            this.index = ((Object[])ctrlpts).length;
        }
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getW() {
        return this.w;
    }

    public final double getH() {
        return this.h;
    }

    public final double getAw() {
        return this.aw;
    }

    public final double getAh() {
        return this.ah;
    }

    @Nullable
    public final AffineTransform getAffine() {
        return this.affine;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        this.index = n;
    }

    @Override
    public int getWindingRule() {
        return 1;
    }

    @Override
    public boolean isDone() {
        return this.index >= ((Object[])ctrlpts).length;
    }

    @Override
    public void next() {
        int n = this.index;
        this.index = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("roundrect iterator out of bounds");
            }
            double[] ctrls = ctrlpts[this.index];
            int nc = 0;
            for (int i = 0; i < ctrls.length; i += 4) {
                coords[nc++] = (float)(this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.aw);
                coords[nc++] = (float)(this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.ah);
            }
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block2;
            affineTransform.transform(coords, 0, coords, 0, nc / 2);
        }
        return types[this.index];
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            if (this.isDone()) {
                throw new NoSuchElementException("roundrect iterator out of bounds");
            }
            double[] ctrls = ctrlpts[this.index];
            int nc = 0;
            for (int i = 0; i < ctrls.length; i += 4) {
                coords[nc++] = this.x + ctrls[i + 0] * this.w + ctrls[i + 1] * this.aw;
                coords[nc++] = this.y + ctrls[i + 2] * this.h + ctrls[i + 3] * this.ah;
            }
            AffineTransform affineTransform = this.affine;
            if (affineTransform == null) break block2;
            affineTransform.transform(coords, 0, coords, 0, nc / 2);
        }
        return types[this.index];
    }

    static {
        Object object = new double[10][];
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.5};
        object[0] = dArray;
        dArray = new double[]{0.0, 0.0, 1.0, -0.5};
        object[1] = dArray;
        dArray = new double[]{0.0, 0.0, 1.0, -acv, 0.0, acv, 1.0, 0.0, 0.0, 0.5, 1.0, 0.0};
        object[2] = dArray;
        dArray = new double[]{1.0, -0.5, 1.0, 0.0};
        object[3] = dArray;
        dArray = new double[]{1.0, -acv, 1.0, 0.0, 1.0, 0.0, 1.0, -acv, 1.0, 0.0, 1.0, -0.5};
        object[4] = dArray;
        dArray = new double[]{1.0, 0.0, 0.0, 0.5};
        object[5] = dArray;
        dArray = new double[]{1.0, 0.0, 0.0, acv, 1.0, -acv, 0.0, 0.0, 1.0, -0.5, 0.0, 0.0};
        object[6] = dArray;
        dArray = new double[]{0.0, 0.5, 0.0, 0.0};
        object[7] = dArray;
        dArray = new double[]{0.0, acv, 0.0, 0.0, 0.0, 0.0, 0.0, acv, 0.0, 0.0, 0.0, 0.5};
        object[8] = dArray;
        object[9] = new double[0];
        ctrlpts = object;
        object = new int[10];
        object[0] = (double[])false;
        object[1] = (double[])true;
        object[2] = (double[])3;
        object[3] = (double[])true;
        object[4] = (double[])3;
        object[5] = (double[])true;
        object[6] = (double[])3;
        object[7] = (double[])true;
        object[8] = (double[])3;
        object[9] = (double[])4;
        types = (int[])object;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0013\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/mkui/geom/RoundRectIterator$Companion;", "", "()V", "a", "", "acv", "angle", "b", "c", "ctrlpts", "", "", "[[D", "cv", "types", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

