/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom.curve;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.PathIterator;
import org.mkui.geom.curve.MultiPath;
import org.mkui.geom.curve.ShapeMultiPath;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0013\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u0096\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\r\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0017"}, d2={"Lorg/mkui/geom/curve/ShapeMultiPathIterator;", "Lorg/mkui/geom/PathIterator;", "smp", "Lorg/mkui/geom/curve/ShapeMultiPath;", "at", "Lorg/mkui/geom/AffineTransform;", "(Lorg/mkui/geom/curve/ShapeMultiPath;Lorg/mkui/geom/AffineTransform;)V", "ai0", "", "ai1", "isDone", "", "()Z", "n", "windingRule", "getWindingRule", "()I", "currentSegment", "coords", "", "", "next", "", "mkui"})
public final class ShapeMultiPathIterator
implements PathIterator {
    private final int ai0;
    private final int ai1;
    @Nullable
    private final AffineTransform at;
    @NotNull
    private final ShapeMultiPath smp;
    private final int windingRule;
    private int n;

    public ShapeMultiPathIterator(@NotNull ShapeMultiPath smp, @Nullable AffineTransform at) {
        Intrinsics.checkNotNullParameter((Object)smp, (String)"smp");
        this.smp = smp;
        this.at = at;
        int[] bv = smp.getBasisVectors();
        this.ai0 = bv[0];
        this.ai1 = bv[1];
        this.windingRule = smp.getWindingRule();
    }

    @Override
    public int getWindingRule() {
        return this.windingRule;
    }

    @Override
    public boolean isDone() {
        return this.n >= this.smp.getNumPoints();
    }

    @Override
    public void next() {
        int n = this.n;
        this.n = n + 1;
    }

    @Override
    public int currentSegment(@NotNull float[] coords) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double[] p = this.smp.get(this.n);
            coords[0] = (float)p[this.ai0];
            coords[1] = (float)p[this.ai1];
            if (this.n > 0 && Intrinsics.areEqual((Object)p, (Object)this.smp.get(0))) {
                return 4;
            }
            AffineTransform affineTransform = this.at;
            if (affineTransform == null) break block1;
            affineTransform.transform(coords, 0, coords, 0, 1);
        }
        return this.smp.getType(this.n) == MultiPath.Companion.getMOVE_TO() ? 0 : 1;
    }

    @Override
    public int currentSegment(@NotNull double[] coords) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double[] p = this.smp.get(this.n);
            coords[0] = p[this.ai0];
            coords[1] = p[this.ai1];
            if (this.n > 0 && Intrinsics.areEqual((Object)p, (Object)this.smp.get(0))) {
                return 4;
            }
            AffineTransform affineTransform = this.at;
            if (affineTransform == null) break block1;
            affineTransform.transform(coords, 0, coords, 0, 1);
        }
        return this.smp.getType(this.n) == MultiPath.Companion.getMOVE_TO() ? 0 : 1;
    }
}

