/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.colormap;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.interval.PropertyClosedInterval;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorFactory;
import org.mkui.color.MkColorKt;
import org.mkui.colormap.MutableColorMap;
import org.mkui.colormap.SimpleColorMap;
import org.mkui.palette.CustomPalette;
import org.mkui.palette.MutablePalette;
import org.mkui.palette.PaletteFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0006\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nJ\u001a\u0010\u000b\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ\u001a\u0010\u000f\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rJ$\u0010\u0010\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0014\u0010\u0015\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nJ\u0014\u0010\u0016\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nJ\u0016\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0016\u0010\u001f\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0014\u0010 \u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nJ\u0006\u0010!\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/mkui/colormap/ColorMapFactory;", "", "paletteFactory", "Lorg/mkui/palette/PaletteFactory;", "(Lorg/mkui/palette/PaletteFactory;)V", "colorFactory", "Lorg/mkui/color/MkColorFactory;", "createAlphabeticalColorMap", "Lorg/mkui/colormap/MutableColorMap;", "values", "", "createAutoContinuousColorMap", "mininum", "", "maximum", "createAutoSegmentedColorMap", "createCategoricalColorMap", "cyclic", "", "palette", "Lorg/mkui/palette/MutablePalette;", "createCategoricalDivergingColorMap", "createCategoricalSequentialColorMap", "createColorMap", "interval", "Lcom/macrofocus/common/interval/MutableInterval;", "createContinuousColorMap", "min", "", "max", "createContinuousDivergingColorMap", "createContinuousSequentialColorMap", "createQualitativeColorMap", "getPaletteFactory", "mkui"})
@StabilityInferred(parameters=0)
public final class ColorMapFactory {
    @NotNull
    private final MkColorFactory colorFactory;
    @NotNull
    private final PaletteFactory paletteFactory;
    public static final int $stable = PaletteFactory.$stable | MkColorFactory.$stable;

    public ColorMapFactory(@NotNull PaletteFactory paletteFactory) {
        Intrinsics.checkNotNullParameter((Object)paletteFactory, (String)"paletteFactory");
        this.colorFactory = MkColorFactory.Companion.getInstance();
        this.paletteFactory = paletteFactory;
    }

    @NotNull
    public final PaletteFactory getPaletteFactory() {
        return this.paletteFactory;
    }

    @NotNull
    public final MutableColorMap createContinuousSequentialColorMap(double min, double max) {
        return this.createContinuousColorMap(min, max, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createContinuousDivergingColorMap(double min, double max) {
        return this.createContinuousColorMap(min, max, this.paletteFactory.createDefaultDivergingPalette());
    }

    @NotNull
    public final MutableColorMap createCategoricalSequentialColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, false, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createCategoricalDivergingColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, false, this.paletteFactory.createDefaultDivergingPalette());
    }

    @NotNull
    public final MutableColorMap createQualitativeColorMap(@Nullable Set<?> values) {
        return this.createCategoricalColorMap(values, true, this.paletteFactory.createDefaultQualititativePalette());
    }

    @NotNull
    public final MutableColorMap createContinuousColorMap(double min, double max, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap((MutableInterval)new PropertyClosedInterval(min, max - min), palette);
    }

    @NotNull
    public final MutableColorMap createCategoricalColorMap(@Nullable Set<?> values, boolean cyclic, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap(values, cyclic, palette);
    }

    @NotNull
    public final MutableColorMap createColorMap(@NotNull MutableInterval interval, @NotNull MutablePalette palette) {
        Intrinsics.checkNotNullParameter((Object)interval, (String)"interval");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        return new SimpleColorMap(interval, palette);
    }

    @NotNull
    public final MutableColorMap createAlphabeticalColorMap(@Nullable Set<?> values) {
        SortedSet set = new SortedSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE), null, 2, null);
        set.add((Object)"A");
        set.add((Object)"B");
        set.add((Object)"C");
        return new SimpleColorMap((Set)set, false, this.paletteFactory.createDefaultSequentialPalette());
    }

    @NotNull
    public final MutableColorMap createAutoContinuousColorMap(@Nullable Number mininum, @Nullable Number maximum) {
        MutableColorMap mutableColorMap;
        if (mininum != null && maximum != null) {
            if (mininum.doubleValue() < 0.0 && maximum.doubleValue() > 0.0) {
                double diffMin = 0.0 - mininum.doubleValue();
                double diffMax = maximum.doubleValue();
                double maxDiff = Math.max(diffMin, diffMax);
                mutableColorMap = this.createContinuousDivergingColorMap(0.0 - maxDiff, maxDiff);
            } else {
                mutableColorMap = this.createContinuousSequentialColorMap(mininum.doubleValue(), maximum.doubleValue());
            }
        } else {
            mutableColorMap = this.createContinuousSequentialColorMap(0.0, 0.0);
        }
        return mutableColorMap;
    }

    @NotNull
    public final MutableColorMap createAutoSegmentedColorMap(@Nullable Number mininum, @Nullable Number maximum) {
        MutableColorMap mutableColorMap;
        if (mininum != null && maximum != null) {
            if (mininum.doubleValue() < 0.0 && maximum.doubleValue() > 0.0) {
                double diffMin = 0.0 - mininum.doubleValue();
                double diffMax = maximum.doubleValue();
                double maxDiff = Math.max(diffMin, diffMax);
                double min = 0.0 - maxDiff;
                double minF = (min - mininum.doubleValue()) / (maximum.doubleValue() - mininum.doubleValue());
                double maxF = (maxDiff - mininum.doubleValue()) / (maximum.doubleValue() - mininum.doubleValue());
                double meanF = (maxF + minF) / 2.0;
                CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(minF, MkColorKt.colorOf(255, 0, 0)), new CustomPalette.Entry(meanF, this.colorFactory.getWhite()), new CustomPalette.Entry(maxF, MkColorKt.colorOf(0, 128, 0))};
                mutableColorMap = this.createContinuousColorMap(mininum.doubleValue(), maximum.doubleValue(), new CustomPalette(entryArray));
            } else {
                CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(0.0, MkColorKt.colorOf(255, 0, 0)), new CustomPalette.Entry(0.5, this.colorFactory.getWhite()), new CustomPalette.Entry(1.0, MkColorKt.colorOf(0, 128, 0))};
                mutableColorMap = this.createContinuousColorMap(mininum.doubleValue(), maximum.doubleValue(), new CustomPalette(entryArray));
            }
        } else {
            CustomPalette.Entry[] entryArray = new CustomPalette.Entry[]{new CustomPalette.Entry(0.0, this.colorFactory.getWhite())};
            mutableColorMap = this.createContinuousColorMap(0.0, 0.0, new CustomPalette(entryArray));
        }
        return mutableColorMap;
    }
}

