/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.component.input;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.helper.WeakActionListeners;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.component.CPComponent;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u001f\b\u0016\u0012\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00050\u0003\u00a2\u0006\u0002\u0010\u0006B\u0005\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\u0002\u001a\u0010\u0012\f\u0012\n\u0018\u00010\u0004j\u0004\u0018\u0001`\u00050\u0003R\u001a\u0010\b\u001a\u00020\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lorg/mkui/component/input/CPColorPicker;", "Lorg/mkui/component/CPComponent;", "property", "Lcom/macrofocus/common/properties/MutableProperty;", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "(Lcom/macrofocus/common/properties/MutableProperty;)V", "()V", "nativeComponent", "Lorg/mkui/component/input/CPColorPicker$ColorChooserButton;", "getNativeComponent", "()Lorg/mkui/component/input/CPColorPicker$ColorChooserButton;", "setNativeComponent", "(Lorg/mkui/component/input/CPColorPicker$ColorChooserButton;)V", "setProperty", "", "ColorChangedListener", "ColorChooserButton", "mkui"})
@StabilityInferred(parameters=0)
public final class CPColorPicker
implements CPComponent {
    @NotNull
    private ColorChooserButton nativeComponent;
    public static final int $stable = 8;

    public CPColorPicker() {
        this.nativeComponent = new ColorChooserButton();
    }

    @Override
    @NotNull
    public ColorChooserButton getNativeComponent() {
        return this.nativeComponent;
    }

    public void setNativeComponent(@NotNull ColorChooserButton colorChooserButton) {
        Intrinsics.checkNotNullParameter((Object)colorChooserButton, (String)"<set-?>");
        this.nativeComponent = colorChooserButton;
    }

    public CPColorPicker(@NotNull MutableProperty<Color> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this();
        this.setProperty(property);
    }

    public /* synthetic */ CPColorPicker(MutableProperty mutableProperty, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            mutableProperty = (MutableProperty)SimpleProperty.Companion.newInstance(null);
        }
        this((MutableProperty<Color>)mutableProperty);
    }

    public final void setProperty(@NotNull MutableProperty<Color> property) {
        Intrinsics.checkNotNullParameter(property, (String)"property");
        this.getNativeComponent().setSelectedColor(property.getValue() != null ? (Color)property.getValue() : null);
        this.getNativeComponent().addColorChangedListener(new ColorChangedListener(property){
            final /* synthetic */ MutableProperty<Color> $property;
            {
                this.$property = $property;
            }

            public void colorChanged(@Nullable Color newColor) {
                Color color = newColor;
                this.$property.setValue((Object)(color != null ? MkColorKt.colorOf(color) : null));
            }
        });
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00a8\u0006\u0006"}, d2={"Lorg/mkui/component/input/CPColorPicker$ColorChangedListener;", "", "colorChanged", "", "newColor", "Ljava/awt/Color;", "mkui"})
    public static interface ColorChangedListener {
        public void colorChanged(@Nullable Color var1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0011\b\u0016\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000bJ \u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018J\u0018\u0010\u0010\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\r\u001a\u0004\u0018\u00010\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0005\u00a8\u0006\u001c"}, d2={"Lorg/mkui/component/input/CPColorPicker$ColorChooserButton;", "Ljavax/swing/JButton;", "()V", "c", "Ljava/awt/Color;", "(Ljava/awt/Color;)V", "actionListeners", "Lcom/macrofocus/common/helper/WeakActionListeners;", "current", "listeners", "", "Lorg/mkui/component/input/CPColorPicker$ColorChangedListener;", "newColor", "selectedColor", "getSelectedColor", "()Ljava/awt/Color;", "setSelectedColor", "addColorChangedListener", "", "toAdd", "createIcon", "Ljavax/swing/ImageIcon;", "main", "width", "", "height", "notify", "", "mkui"})
    @StabilityInferred(parameters=0)
    public static final class ColorChooserButton
    extends JButton {
        @Nullable
        private Color current;
        @NotNull
        private final WeakActionListeners actionListeners = new WeakActionListeners();
        @NotNull
        private final List<ColorChangedListener> listeners = new ArrayList();
        public static final int $stable = 8;

        public ColorChooserButton() {
            this.addActionListener(this.actionListeners.create(new ActionListener(){

                @Override
                public void actionPerformed(@NotNull ActionEvent arg0) {
                    Intrinsics.checkNotNullParameter((Object)arg0, (String)"arg0");
                    Color newColor = JColorChooser.showDialog(null, "Choose a color", current);
                    this.setSelectedColor(newColor);
                }
            }, (Object)this));
        }

        public ColorChooserButton(@Nullable Color c2) {
            this();
            this.setSelectedColor(c2);
        }

        @Nullable
        public final Color getSelectedColor() {
            return this.current;
        }

        public final void setSelectedColor(@Nullable Color newColor) {
            this.setSelectedColor(newColor, true);
        }

        public final void setSelectedColor(@Nullable Color newColor, boolean notify) {
            if (newColor == null) {
                return;
            }
            this.current = newColor;
            this.setIcon(this.createIcon(this.current, 16, 16));
            this.repaint();
            if (notify) {
                for (ColorChangedListener l : this.listeners) {
                    l.colorChanged(newColor);
                }
            }
        }

        public final void addColorChangedListener(@NotNull ColorChangedListener toAdd) {
            Intrinsics.checkNotNullParameter((Object)toAdd, (String)"toAdd");
            this.listeners.add(toAdd);
        }

        @NotNull
        public final ImageIcon createIcon(@Nullable Color main, int width, int height) {
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(main);
            graphics.fillRect(0, 0, width, height);
            graphics.setXORMode(Color.DARK_GRAY);
            graphics.drawRect(0, 0, width - 1, height - 1);
            image.flush();
            ImageIcon icon = new ImageIcon(image);
            return icon;
        }
    }
}

