/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Curve;
import org.mkui.geom.Order0;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u001b\b\u0007\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ&\u0010)\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000bR\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000bR\u0011\u0010\u001b\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010 \u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001dR\u001a\u0010\"\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001d\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001d\"\u0004\b(\u0010%\u00a8\u0006+"}, d2={"Lorg/mkui/geom/CurveLink;", "", "curve", "Lorg/mkui/geom/Curve;", "ystart", "", "yend", "etag", "", "(Lorg/mkui/geom/Curve;DDI)V", "getCurve", "()Lorg/mkui/geom/Curve;", "edgeTag", "getEdgeTag", "()I", "isEmpty", "", "()Z", "moveto", "getMoveto", "next", "getNext", "()Lorg/mkui/geom/CurveLink;", "setNext", "(Lorg/mkui/geom/CurveLink;)V", "subCurve", "getSubCurve", "x", "getX", "()D", "xBot", "getXBot", "xTop", "getXTop", "yBot", "getYBot", "setYBot", "(D)V", "yTop", "getYTop", "setYTop", "absorb", "link", "mkui"})
@StabilityInferred(parameters=0)
public final class CurveLink {
    @NotNull
    private final Curve curve;
    private final int edgeTag;
    private double yTop;
    private double yBot;
    @Nullable
    private CurveLink next;
    public static final int $stable = 8;

    public CurveLink(@NotNull Curve curve, double ystart, double yend, int etag) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        this.curve = curve;
        this.yTop = ystart;
        this.yBot = yend;
        this.edgeTag = etag;
        if (this.yTop < curve.getYTop() || this.yBot > curve.getYBot()) {
            throw new UnsupportedOperationException("bad curvelink [" + this.yTop + "=>" + this.yBot + "] for " + curve);
        }
    }

    @NotNull
    public final Curve getCurve() {
        return this.curve;
    }

    public final int getEdgeTag() {
        return this.edgeTag;
    }

    public final double getYTop() {
        return this.yTop;
    }

    public final void setYTop(double d) {
        this.yTop = d;
    }

    public final double getYBot() {
        return this.yBot;
    }

    public final void setYBot(double d) {
        this.yBot = d;
    }

    @Nullable
    public final CurveLink getNext() {
        return this.next;
    }

    public final void setNext(@Nullable CurveLink curveLink) {
        this.next = curveLink;
    }

    public final boolean absorb(@NotNull CurveLink link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        return this.absorb(link.curve, link.yTop, link.yBot, link.edgeTag);
    }

    public final boolean absorb(@NotNull Curve curve, double ystart, double yend, int etag) {
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        if (this.curve != curve || this.edgeTag != etag || this.yBot < ystart || this.yTop > yend) {
            return false;
        }
        if (ystart < curve.getYTop() || yend > curve.getYBot()) {
            throw new UnsupportedOperationException("bad curvelink [" + ystart + "=>" + yend + "] for " + curve);
        }
        this.yTop = Math.min(this.yTop, ystart);
        this.yBot = Math.max(this.yBot, yend);
        return true;
    }

    public final boolean isEmpty() {
        return this.yTop == this.yBot;
    }

    @NotNull
    public final Curve getSubCurve() {
        return this.yTop == this.curve.getYTop() && this.yBot == this.curve.getYBot() ? this.curve.getWithDirection(this.edgeTag) : this.curve.getSubCurve(this.yTop, this.yBot, this.edgeTag);
    }

    @NotNull
    public final Curve getMoveto() {
        return new Order0(this.getXTop(), this.yTop);
    }

    public final double getXTop() {
        return this.curve.XforY(this.yTop);
    }

    public final double getXBot() {
        return this.curve.XforY(this.yBot);
    }

    public final double getX() {
        return this.curve.XforY(this.yTop);
    }
}

