/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Curve;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b)\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0013\n\u0002\b\t\b\u0000\u0018\u0000 E2\u00020\u0001:\u0001EB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010-\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0010\u0010/\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0016J\u0010\u00101\u001a\u00020\u00032\u0006\u0010.\u001a\u00020\u0003H\u0016J\u0010\u00102\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u0003H\u0016J\b\u00103\u001a\u000204H\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00106\u001a\u00020\nH\u0016J\u0018\u00107\u001a\u00020\u00032\u0006\u00100\u001a\u00020\u00032\u0006\u00106\u001a\u00020\nH\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010:\u001a\u000209H\u0016J\u0010\u0010;\u001a\u00020\n2\u0006\u0010<\u001a\u00020=H\u0016J \u0010>\u001a\u00020\u00012\u0006\u0010?\u001a\u00020\u00032\u0006\u0010@\u001a\u00020\u00032\u0006\u0010A\u001a\u00020\nH\u0016J\u0018\u0010B\u001a\u00020\u00032\u0006\u0010C\u001a\u00020\u00032\u0006\u0010D\u001a\u00020\u0003H\u0016R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u00018VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u0014\u0010\u0007\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000eR\u0014\u0010\u0019\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u000eR\u0014\u0010\u001b\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u000eR\u0014\u0010\u001d\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u000eR\u0014\u0010\u001f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000eR\u000e\u0010!\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u000eR\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0014\u0010&\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u000eR\u0014\u0010(\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u000eR\u000e\u0010*\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lorg/mkui/geom/Order2;", "Lorg/mkui/geom/Curve;", "x0", "", "y0", "cx0", "cy0", "x1", "y1", "direction", "", "(DDDDDDI)V", "cX0", "getCX0", "()D", "cY0", "getCY0", "order", "getOrder", "()I", "reversedCurve", "getReversedCurve", "()Lorg/mkui/geom/Curve;", "getX0", "getX1", "xBot", "getXBot", "xMax", "getXMax", "xMin", "getXMin", "xTop", "getXTop", "xcoeff0", "xcoeff1", "xcoeff2", "getY0", "getY1", "yBot", "getYBot", "yTop", "getYTop", "ycoeff0", "ycoeff1", "ycoeff2", "TforY", "y", "XforT", "t", "XforY", "YforT", "controlPointString", "", "dXforT", "deriv", "dYforT", "enlarge", "Lorg/mkui/geom/Rectangle2D;", "r", "getSegment", "coords", "", "getSubCurve", "ystart", "yend", "dir", "nextVertical", "t0", "t1", "Companion", "mkui"})
@StabilityInferred(parameters=1)
public final class Order2
extends Curve {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double xTop;
    private final double yTop;
    private final double cX0;
    private final double cY0;
    private final double xBot;
    private final double yBot;
    private final double xMin;
    private final double xMax;
    private final double xcoeff0;
    private final double xcoeff1;
    private final double xcoeff2;
    private final double ycoeff0;
    private final double ycoeff1;
    private final double ycoeff2;
    public static final int $stable;

    public Order2(double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
        super(direction);
        double cy02 = cy0;
        if (cy02 < y0) {
            cy02 = y0;
        } else if (cy02 > y1) {
            cy02 = y1;
        }
        this.xTop = x0;
        this.yTop = y0;
        this.cX0 = cx0;
        this.cY0 = cy02;
        this.xBot = x1;
        this.yBot = y1;
        this.xMin = Math.min(Math.min(x0, x1), cx0);
        this.xMax = Math.max(Math.max(x0, x1), cx0);
        this.xcoeff0 = x0;
        this.xcoeff1 = cx0 + cx0 - x0 - x0;
        this.xcoeff2 = x0 - cx0 - cx0 + x1;
        this.ycoeff0 = y0;
        this.ycoeff1 = cy02 + cy02 - y0 - y0;
        this.ycoeff2 = y0 - cy02 - cy02 + y1;
    }

    @Override
    public double getXTop() {
        return this.xTop;
    }

    @Override
    public double getYTop() {
        return this.yTop;
    }

    public final double getCX0() {
        return this.cX0;
    }

    public final double getCY0() {
        return this.cY0;
    }

    @Override
    public double getXBot() {
        return this.xBot;
    }

    @Override
    public double getYBot() {
        return this.yBot;
    }

    @Override
    public double getXMin() {
        return this.xMin;
    }

    @Override
    public double getXMax() {
        return this.xMax;
    }

    @Override
    @NotNull
    public Curve getReversedCurve() {
        return new Order2(this.getXTop(), this.getYTop(), this.cX0, this.cY0, this.getXBot(), this.getYBot(), -this.getDirection());
    }

    @Override
    @NotNull
    public String controlPointString() {
        return "(" + Curve.Companion.round(this.cX0) + ", " + Curve.Companion.round(this.cY0) + "), ";
    }

    @Override
    public int getOrder() {
        return 2;
    }

    @Override
    public double getX0() {
        return this.getDirection() == 1 ? this.getXTop() : this.getXBot();
    }

    @Override
    public double getY0() {
        return this.getDirection() == 1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double getX1() {
        return this.getDirection() == -1 ? this.getXTop() : this.getXBot();
    }

    @Override
    public double getY1() {
        return this.getDirection() == -1 ? this.getYTop() : this.getYBot();
    }

    @Override
    public double YforT(double t) {
        return (this.ycoeff2 * t + this.ycoeff1) * t + this.ycoeff0;
    }

    @Override
    public double dXforT(double t, int deriv) {
        return switch (deriv) {
            case 0 -> (this.xcoeff2 * t + this.xcoeff1) * t + this.xcoeff0;
            case 1 -> (double)2 * this.xcoeff2 * t + this.xcoeff1;
            case 2 -> (double)2 * this.xcoeff2;
            default -> 0.0;
        };
    }

    @Override
    public double dYforT(double t, int deriv) {
        return switch (deriv) {
            case 0 -> (this.ycoeff2 * t + this.ycoeff1) * t + this.ycoeff0;
            case 1 -> (double)2 * this.ycoeff2 * t + this.ycoeff1;
            case 2 -> (double)2 * this.ycoeff2;
            default -> 0.0;
        };
    }

    @Override
    public double XforY(double y) {
        if (y <= this.getYTop()) {
            return this.getXTop();
        }
        return y >= this.getYBot() ? this.getXBot() : this.XforT(this.TforY(y));
    }

    @Override
    public double TforY(double y) {
        if (y <= this.getYTop()) {
            return 0.0;
        }
        return y >= this.getYBot() ? 1.0 : Companion.TforY(y, this.ycoeff0, this.ycoeff1, this.ycoeff2);
    }

    @Override
    @NotNull
    public Rectangle2D enlarge(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        Rectangle2D r2 = r;
        r2 = r2.add(this.getXTop(), this.getYTop());
        double t = -this.xcoeff1 / ((double)2 * this.xcoeff2);
        if (t > 0.0 && t < 1.0) {
            r2 = r2.add(this.XforT(t), this.YforT(t));
        }
        return r2.add(this.getXBot(), this.getYBot());
    }

    @Override
    public double XforT(double t) {
        return (this.xcoeff2 * t + this.xcoeff1) * t + this.xcoeff0;
    }

    @Override
    public double nextVertical(double t0, double t1) {
        double t = -this.xcoeff1 / ((double)2 * this.xcoeff2);
        return t > t0 && t < t1 ? t : t1;
    }

    @Override
    @NotNull
    public Curve getSubCurve(double ystart, double yend, int dir) {
        int n;
        double d;
        double t0 = 0.0;
        if (ystart <= this.getYTop()) {
            if (yend >= this.getYBot()) {
                return this.getWithDirection(dir);
            }
            d = 0.0;
        } else {
            d = Companion.TforY(ystart, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        }
        t0 = d;
        double t1 = 0.0;
        t1 = yend >= this.getYBot() ? 1.0 : Companion.TforY(yend, this.ycoeff0, this.ycoeff1, this.ycoeff2);
        double[] eqn = new double[10];
        eqn[0] = this.getXTop();
        eqn[1] = this.getYTop();
        eqn[2] = this.cX0;
        eqn[3] = this.cY0;
        eqn[4] = this.getXBot();
        eqn[5] = this.getYBot();
        if (t1 < 1.0) {
            Companion.split(eqn, 0, t1);
        }
        int i = 0;
        if (t0 <= 0.0) {
            n = 0;
        } else {
            Companion.split(eqn, 0, t0 / t1);
            n = 4;
        }
        i = n;
        return new Order2(eqn[i + 0], ystart, eqn[i + 2], eqn[i + 3], eqn[i + 4], yend, dir);
    }

    @Override
    public int getSegment(@NotNull double[] coords) {
        Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
        coords[0] = this.cX0;
        coords[1] = this.cY0;
        if (this.getDirection() == 1) {
            coords[2] = this.getXBot();
            coords[3] = this.getYBot();
        } else {
            coords[2] = this.getXTop();
            coords[3] = this.getYTop();
        }
        return 2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0013\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004JL\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J&\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bJT\u0010\u001c\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015J\u001e\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u00152\u0006\u0010!\u001a\u00020\u0004\u00a8\u0006\""}, d2={"Lorg/mkui/geom/Order2$Companion;", "", "()V", "TforY", "", "y", "ycoeff0", "ycoeff1", "ycoeff2", "addInstance", "", "curves", "", "Lorg/mkui/geom/Curve;", "x0", "y0", "cx0", "cy0", "x1", "y1", "direction", "", "getHorizontalParams", "c0", "cp", "c1", "ret", "", "insert", "tmp", "split", "coords", "pos", "t", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public final void insert(@NotNull List<Curve> curves, @NotNull double[] tmp, double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            Intrinsics.checkNotNullParameter((Object)tmp, (String)"tmp");
            int numparams = this.getHorizontalParams(y0, cy0, y1, tmp);
            if (numparams == 0) {
                this.addInstance(curves, x0, y0, cx0, cy0, x1, y1, direction);
                return;
            }
            double t = tmp[0];
            tmp[0] = x0;
            tmp[1] = y0;
            tmp[2] = cx0;
            tmp[3] = cy0;
            tmp[4] = x1;
            tmp[5] = y1;
            this.split(tmp, 0, t);
            int i0 = direction == 1 ? 0 : 4;
            this.addInstance(curves, tmp[i0], tmp[i0 + 1], tmp[i0 + 2], tmp[i0 + 3], tmp[i0 + 4], tmp[i0 + 5], direction);
            int i1 = 4 - i0;
            this.addInstance(curves, tmp[i1], tmp[i1 + 1], tmp[i1 + 2], tmp[i1 + 3], tmp[i1 + 4], tmp[i1 + 5], direction);
        }

        public final void addInstance(@NotNull List<Curve> curves, double x0, double y0, double cx0, double cy0, double x1, double y1, int direction) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            if (y0 > y1) {
                curves.add(new Order2(x1, y1, cx0, cy0, x0, y0, -direction));
            } else if (y1 > y0) {
                curves.add(new Order2(x0, y0, cx0, cy0, x1, y1, direction));
            }
        }

        public final int getHorizontalParams(double c0, double cp, double c1, @NotNull double[] ret) {
            Intrinsics.checkNotNullParameter((Object)ret, (String)"ret");
            double c02 = c0;
            double c12 = c1;
            if (c02 <= cp && cp <= c12) {
                return 0;
            }
            double denom = (c02 -= cp) + (c12 -= cp);
            if (denom == 0.0) {
                return 0;
            }
            double t = c02 / denom;
            if (t <= 0.0 || t >= 1.0) {
                return 0;
            }
            ret[0] = t;
            return 1;
        }

        public final void split(@NotNull double[] coords, int pos, double t) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double x1 = 0.0;
            coords[pos + 8] = x1 = coords[pos + 4];
            double y1 = 0.0;
            coords[pos + 9] = y1 = coords[pos + 5];
            double cx = coords[pos + 2];
            double cy = coords[pos + 3];
            x1 = cx + (x1 - cx) * t;
            y1 = cy + (y1 - cy) * t;
            double x0 = coords[pos + 0];
            double y0 = coords[pos + 1];
            x0 += (cx - x0) * t;
            y0 += (cy - y0) * t;
            cx = x0 + (x1 - x0) * t;
            cy = y0 + (y1 - y0) * t;
            coords[pos + 2] = x0;
            coords[pos + 3] = y0;
            coords[pos + 4] = cx;
            coords[pos + 5] = cy;
            coords[pos + 6] = x1;
            coords[pos + 7] = y1;
        }

        public final double TforY(double y, double ycoeff0, double ycoeff1, double ycoeff2) {
            double y1;
            double y0;
            double ycoeff02 = ycoeff0;
            ycoeff02 -= y;
            if (ycoeff2 == 0.0) {
                double root = -ycoeff02 / ycoeff1;
                if (root >= 0.0 && root <= 1.0) {
                    return root;
                }
            } else {
                double d = ycoeff1 * ycoeff1 - 4.0 * ycoeff2 * ycoeff02;
                if (d >= 0.0) {
                    double q;
                    double root;
                    d = Math.sqrt(d);
                    if (ycoeff1 < 0.0) {
                        d = -d;
                    }
                    if ((root = (q = (ycoeff1 + d) / -2.0) / ycoeff2) >= 0.0 && root <= 1.0) {
                        return root;
                    }
                    if (!(q == 0.0) && (root = ycoeff02 / q) >= 0.0 && root <= 1.0) {
                        return root;
                    }
                }
            }
            return 0.0 < ((y0 = ycoeff02) + (y1 = ycoeff02 + ycoeff1 + ycoeff2)) / (double)2 ? 0.0 : 1.0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

