/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.SwingTextMetrics;
import org.mkui.graphics.GraphicsContext2D;
import org.mkui.text.CPTextMetrics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b$\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J8\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u0010\u0018\u001a\u00020\u000eH\u0016JH\u0010\u0019\u001a\u00020\u000e2\n\u0010\u001a\u001a\u00060\u0006j\u0002`\u00072\n\u0010\u001b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020!H\u0016J\b\u0010\u0005\u001a\u00020\u000eH\u0016J(\u0010\"\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J6\u0010#\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0011J \u0010&\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u000e\u0010)\u001a\n\u0018\u00010*j\u0004\u0018\u0001`+J\u0010\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020(H\u0016J\u0018\u0010.\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J\u0018\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0011H\u0016J(\u00102\u001a\u00020\u000e2\u0006\u00103\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u0011H\u0016J(\u00105\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J\b\u00106\u001a\u00020\u000eH\u0016J\u0010\u00107\u001a\u00020\u000e2\u0006\u00108\u001a\u00020\u0011H\u0016J\b\u00109\u001a\u00020\u000eH\u0016J\u0018\u0010:\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016J\u0014\u0010;\u001a\u00020\u000e2\n\u0010<\u001a\u00060\u0006j\u0002`\u0007H\u0016J\u0014\u0010=\u001a\u00020\u000e2\n\u0010>\u001a\u00060*j\u0002`+H\u0016J\u0010\u0010?\u001a\u00020\u000e2\u0006\u0010@\u001a\u00020\u0011H\u0016J\u0010\u0010A\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u0011H\u0016J\u0014\u0010C\u001a\u00020\u000e2\n\u0010<\u001a\u00060\u0006j\u0002`\u0007H\u0016J8\u0010D\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u0011H\u0016J\b\u0010\f\u001a\u00020\u000eH\u0016J(\u0010K\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010L\u001a\u00020\u00112\u0006\u0010M\u001a\u00020\u0011H\u0016J(\u0010N\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0011H\u0016J8\u0010O\u001a\u00020\u000e2\u0006\u0010E\u001a\u00020\u00112\u0006\u0010F\u001a\u00020\u00112\u0006\u0010G\u001a\u00020\u00112\u0006\u0010H\u001a\u00020\u00112\u0006\u0010I\u001a\u00020\u00112\u0006\u0010J\u001a\u00020\u0011H\u0016J\u0018\u0010P\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u00112\u0006\u0010\u001d\u001a\u00020\u0011H\u0016R\u0016\u0010\u0005\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n\u0018\u00010\u0006j\u0004\u0018\u0001`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006Q"}, d2={"Lorg/mkui/graphics/CPGraphicsContext2D;", "Lorg/mkui/graphics/GraphicsContext2D;", "gc", "Ljava/awt/Graphics2D;", "(Ljava/awt/Graphics2D;)V", "fill", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "path", "Ljava/awt/geom/GeneralPath;", "stack", "Ljava/util/Stack;", "stroke", "beginPath", "", "bezierCurveTo", "xc1", "", "yc1", "xc2", "yc2", "x1", "y1", "clip", "closePath", "drawGradient", "color1", "color2", "x", "y", "w", "h", "isVertical", "", "fillRect", "fillRoundRect", "arcWidth", "arcHeight", "fillText", "text", "", "getFont", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "getTextMetrics", "Lorg/mkui/text/CPTextMetrics;", "lineTo", "moveTo", "x0", "y0", "quadraticCurveTo", "xc", "yc", "rect", "restore", "rotate", "degrees", "save", "scale", "setFill", "p", "setFont", "f", "setGlobalAlpha", "alpha", "setLineWidth", "lw", "setStroke", "setTransform", "mxx", "myx", "mxy", "myy", "mxt", "myt", "strokeLine", "x2", "y2", "strokeRect", "transform", "translate", "mkui"})
@StabilityInferred(parameters=0)
public final class CPGraphicsContext2D
implements GraphicsContext2D {
    @NotNull
    private Graphics2D gc;
    @NotNull
    private final Stack<Graphics2D> stack;
    @Nullable
    private GeneralPath path;
    @Nullable
    private Color fill;
    @Nullable
    private Color stroke;
    public static final int $stable = 8;

    public CPGraphicsContext2D(@NotNull Graphics2D gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.gc = gc;
        this.stack = new Stack();
    }

    @Override
    @NotNull
    public CPTextMetrics getTextMetrics(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return new SwingTextMetrics(this.gc, text);
    }

    @Override
    public void drawGradient(@NotNull Color color1, @NotNull Color color2, double x, double y, double w, double h, boolean isVertical) {
        Intrinsics.checkNotNullParameter((Object)color1, (String)"color1");
        Intrinsics.checkNotNullParameter((Object)color2, (String)"color2");
        if (isVertical) {
            GradientPaint gradient = new GradientPaint(0.0f, (float)y, color1, 0.0f, (float)(y + h), color2);
            this.gc.setPaint(gradient);
            this.gc.fill(new Rectangle2D.Double(x, y, w, h));
        } else {
            GradientPaint gradient = new GradientPaint((float)x, 0.0f, color1, (float)(x + w), 0.0f, color2);
            this.gc.setPaint(gradient);
            this.gc.fill(new Rectangle2D.Double(x, y, w, h));
        }
    }

    @Override
    public void save() {
        this.stack.push(this.gc);
        Graphics graphics = this.gc.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        this.gc = (Graphics2D)graphics;
    }

    @Override
    public void restore() {
        this.gc.dispose();
        Graphics2D graphics2D = this.stack.pop();
        Intrinsics.checkNotNullExpressionValue((Object)graphics2D, (String)"pop(...)");
        this.gc = graphics2D;
    }

    @Override
    public void translate(double x, double y) {
        this.gc.translate(x, y);
    }

    @Override
    public void scale(double x, double y) {
        this.gc.scale(x, y);
    }

    @Override
    public void rotate(double degrees) {
        this.gc.rotate(degrees);
    }

    @Override
    public void transform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.gc.transform(new AffineTransform(mxx, myx, mxy, myy, mxt, myt));
    }

    @Override
    public void setTransform(double mxx, double myx, double mxy, double myy, double mxt, double myt) {
        this.gc.setTransform(new AffineTransform(mxx, myx, mxy, myy, mxt, myt));
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.gc.setComposite(AlphaComposite.getInstance(3, (float)alpha));
    }

    @Override
    public void setFill(@NotNull Color p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.fill = p;
        this.gc.setColor(p);
    }

    @Override
    public void setStroke(@NotNull Color p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.stroke = p;
        this.gc.setColor(p);
    }

    @Override
    public void setLineWidth(double lw) {
        this.gc.setStroke(new BasicStroke((float)lw));
    }

    @Nullable
    public final Font getFont() {
        return this.gc.getFont();
    }

    @Override
    public void setFont(@NotNull Font f) {
        Intrinsics.checkNotNullParameter((Object)f, (String)"f");
        this.gc.setFont(f);
    }

    @Override
    public void fillText(@NotNull String text, double x, double y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.gc.drawString(text, (float)x, (float)y);
    }

    @Override
    public void beginPath() {
        this.path = new GeneralPath();
    }

    @Override
    public void moveTo(double x0, double y0) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.moveTo(x0, y0);
    }

    @Override
    public void lineTo(double x1, double y1) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.lineTo(x1, y1);
    }

    @Override
    public void quadraticCurveTo(double xc, double yc, double x1, double y1) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.quadTo(xc, yc, x1, y1);
    }

    @Override
    public void bezierCurveTo(double xc1, double yc1, double xc2, double yc2, double x1, double y1) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.curveTo(xc1, yc1, xc2, yc2, x1, y1);
    }

    @Override
    public void rect(double x, double y, double w, double h) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.moveTo(x, y);
        GeneralPath generalPath2 = this.path;
        Intrinsics.checkNotNull((Object)generalPath2);
        generalPath2.lineTo(x + w, y);
        GeneralPath generalPath3 = this.path;
        Intrinsics.checkNotNull((Object)generalPath3);
        generalPath3.lineTo(x + w, y + h);
        GeneralPath generalPath4 = this.path;
        Intrinsics.checkNotNull((Object)generalPath4);
        generalPath4.lineTo(x, y + h);
        GeneralPath generalPath5 = this.path;
        Intrinsics.checkNotNull((Object)generalPath5);
        generalPath5.lineTo(x, y);
    }

    @Override
    public void closePath() {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.closePath();
    }

    @Override
    public void fill() {
        this.gc.fill(this.path);
    }

    @Override
    public void stroke() {
        this.gc.draw(this.path);
    }

    @Override
    public void clip() {
        this.gc.clip(this.path);
    }

    @Override
    public void fillRect(double x, double y, double w, double h) {
        this.gc.fill(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public void strokeRect(double x, double y, double w, double h) {
        this.gc.draw(new Rectangle2D.Double(x, y, w, h));
    }

    @Override
    public void strokeLine(double x1, double y1, double x2, double y2) {
        this.gc.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    public final void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
        this.gc.fill(new RoundRectangle2D.Double(x, y, w, h, arcWidth, arcHeight));
    }
}

