/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.geom.PreferredSize;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import javax.swing.CellRendererPane;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColorKt;
import org.mkui.font.CPFontMetrics;
import org.mkui.geom.Arc2D;
import org.mkui.geom.Ellipse2D;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;
import org.mkui.graphics.AbstractIGraphics;
import org.mkui.graphics.EnhancedJLabelPreferredSize;
import org.mkui.graphics.GeometryShape;
import org.mkui.graphics.HeadlessGraphics2D;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.SwingFontMetrics;
import org.mkui.labeling.EnhancedJLabelRenderer;
import org.mkui.labeling.EnhancedLabel;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 O2\u00020\u0001:\u0001OB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0015H\u0016J(\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0017\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J(\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0016J \u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001e\u001a\u00020%2\u0006\u0010\u001f\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020\u000eH\u0016J\u0010\u0010&\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J(\u0010'\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u0019H\u0016J\b\u0010(\u001a\u00020\u0015H\u0016J\f\u0010)\u001a\u00060*j\u0002`+H\u0016J\b\u0010,\u001a\u00020\u0015H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u00020\u0015H\u0016J\u0010\u00100\u001a\u0002012\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00102\u001a\u00020%2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u00103\u001a\u00020%2\u0006\u0010#\u001a\u00020$H\u0016J\u0018\u00104\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J\u0018\u00105\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u0015H\u0016J0\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u0002082\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u00192\u0006\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u0019H\u0016J\u0010\u0010;\u001a\u00020\u000e2\u0006\u0010<\u001a\u00020\u0015H\u0016J\u0014\u0010=\u001a\u00020\u000e2\n\u0010>\u001a\u00060*j\u0002`+H\u0016J\u0018\u0010?\u001a\u00020\u000e2\u000e\u0010@\u001a\n\u0018\u00010Aj\u0004\u0018\u0001`BH\u0016J\u0010\u0010C\u001a\u00020\u000e2\u0006\u0010D\u001a\u00020\u0015H\u0016J\u0012\u0010E\u001a\u00020\u000e2\b\u0010F\u001a\u0004\u0018\u00010GH\u0016J\u0010\u0010H\u001a\u00020\u000e2\u0006\u0010I\u001a\u00020\u0015H\u0016J\u0012\u0010J\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0016J \u0010K\u001a\u00020L2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020\u00192\u0006\u0010:\u001a\u00020\u0019H\u0016J\b\u0010M\u001a\u00020\u000eH\u0016J\u0018\u0010N\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\u0019H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Lorg/mkui/graphics/SwingIGraphics;", "Lorg/mkui/graphics/AbstractIGraphics;", "context", "Ljava/awt/Graphics2D;", "(Ljava/awt/Graphics2D;)V", "baseline", "Lorg/mkui/graphics/IGraphics$TextBaseline;", "component", "Lorg/mkui/labeling/EnhancedJLabelRenderer;", "getContext", "()Ljava/awt/Graphics2D;", "path", "Ljava/awt/geom/GeneralPath;", "beginPath", "", "closePath", "draw", "geometry", "Lorg/mkui/geom/Shape;", "drawLine", "x1", "", "y1", "x2", "y2", "", "drawPoint", "point", "Lorg/mkui/geom/Point2D;", "drawRectange", "x", "y", "width", "height", "drawString", "text", "", "", "fill", "fillRectangle", "getAscent", "getColor", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "getDescent", "getFontMetrics", "Lorg/mkui/font/CPFontMetrics;", "getLineWidth", "getStringBounds", "Lorg/mkui/geom/Rectangle2D;", "getStringHeight", "getStringWidth", "lineTo", "moveTo", "paintLabel", "l", "Lorg/mkui/labeling/EnhancedLabel;", "w", "h", "rotate", "theta", "setColor", "color", "setFont", "font", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "setGlobalAlpha", "alpha", "setLineDash", "dashPattern", "", "setLineWidth", "lineWidth", "setTextBaseline", "sizeLabel", "Lcom/macrofocus/common/geom/PreferredSize;", "stroke", "translate", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class SwingIGraphics
extends AbstractIGraphics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Graphics2D context;
    @NotNull
    private IGraphics.TextBaseline baseline = IGraphics.TextBaseline.Alphabetic;
    @Nullable
    private GeneralPath path;
    @NotNull
    private final EnhancedJLabelRenderer component = new EnhancedJLabelRenderer();
    public static final int $stable = 8;
    @NotNull
    private static final CellRendererPane cellRendererPane = new CellRendererPane();

    public SwingIGraphics(@Nullable Graphics2D context) {
        Graphics2D graphics2D = context;
        if (graphics2D == null) {
            graphics2D = new HeadlessGraphics2D();
        }
        this.context = graphics2D;
        this.context.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.context.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    @NotNull
    public final Graphics2D getContext() {
        return this.context;
    }

    @Override
    public void paintLabel(@NotNull EnhancedLabel l, int x, int y, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.component.setData(l);
        cellRendererPane.paintComponent(this.context, this.component, null, x, y, w, h);
    }

    @Override
    @NotNull
    public PreferredSize sizeLabel(@NotNull EnhancedLabel l, int w, int h) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.component.setData(l);
        return new EnhancedJLabelPreferredSize(this.context, this.component);
    }

    @Override
    public double getLineWidth() {
        Stroke stroke = this.context.getStroke();
        Intrinsics.checkNotNull((Object)stroke, (String)"null cannot be cast to non-null type java.awt.BasicStroke");
        return ((BasicStroke)stroke).getLineWidth();
    }

    @Override
    public void setLineWidth(double lineWidth) {
        this.context.setStroke(new BasicStroke((float)lineWidth, 0, 0));
    }

    @Override
    public void setLineDash(@Nullable float[] dashPattern) {
        Stroke stroke = new BasicStroke(1.0f, 0, 0, 10.0f, dashPattern, 0.0f);
        this.context.setStroke(stroke);
    }

    @Override
    public void setGlobalAlpha(double alpha) {
        this.context.setComposite(AlphaComposite.getInstance(3, (float)alpha));
    }

    @Override
    @NotNull
    public Color getColor() {
        Color color = this.context.getColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor(...)");
        return MkColorKt.colorOf(color);
    }

    @Override
    public void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.context.setColor(color);
    }

    @Override
    protected void draw(@NotNull Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        if (geometry instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)geometry;
            this.context.draw(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else if (geometry instanceof Arc2D) {
            Arc2D arc = (Arc2D)geometry;
            this.context.draw(new Arc2D.Double(arc.getX(), arc.getY(), arc.getWidth(), arc.getHeight(), arc.getAngleStart(), arc.getAngleExtent(), arc.getArcType()));
        } else {
            GeometryShape shape = new GeometryShape(geometry);
            this.context.draw(shape);
        }
    }

    @Override
    protected void fill(@NotNull Shape geometry) {
        Intrinsics.checkNotNullParameter((Object)geometry, (String)"geometry");
        Shape shape = geometry;
        if (shape instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)geometry;
            this.context.fill(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else if (shape instanceof Ellipse2D) {
            Ellipse2D r = (Ellipse2D)geometry;
            this.context.fill(new Ellipse2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
        } else {
            GeometryShape shape2 = new GeometryShape(geometry);
            this.context.fill(shape2);
        }
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.context.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawLine(double x1, double y1, double x2, double y2) {
        this.context.draw(new Line2D.Double(x1, y1, x2, y2));
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height) {
        this.context.fillRect(x, y, width, height);
    }

    @Override
    public void drawRectange(int x, int y, int width, int height) {
        this.context.drawRect(x, y, width, height);
    }

    @Override
    public void drawPoint(@Nullable Point2D point) {
        Point2D point2D = point;
        Intrinsics.checkNotNull((Object)point2D);
        this.context.fill(new Rectangle2D.Double(point2D.getX(), point.getY(), 1.0, 1.0));
    }

    @Override
    public void setTextBaseline(@Nullable IGraphics.TextBaseline baseline) {
        IGraphics.TextBaseline textBaseline = baseline;
        Intrinsics.checkNotNull((Object)((Object)textBaseline));
        this.baseline = textBaseline;
    }

    @Override
    public void setFont(@Nullable Font font) {
        Font font2 = font;
        Intrinsics.checkNotNull((Object)font2);
        this.context.setFont(font2);
    }

    @Override
    @NotNull
    public Rectangle2D getStringBounds(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        java.awt.geom.Rectangle2D stringBounds = this.context.getFontMetrics().getStringBounds(text, this.context);
        return new Rectangle2D.Double(stringBounds.getX(), stringBounds.getY(), stringBounds.getWidth(), stringBounds.getHeight());
    }

    @Override
    public float getStringWidth(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.context.getFontMetrics().stringWidth(text);
    }

    @Override
    public float getStringHeight(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        LineMetrics metrics = this.context.getFont().getLineMetrics(text, this.context.getFontRenderContext());
        return metrics.getHeight();
    }

    @Override
    public double getAscent() {
        return this.context.getFontMetrics().getAscent();
    }

    @Override
    public double getDescent() {
        return this.context.getFontMetrics().getDescent();
    }

    @Override
    @NotNull
    public CPFontMetrics getFontMetrics() {
        return new SwingFontMetrics(this.context);
    }

    @Override
    public void drawString(@NotNull String text, float x, float y) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        float y2 = y;
        switch (WhenMappings.$EnumSwitchMapping$0[this.baseline.ordinal()]) {
            case 1: {
                break;
            }
            case 2: {
                y2 += (float)this.context.getFontMetrics().getAscent();
                break;
            }
            case 3: {
                y2 -= (float)this.context.getFontMetrics().getDescent();
                break;
            }
            case 4: {
                FontMetrics fm = this.context.getFontMetrics();
                LineMetrics lm = fm.getLineMetrics(text, this.context);
                y2 = y2 - (lm.getAscent() + lm.getDescent()) / (float)2 + lm.getAscent();
                break;
            }
            case 5: {
                throw new UnsupportedOperationException();
            }
            case 6: {
                throw new UnsupportedOperationException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.context.drawString(text, x, y2);
    }

    @Override
    public void translate(int x, int y) {
        this.context.translate(x, y);
    }

    @Override
    public void rotate(double theta) {
        this.context.rotate(theta);
    }

    @Override
    public void beginPath() {
        this.path = new GeneralPath();
    }

    @Override
    public void moveTo(double x, double y) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.moveTo(x, y);
    }

    @Override
    public void lineTo(double x, double y) {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.lineTo(x, y);
    }

    @Override
    public void closePath() {
        GeneralPath generalPath = this.path;
        Intrinsics.checkNotNull((Object)generalPath);
        generalPath.closePath();
    }

    @Override
    public void stroke() {
        this.context.draw(this.path);
    }

    @Override
    public void fill() {
        this.context.fill(this.path);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/mkui/graphics/SwingIGraphics$Companion;", "", "()V", "cellRendererPane", "Ljavax/swing/CellRendererPane;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IGraphics.TextBaseline.values().length];
            try {
                nArray[IGraphics.TextBaseline.Alphabetic.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Top.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Bottom.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Middle.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Hanging.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[IGraphics.TextBaseline.Ideographic.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

