/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.graphics;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.IHeadless;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J*\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u000e\u0010\t\u001a\n\u0018\u00010\nj\u0004\u0018\u0001`\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/mkui/graphics/SwingIHeadless;", "Lorg/mkui/graphics/IHeadless;", "()V", "frc", "Ljava/awt/font/FontRenderContext;", "getStringBounds", "Lorg/mkui/geom/Rectangle2D;", "g", "Lorg/mkui/graphics/IGraphics;", "font", "Ljava/awt/Font;", "Lorg/mkui/font/MkFont;", "text", "", "getStringHeight", "", "getStringWidth", "mkui"})
@StabilityInferred(parameters=0)
public final class SwingIHeadless
implements IHeadless {
    @NotNull
    private final FontRenderContext frc = new FontRenderContext(null, true, true);
    public static final int $stable = 8;

    @Override
    @NotNull
    public org.mkui.geom.Rectangle2D getStringBounds(@Nullable IGraphics g2, @Nullable Font font, @NotNull String text) {
        org.mkui.geom.Rectangle2D rectangle2D;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (g2 != null) {
            org.mkui.geom.Rectangle2D stringBounds;
            g2.setFont(font);
            rectangle2D = stringBounds = g2.getStringBounds(text);
        } else {
            Rectangle2D rectangle2D2 = new TextLayout(text, font, this.frc).getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D2, (String)"getBounds(...)");
            Rectangle2D stringBounds = rectangle2D2;
            rectangle2D = new Rectangle2D.Double(stringBounds.getX(), stringBounds.getY(), stringBounds.getWidth(), stringBounds.getHeight());
        }
        return rectangle2D;
    }

    @Override
    public float getStringWidth(@Nullable IGraphics g2, @Nullable Font font, @NotNull String text) {
        float f;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (g2 != null) {
            g2.setFont(font);
            f = g2.getStringWidth(text);
        } else if (((CharSequence)text).length() > 0) {
            Rectangle2D rectangle2D = new TextLayout(text, font, this.frc).getBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle2D, (String)"getBounds(...)");
            Rectangle2D stringBounds = rectangle2D;
            f = (float)stringBounds.getWidth();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getStringHeight(@Nullable IGraphics g2, @Nullable Font font, @NotNull String text) {
        float f;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        if (g2 != null) {
            g2.setFont(font);
            f = g2.getStringHeight(text);
        } else {
            Font font2 = font;
            Intrinsics.checkNotNull((Object)font2);
            LineMetrics lineMetrics = font2.getLineMetrics(text, this.frc);
            Intrinsics.checkNotNullExpressionValue((Object)lineMetrics, (String)"getLineMetrics(...)");
            LineMetrics metrics = lineMetrics;
            f = metrics.getHeight();
        }
        return f;
    }
}

