/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.palette;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.palette.AbstractMutablePalette;
import org.mkui.palette.Cycle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u001a\u0010\u0002\u001a\u000e\u0012\n\b\u0001\u0012\u00060\u0004j\u0002`\u00050\u0003\"\u00060\u0004j\u0002`\u0005\u00a2\u0006\u0002\u0010\u0006B\u0019\b\u0016\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\u0007\u00a2\u0006\u0002\u0010\bJ\u0014\u0010\u0018\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u0019\u001a\u00020\u000eH\u0016J\u0014\u0010\u001a\u001a\u00060\u0004j\u0002`\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R$\u0010\u0002\u001a\f\u0012\b\u0012\u00060\u0004j\u0002`\u00050\tX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\bR\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0010\u00a8\u0006\u001d"}, d2={"Lorg/mkui/palette/DynamicPalette;", "Lorg/mkui/palette/AbstractMutablePalette;", "colors", "", "Ljava/awt/Color;", "Lorg/mkui/color/MkColor;", "([Ljava/awt/Color;)V", "", "(Ljava/util/List;)V", "", "getColors", "()Ljava/util/List;", "setColors", "highestFraction", "", "getHighestFraction", "()D", "isInverted", "", "()Z", "setInverted", "(Z)V", "lowestFraction", "getLowestFraction", "getColor", "fraction", "getColorAt", "index", "", "mkui"})
@StabilityInferred(parameters=0)
public class DynamicPalette
extends AbstractMutablePalette {
    @NotNull
    private List<Color> colors;
    private boolean isInverted;
    public static final int $stable = 8;

    @NotNull
    protected final List<Color> getColors() {
        return this.colors;
    }

    protected final void setColors(@NotNull List<Color> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.colors = list;
    }

    @Override
    public final boolean isInverted() {
        return this.isInverted;
    }

    public final void setInverted(boolean bl) {
        this.isInverted = bl;
    }

    public DynamicPalette(Color ... colors) {
        Intrinsics.checkNotNullParameter((Object)colors, (String)"colors");
        this.colors = ArraysKt.toMutableList((Object[])colors);
        this.setColorCount(this.colors.size());
    }

    public DynamicPalette(@NotNull List<? extends Color> colors) {
        Intrinsics.checkNotNullParameter(colors, (String)"colors");
        this.colors = CollectionsKt.toMutableList((Collection)colors);
        this.setColorCount(this.colors.size());
    }

    @Override
    @NotNull
    public Color getColor(double fraction) {
        Color color;
        double fraction2 = fraction;
        boolean inverted = this.isInverted;
        Cycle cycle = this.getCycle();
        switch (cycle == null ? -1 : WhenMappings.$EnumSwitchMapping$0[cycle.ordinal()]) {
            case 1: {
                inverted = (int)fraction2 % 2 == 0;
                fraction2 -= (double)((int)fraction2);
                break;
            }
            case 2: {
                fraction2 -= (double)((int)fraction2);
                break;
            }
            default: {
            }
        }
        if (fraction2 < this.getLowestFraction()) {
            color = this.getColor(this.getLowestFraction());
        } else if (fraction2 > this.getHighestFraction()) {
            color = this.getColor(this.getHighestFraction());
        } else {
            int index = this.getEntry(!inverted ? fraction2 : 1.0 - fraction2, this.getColorCount(), this.colors.size());
            color = this.colors.get(index);
        }
        return color;
    }

    protected double getLowestFraction() {
        return 0.0;
    }

    protected double getHighestFraction() {
        return 1.0;
    }

    @Override
    @NotNull
    public Color getColorAt(int index) {
        return this.getColorCount() == this.colors.size() ? (index < 0 ? this.getColorAt(0) : (index > this.getColorCount() - 1 ? this.getColorAt(this.getColorCount() - 1) : this.colors.get(index))) : this.getColor((double)this.getColorCount() / (double)index);
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Cycle.values().length];
            try {
                nArray[Cycle.REFLECT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Cycle.REPEAT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

