/*
 * Decompiled with CFR 0.152.
 */
package corg.mkui.geom;

import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.geom.AffineTransform;
import org.mkui.geom.AreaOp;
import org.mkui.geom.Crossings;
import org.mkui.geom.Curve;
import org.mkui.geom.FlatteningPathIterator;
import org.mkui.geom.PathIterator;
import org.mkui.geom.Point2D;
import org.mkui.geom.Rectangle;
import org.mkui.geom.Rectangle2D;
import org.mkui.geom.Shape;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0005\b\u0007\u0018\u0000 42\u00020\u0001:\u000234B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0005J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000J\b\u0010\u000e\u001a\u00020\fH\u0002J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000J\u000e\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0000J\u0006\u0010\u0012\u001a\u00020\fJ\b\u0010\u001c\u001a\u00020\nH\u0002J\u0011\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001fH\u0096\u0002J\u0016\u0010\u001d\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!J\u0010\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\nH\u0016J&\u0010#\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020!J\u0012\u0010)\u001a\u00020(2\b\u0010+\u001a\u0004\u0018\u00010,H\u0016J\u0010\u0010-\u001a\u00020(2\u0006\u0010.\u001a\u00020!H\u0016J\u0006\u0010/\u001a\u000200J\u0013\u00101\u001a\u00020\u00142\b\u00102\u001a\u0004\u0018\u000100H\u0096\u0002J\u0011\u0010\u001d\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\nH\u0086\u0002J&\u0010\u001d\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020!R\u0016\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0017\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0015R\u0014\u0010\u0019\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u00065"}, d2={"Lcorg/mkui/geom/Area;", "Lorg/mkui/geom/Shape;", "<init>", "()V", "s", "(Lorg/mkui/geom/Shape;)V", "curves", "", "Lorg/mkui/geom/Curve;", "cachedBounds", "Lorg/mkui/geom/Rectangle2D;", "add", "", "rhs", "invalidateBounds", "subtract", "intersect", "exclusiveOr", "reset", "isEmpty", "", "()Z", "isPolygonal", "isRectangular", "isSingular", "bounds2D", "getBounds2D", "()Lorg/mkui/geom/Rectangle2D;", "getCachedBounds", "contains", "p", "Lorg/mkui/geom/Point2D;", "x", "", "y", "intersects", "r", "w", "h", "pathIterator", "Lorg/mkui/geom/PathIterator;", "getPathIterator", "()Lorg/mkui/geom/PathIterator;", "at", "Lorg/mkui/geom/AffineTransform;", "getFlattenPathIterator", "flatness", "clone", "", "equals", "other", "AreaIterator", "Companion", "mkui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nArea.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Area.kt\ncorg/mkui/geom/Area\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,711:1\n1#2:712\n*E\n"})
public final class Area
implements Shape {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private List<Curve> curves;
    @Nullable
    private Rectangle2D cachedBounds;
    public static final int $stable = 8;
    @NotNull
    private static final List<Curve> EmptyCurves = new ArrayList();

    public Area() {
        this.curves = EmptyCurves;
    }

    public Area(@NotNull Shape s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.curves = s instanceof Area ? ((Area)s).curves : Area.Companion.pathToCurves(Shape.getPathIterator$default(s, null, 1, null));
    }

    public final void add(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.AddOp addOp = new AreaOp.AddOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = rhs.curves;
        Intrinsics.checkNotNull(list2);
        this.curves = addOp.calculate(list, list2);
        this.invalidateBounds();
    }

    private final void invalidateBounds() {
        this.cachedBounds = null;
    }

    public final void subtract(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.SubOp subOp = new AreaOp.SubOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = rhs.curves;
        Intrinsics.checkNotNull(list2);
        this.curves = subOp.calculate(list, list2);
        this.invalidateBounds();
    }

    public final void intersect(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.IntOp intOp = new AreaOp.IntOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = rhs.curves;
        Intrinsics.checkNotNull(list2);
        this.curves = intOp.calculate(list, list2);
        this.invalidateBounds();
    }

    public final void exclusiveOr(@NotNull Area rhs) {
        Intrinsics.checkNotNullParameter((Object)rhs, (String)"rhs");
        AreaOp.XorOp xorOp = new AreaOp.XorOp();
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        List<Curve> list2 = rhs.curves;
        Intrinsics.checkNotNull(list2);
        this.curves = xorOp.calculate(list, list2);
        this.invalidateBounds();
    }

    public final void reset() {
        this.curves = new ArrayList();
        this.invalidateBounds();
    }

    public final boolean isEmpty() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return list.size() == 0;
    }

    public final boolean isPolygonal() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        for (Curve c2 : list) {
            if (c2.getOrder() <= 1) continue;
            return false;
        }
        return true;
    }

    public final boolean isRectangular() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        int size = list.size();
        if (size == 0) {
            return true;
        }
        if (size > 3) {
            return false;
        }
        List<Curve> list2 = this.curves;
        Intrinsics.checkNotNull(list2);
        Curve c1 = list2.get(1);
        List<Curve> list3 = this.curves;
        Intrinsics.checkNotNull(list3);
        Curve c2 = list3.get(2);
        if (c1.getOrder() != 1 || c2.getOrder() != 1) {
            return false;
        }
        return !(c1.getXTop() == c1.getXBot()) || !(c2.getXTop() == c2.getXBot()) ? false : c1.getYTop() == c2.getYTop() && c1.getYBot() == c2.getYBot();
    }

    public final boolean isSingular() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        if (list.size() < 3) {
            return true;
        }
        List<Curve> list2 = this.curves;
        Intrinsics.checkNotNull(list2);
        for (Curve c2 : list2) {
            if (c2.getOrder() != 0) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Rectangle2D getBounds2D() {
        return this.getCachedBounds().getBounds2D();
    }

    private final Rectangle2D getCachedBounds() {
        Rectangle2D.Double double_;
        if (this.cachedBounds != null) {
            Rectangle2D rectangle2D = this.cachedBounds;
            Intrinsics.checkNotNull((Object)rectangle2D);
            return rectangle2D;
        }
        Rectangle2D r = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        if (list.size() > 0) {
            List<Curve> list2 = this.curves;
            Intrinsics.checkNotNull(list2);
            Curve c2 = list2.get(0);
            r = new Rectangle2D.Double(c2.getX0(), c2.getY0(), 0.0, 0.0);
            List<Curve> list3 = this.curves;
            Intrinsics.checkNotNull(list3);
            int n = list3.size();
            for (int i = 1; i < n; ++i) {
                List<Curve> list4 = this.curves;
                Intrinsics.checkNotNull(list4);
                r = list4.get(i).enlarge(new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight()));
            }
        }
        Rectangle2D.Double it = double_ = new Rectangle2D.Double(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        boolean bl = false;
        this.cachedBounds = it;
        return double_;
    }

    @Override
    public boolean contains(@NotNull Point2D p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return this.contains(p.getX(), p.getY());
    }

    public final boolean contains(double x, double y) {
        if (!this.getCachedBounds().contains(x, y)) {
            return false;
        }
        int crossings = 0;
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        for (Curve c2 : list) {
            crossings += c2.crossingsFor(x, y);
        }
        return crossings & true;
    }

    @Override
    public boolean intersects(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean intersects(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().intersects(x, y, w, h)) {
            return false;
        }
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        Crossings c2 = Crossings.Companion.findCrossings(list, x, y, x + w, y + h);
        return c2 == null || !c2.isEmpty();
    }

    @Override
    @NotNull
    public PathIterator getPathIterator() {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return new AreaIterator(list, null);
    }

    @Override
    @NotNull
    public PathIterator getPathIterator(@Nullable AffineTransform at) {
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        return new AreaIterator(list, at);
    }

    @Override
    @NotNull
    public PathIterator getFlattenPathIterator(double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(), flatness);
    }

    @NotNull
    public final Object clone() {
        return new Area(this);
    }

    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other instanceof Area) {
            AreaOp.XorOp xorOp = new AreaOp.XorOp();
            List<Curve> list = this.curves;
            Intrinsics.checkNotNull(list);
            List<Curve> list2 = ((Area)other).curves;
            Intrinsics.checkNotNull(list2);
            List<Curve> c2 = xorOp.calculate(list, list2);
            return c2.isEmpty();
        }
        return false;
    }

    public final boolean contains(@NotNull Rectangle2D r) {
        Intrinsics.checkNotNullParameter((Object)r, (String)"r");
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public final boolean contains(double x, double y, double w, double h) {
        if (w < 0.0 || h < 0.0) {
            return false;
        }
        if (!this.getCachedBounds().contains(x, y, w, h)) {
            return false;
        }
        List<Curve> list = this.curves;
        Intrinsics.checkNotNull(list);
        Crossings c2 = Crossings.Companion.findCrossings(list, x, y, x + w, y + h);
        return c2 != null && c2.covers(y, y + h);
    }

    @Override
    @NotNull
    public Rectangle getBounds() {
        return Shape.super.getBounds();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\u0010\u0013\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u001f\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\t\u0010\u0014\u001a\u00020\u0015H\u0096\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0019H\u0016R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcorg/mkui/geom/Area$AreaIterator;", "Lorg/mkui/geom/PathIterator;", "curves", "", "Lorg/mkui/geom/Curve;", "at", "Lorg/mkui/geom/AffineTransform;", "<init>", "(Ljava/util/List;Lorg/mkui/geom/AffineTransform;)V", "transform", "index", "", "prevcurve", "thiscurve", "windingRule", "getWindingRule", "()I", "isDone", "", "()Z", "next", "", "currentSegment", "coords", "", "", "mkui"})
    @StabilityInferred(parameters=0)
    public static final class AreaIterator
    implements PathIterator {
        @Nullable
        private final AffineTransform transform;
        @NotNull
        private final List<Curve> curves;
        private int index;
        @Nullable
        private Curve prevcurve;
        @Nullable
        private Curve thiscurve;
        public static final int $stable = 8;

        public AreaIterator(@NotNull List<Curve> curves, @Nullable AffineTransform at) {
            Intrinsics.checkNotNullParameter(curves, (String)"curves");
            this.curves = curves;
            this.transform = at;
            if (curves.size() >= 1) {
                Curve curve = curves.get(0);
                Intrinsics.checkNotNull((Object)curve, (String)"null cannot be cast to non-null type org.mkui.geom.Curve");
                this.thiscurve = curve;
            }
        }

        @Override
        public int getWindingRule() {
            return 1;
        }

        @Override
        public boolean isDone() {
            return this.prevcurve == null && this.thiscurve == null;
        }

        @Override
        public void next() {
            if (this.prevcurve != null) {
                this.prevcurve = null;
            } else {
                this.prevcurve = this.thiscurve;
                int n = this.index;
                this.index = n + 1;
                if (this.index < this.curves.size()) {
                    Curve curve = this.thiscurve = this.curves.get(this.index);
                    Intrinsics.checkNotNull((Object)curve);
                    if (curve.getOrder() != 0) {
                        Curve curve2 = this.prevcurve;
                        Intrinsics.checkNotNull((Object)curve2);
                        double d = curve2.getX1();
                        Curve curve3 = this.thiscurve;
                        Intrinsics.checkNotNull((Object)curve3);
                        if (d == curve3.getX0()) {
                            Curve curve4 = this.prevcurve;
                            Intrinsics.checkNotNull((Object)curve4);
                            double d2 = curve4.getY1();
                            Curve curve5 = this.thiscurve;
                            Intrinsics.checkNotNull((Object)curve5);
                            if (d2 == curve5.getY0()) {
                                this.prevcurve = null;
                            }
                        }
                    }
                } else {
                    this.thiscurve = null;
                }
            }
        }

        @Override
        public int currentSegment(@NotNull float[] coords) {
            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
            double[] dcoords = new double[6];
            int segtype = this.currentSegment(dcoords);
            int numpoints = switch (segtype) {
                case 4 -> 0;
                case 2 -> 2;
                case 3 -> 3;
                default -> 1;
            };
            int n = numpoints * 2;
            for (int i = 0; i < n; ++i) {
                coords[i] = (float)dcoords[i];
            }
            return segtype;
        }

        @Override
        public int currentSegment(@NotNull double[] coords) {
            int numpoints;
            int segtype;
            block9: {
                block6: {
                    block8: {
                        block7: {
                            Intrinsics.checkNotNullParameter((Object)coords, (String)"coords");
                            segtype = 0;
                            numpoints = 0;
                            if (this.prevcurve == null) break block6;
                            if (this.thiscurve == null) break block7;
                            Curve curve = this.thiscurve;
                            Intrinsics.checkNotNull((Object)curve);
                            if (curve.getOrder() != 0) break block8;
                        }
                        return 4;
                    }
                    Curve curve = this.thiscurve;
                    Intrinsics.checkNotNull((Object)curve);
                    coords[0] = curve.getX0();
                    Curve curve2 = this.thiscurve;
                    Intrinsics.checkNotNull((Object)curve2);
                    coords[1] = curve2.getY0();
                    segtype = 1;
                    numpoints = 1;
                    break block9;
                }
                if (this.thiscurve == null) {
                    throw new NoSuchElementException("area iterator out of bounds");
                }
                Curve curve = this.thiscurve;
                Intrinsics.checkNotNull((Object)curve);
                segtype = curve.getSegment(coords);
                Curve curve3 = this.thiscurve;
                Intrinsics.checkNotNull((Object)curve3);
                numpoints = curve3.getOrder();
                if (numpoints == 0) {
                    numpoints = 1;
                }
            }
            if (this.transform != null) {
                this.transform.transform(coords, 0, coords, 0, numpoints);
            }
            return segtype;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\b\u001a\u00020\tH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcorg/mkui/geom/Area$Companion;", "", "<init>", "()V", "EmptyCurves", "", "Lorg/mkui/geom/Curve;", "pathToCurves", "pi", "Lorg/mkui/geom/PathIterator;", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        private final List<Curve> pathToCurves(PathIterator pi) {
            ArrayList curves = new ArrayList();
            int windingRule = pi.getWindingRule();
            double[] coords = new double[23];
            double movx = 0.0;
            double movy = 0.0;
            double curx = 0.0;
            double cury = 0.0;
            while (!pi.isDone()) {
                double newy = 0.0;
                double newx = 0.0;
                switch (pi.currentSegment(coords)) {
                    case 0: {
                        Curve.Companion.insertLine(curves, curx, cury, movx, movy);
                        Companion $this$pathToCurves_u24lambda_u240 = this;
                        boolean bl = false;
                        curx = movx = coords[0];
                        Companion $this$pathToCurves_u24lambda_u241 = this;
                        boolean bl2 = false;
                        cury = movy = coords[1];
                        Curve.Companion.insertMove(curves, movx, movy);
                        break;
                    }
                    case 1: {
                        newx = coords[0];
                        newy = coords[1];
                        Curve.Companion.insertLine(curves, curx, cury, newx, newy);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 2: {
                        newx = coords[2];
                        newy = coords[3];
                        Curve.Companion.insertQuad(curves, curx, cury, coords);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 3: {
                        newx = coords[4];
                        newy = coords[5];
                        Curve.Companion.insertCubic(curves, curx, cury, coords);
                        curx = newx;
                        cury = newy;
                        break;
                    }
                    case 4: {
                        Curve.Companion.insertLine(curves, curx, cury, movx, movy);
                        curx = movx;
                        cury = movy;
                    }
                }
                pi.next();
            }
            Curve.Companion.insertLine(curves, curx, cury, movx, movy);
            AreaOp operator = null;
            operator = windingRule == 0 ? (AreaOp)new AreaOp.EOWindOp() : (AreaOp)new AreaOp.NZWindOp();
            return operator.calculate(curves, EmptyCurves);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

