/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.CollectionFactory;
import com.macrofocus.common.crossplatform.CPHelper;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperty;
import com.macrofocus.common.timer.CPTimer;
import com.macrofocus.common.timer.CPTimerListener;
import com.macrofocus.common.timing.Timing;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.AveragingSwingLayer;
import org.mkui.canvas.BufferedSwingLayer;
import org.mkui.canvas.CanvasListener;
import org.mkui.canvas.ContextMenuListener;
import org.mkui.canvas.DensitySwingLayer;
import org.mkui.canvas.DirectSwingLayer;
import org.mkui.canvas.GraphicsContextDrawing;
import org.mkui.canvas.KeyListener;
import org.mkui.canvas.MouseListener;
import org.mkui.canvas.MouseMotionListener;
import org.mkui.canvas.MouseWheelListener;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.Rendering;
import org.mkui.canvas.SwingCanvasHandler;
import org.mkui.canvas.SwingLayer;
import org.mkui.component.CPInteractiveComponent;
import org.mkui.graphics.CPGraphicsContext2D;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.IDrawingListener;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.SwingIGraphics;
import org.mkui.graphics.pressure.Pressure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u00002\u00020\u0001:\u0001ZB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010$\u001a\u00020%H\u0016J\u000e\u0010*\u001a\u00020%2\u0006\u0010+\u001a\u00020,J.\u0010-\u001a\u00020%2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u000b2\b\u00101\u001a\u0004\u0018\u0001022\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u001a\u00105\u001a\u00020%2\b\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u00020\u000bH\u0016J\u0010\u0010*\u001a\u00020%2\u0006\u00100\u001a\u00020\u000bH\u0016J\u000e\u00106\u001a\u00020%2\u0006\u0010+\u001a\u00020\u0006J\u0010\u00107\u001a\u00020%2\u0006\u00100\u001a\u00020\u000bH\u0016J\u0018\u00108\u001a\u00020%2\u0006\u00109\u001a\u00020\u000b2\u0006\u0010:\u001a\u00020\fH\u0002J\b\u0010;\u001a\u00020%H\u0016J\b\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020AH\u0016J\u0010\u0010C\u001a\u00020%2\u0006\u0010D\u001a\u00020\u000eH\u0016J\u0018\u0010E\u001a\u00020%2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020GH\u0014J\u0006\u0010I\u001a\u00020%J\u0006\u0010J\u001a\u00020%J\u0010\u0010K\u001a\u00020%2\u0006\u0010D\u001a\u00020LH\u0016J\u0010\u0010M\u001a\u00020%2\u0006\u0010D\u001a\u00020NH\u0016J\u0010\u0010O\u001a\u00020%2\u0006\u0010D\u001a\u00020LH\u0016J\u0010\u0010P\u001a\u00020%2\u0006\u0010D\u001a\u00020NH\u0016J\u000e\u0010Q\u001a\u00020%2\u0006\u0010D\u001a\u00020RJ\u000e\u0010S\u001a\u00020%2\u0006\u0010D\u001a\u00020RJ\u000e\u0010T\u001a\u00020%2\u0006\u0010D\u001a\u00020UJ\u000e\u0010V\u001a\u00020%2\u0006\u0010D\u001a\u00020WJ\u000e\u0010X\u001a\u00020%2\u0006\u0010D\u001a\u00020UJ\u000e\u0010Y\u001a\u00020%2\u0006\u0010D\u001a\u00020WR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u001a\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0015\u0010\u001c\u001a\u00060\u001dR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010<\u001a\u00020=8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b>\u0010?\u00a8\u0006["}, d2={"Lorg/mkui/canvas/CPCanvas;", "Lorg/mkui/component/CPInteractiveComponent;", "<init>", "()V", "layers", "", "Lorg/mkui/canvas/SwingLayer;", "getLayers", "()Ljava/util/List;", "drawings", "", "Lorg/mkui/graphics/IDrawing;", "Lorg/mkui/graphics/IDrawingListener;", "listeners", "Lorg/mkui/canvas/CanvasListener;", "showTiming", "Lcom/macrofocus/common/properties/MutableProperty;", "", "getShowTiming", "()Lcom/macrofocus/common/properties/MutableProperty;", "prepareTiming", "Lcom/macrofocus/common/timing/Timing;", "getPrepareTiming", "()Lcom/macrofocus/common/timing/Timing;", "renderTiming", "getRenderTiming", "interactTiming", "getInteractTiming", "canvas", "Lorg/mkui/canvas/CPCanvas$CanvasComponent;", "getCanvas", "()Lorg/mkui/canvas/CPCanvas$CanvasComponent;", "handler", "Lorg/mkui/canvas/SwingCanvasHandler;", "getHandler", "()Lorg/mkui/canvas/SwingCanvasHandler;", "updateColorTheme", "", "igraphics", "Lorg/mkui/graphics/IGraphics;", "getIgraphics", "()Lorg/mkui/graphics/IGraphics;", "addLayer", "d", "Lorg/mkui/canvas/GraphicsContextDrawing;", "addDensityLayer", "rendering", "Lorg/mkui/canvas/Rendering;", "iDrawing", "pressure", "Lorg/mkui/graphics/pressure/Pressure;", "paletteProvider", "Lorg/mkui/canvas/PaletteProvider;", "addAveragingLayer", "addNativeLayer", "addBufferedLayer", "registerDrawing", "drawing", "listener", "removeAllLayers", "nativeComponent", "Ljavax/swing/JComponent;", "getNativeComponent", "()Ljavax/swing/JComponent;", "getWidth", "", "getHeight", "addCanvasListener", "l", "notifySizeChanged", "width", "", "height", "refresh", "redraw", "addMouseListener", "Lorg/mkui/canvas/MouseListener;", "addMouseMotionListener", "Lorg/mkui/canvas/MouseMotionListener;", "removeMouseListener", "removeMouseMotionListener", "addMouseWheelListener", "Lorg/mkui/canvas/MouseWheelListener;", "removeMouseWheelListener", "removeKeyListener", "Lorg/mkui/canvas/KeyListener;", "removeContextMenuListener", "Lorg/mkui/canvas/ContextMenuListener;", "addKeyListener", "addContextMenuListener", "CanvasComponent", "mkui"})
@StabilityInferred(parameters=0)
public class CPCanvas
implements CPInteractiveComponent {
    @NotNull
    private final List<SwingLayer> layers = CollectionFactory.INSTANCE.copyOnWriteArrayList();
    @NotNull
    private final Map<IDrawing, IDrawingListener> drawings = CollectionFactory.INSTANCE.concurrentHashMap();
    @NotNull
    private final List<CanvasListener> listeners = new ArrayList();
    @NotNull
    private final MutableProperty<Boolean> showTiming = (MutableProperty)new SimpleProperty((Object)false);
    @NotNull
    private final Timing prepareTiming = new Timing();
    @NotNull
    private final Timing renderTiming = new Timing();
    @NotNull
    private final Timing interactTiming = new Timing();
    @NotNull
    private final CanvasComponent canvas = new CanvasComponent();
    @NotNull
    private final SwingCanvasHandler handler = new SwingCanvasHandler(this.canvas, this.interactTiming);
    public static final int $stable = 8;

    @NotNull
    public final List<SwingLayer> getLayers() {
        return this.layers;
    }

    @NotNull
    public final MutableProperty<Boolean> getShowTiming() {
        return this.showTiming;
    }

    @NotNull
    public final Timing getPrepareTiming() {
        return this.prepareTiming;
    }

    @NotNull
    public final Timing getRenderTiming() {
        return this.renderTiming;
    }

    @NotNull
    public final Timing getInteractTiming() {
        return this.interactTiming;
    }

    @NotNull
    public final CanvasComponent getCanvas() {
        return this.canvas;
    }

    @NotNull
    public final SwingCanvasHandler getHandler() {
        return this.handler;
    }

    public void updateColorTheme() {
    }

    @NotNull
    public final IGraphics getIgraphics() {
        Graphics2D ctx;
        Graphics graphics = this.canvas.getGraphics();
        Graphics2D graphics2D = ctx = graphics instanceof Graphics2D ? (Graphics2D)graphics : null;
        if (ctx != null) {
            return new SwingIGraphics(ctx);
        }
        Graphics graphics2 = this.getNativeComponent().getGraphics();
        Intrinsics.checkNotNull((Object)graphics2, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        return new SwingIGraphics((Graphics2D)graphics2);
    }

    public final void addLayer(@NotNull GraphicsContextDrawing d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(new SwingLayer(d){
            private int width;
            private int height;
            final /* synthetic */ GraphicsContextDrawing $d;
            {
                this.$d = $d;
            }

            public void prepare(int width, int height) {
                this.width = width;
                this.height = height;
            }

            public void render(Graphics2D g2) {
                Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
                this.$d.draw(new CPGraphicsContext2D(g2), this.width, this.height);
            }
        });
    }

    public void addDensityLayer(@Nullable Rendering rendering, @NotNull IDrawing iDrawing, @Nullable Pressure pressure, @Nullable PaletteProvider paletteProvider) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        SwingLayer layer = null;
        Rendering rendering2 = rendering;
        switch (rendering2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering2.ordinal()]) {
            case 1: {
                Pressure pressure2 = pressure;
                Intrinsics.checkNotNull((Object)pressure2);
                PaletteProvider paletteProvider2 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider2);
                layer = new DensitySwingLayer(iDrawing, 0, 0, true, pressure2, paletteProvider2);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 2: {
                float alpha = 0.5f;
                PaletteProvider paletteProvider3 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider3);
                layer = new BufferedSwingLayer(iDrawing, true, paletteProvider3.getPalette().getColor(1.0), AlphaComposite.getInstance(3, alpha));
                boolean bl = this.layers.add(layer);
                break;
            }
            case 3: {
                PaletteProvider paletteProvider4 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider4);
                layer = new BufferedSwingLayer(iDrawing, true, paletteProvider4.getPalette().getColor(1.0), null);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 4: {
                PaletteProvider paletteProvider5 = paletteProvider;
                Intrinsics.checkNotNull((Object)paletteProvider5);
                layer = new DirectSwingLayer(iDrawing, paletteProvider5.getPalette().getColor(1.0));
                boolean bl = this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(this, layer){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ SwingLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().schedulePrepare(this.$layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addAveragingLayer(@Nullable Rendering rendering, @NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        SwingLayer layer = null;
        Rendering rendering2 = rendering;
        switch (rendering2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[rendering2.ordinal()]) {
            case 1: {
                layer = new AveragingSwingLayer(iDrawing, true);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 2: {
                layer = new BufferedSwingLayer(iDrawing, true);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 3: {
                layer = new BufferedSwingLayer(iDrawing, true);
                boolean bl = this.layers.add(layer);
                break;
            }
            case 4: {
                layer = new DirectSwingLayer(iDrawing, null, 2, null);
                boolean bl = this.layers.add(layer);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.registerDrawing(iDrawing, new IDrawingListener(this, layer){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ SwingLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().schedulePrepare(this.$layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    public void addLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        DirectSwingLayer layer = new DirectSwingLayer(iDrawing, null, 2, null);
        this.layers.add(layer);
        this.registerDrawing(iDrawing, new IDrawingListener(this){
            final /* synthetic */ CPCanvas this$0;
            {
                this.this$0 = $receiver;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().scheduleRender();
            }
        });
        this.canvas.scheduleRender();
    }

    public final void addNativeLayer(@NotNull SwingLayer d) {
        Intrinsics.checkNotNullParameter((Object)d, (String)"d");
        this.layers.add(d);
    }

    public void addBufferedLayer(@NotNull IDrawing iDrawing) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        BufferedSwingLayer layer = new BufferedSwingLayer(iDrawing, true);
        this.layers.add(layer);
        this.registerDrawing(iDrawing, new IDrawingListener(this, layer){
            final /* synthetic */ CPCanvas this$0;
            final /* synthetic */ BufferedSwingLayer $layer;
            {
                this.this$0 = $receiver;
                this.$layer = $layer;
            }

            public void iDrawingChanged() {
                this.this$0.getCanvas().schedulePrepare(this.$layer);
            }
        });
        this.canvas.schedulePrepare(layer);
    }

    private final void registerDrawing(IDrawing drawing, IDrawingListener listener2) {
        this.drawings.put(drawing, listener2);
        drawing.addIDrawingListener(listener2);
    }

    public void removeAllLayers() {
        this.layers.clear();
        for (Map.Entry<IDrawing, IDrawingListener> entry : this.drawings.entrySet()) {
            IDrawing key = entry.getKey();
            IDrawingListener value = entry.getValue();
            key.removeIDrawingListener(value);
        }
        this.drawings.clear();
    }

    @Override
    @NotNull
    public JComponent getNativeComponent() {
        return this.canvas;
    }

    public double getWidth() {
        return this.getNativeComponent().getWidth();
    }

    public double getHeight() {
        return this.getNativeComponent().getHeight();
    }

    public void addCanvasListener(@NotNull CanvasListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.listeners.add(l);
    }

    protected void notifySizeChanged(int width, int height) {
        for (CanvasListener listener2 : this.listeners) {
            listener2.sizeChange(width, height);
        }
    }

    public final void refresh() {
        this.canvas.schedulePrepare();
    }

    public final void redraw() {
        this.getNativeComponent().repaint();
    }

    @Override
    public void addMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addMouseMotionListener(l);
    }

    @Override
    public void removeMouseListener(@NotNull MouseListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.removeMouseListener(l);
    }

    @Override
    public void removeMouseMotionListener(@NotNull MouseMotionListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.removeMouseMotionListener(l);
    }

    public final void addMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addMouseWheelListener(l);
    }

    public final void removeMouseWheelListener(@NotNull MouseWheelListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.removeMouseWheelListener(l);
    }

    public final void removeKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.removeKeyListener(l);
    }

    public final void removeContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.removeContextMenuListener(l);
    }

    public final void addKeyListener(@NotNull KeyListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addKeyListener(l);
    }

    public final void addContextMenuListener(@NotNull ContextMenuListener l) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        this.handler.addContextMenuListener(l);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006J\u0006\u0010\r\u001a\u00020\fJ\b\u0010\u000f\u001a\u00020\fH\u0002J\u0006\u0010\u0010\u001a\u00020\fJ\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/mkui/canvas/CPCanvas$CanvasComponent;", "Ljavax/swing/JPanel;", "<init>", "(Lorg/mkui/canvas/CPCanvas;)V", "dirtyLayers", "", "Lorg/mkui/canvas/SwingLayer;", "timer", "Lcom/macrofocus/common/timer/CPTimer;", "getTimer", "()Lcom/macrofocus/common/timer/CPTimer;", "updateUI", "", "schedulePrepare", "layer", "prepare", "scheduleRender", "paint", "g", "Ljava/awt/Graphics;", "mkui"})
    public final class CanvasComponent
    extends JPanel {
        @NotNull
        private final Set<SwingLayer> dirtyLayers = new HashSet();
        @NotNull
        private final CPTimer timer = CPHelper.Companion.getInstance().createTimer("Canvas$Prepare", 40, true, new CPTimerListener(this){
            final /* synthetic */ CanvasComponent this$0;
            {
                this.this$0 = $receiver;
            }

            public void timerTriggered() {
                CanvasComponent.access$prepare(this.this$0);
            }
        });

        public CanvasComponent() {
            this.setOpaque(false);
            this.addComponentListener(new ComponentListener(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    CPCanvas.this.notifySizeChanged(this.getWidth(), this.getHeight());
                    this.schedulePrepare();
                }

                @Override
                public void componentMoved(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                @Override
                public void componentShown(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                }
            });
            this.addHierarchyListener(arg_0 -> CanvasComponent._init_$lambda$1(CPCanvas.this, this, arg_0));
            this.updateUI();
        }

        @NotNull
        protected final CPTimer getTimer() {
            return this.timer;
        }

        @Override
        public void updateUI() {
            this.setBackground(null);
            super.updateUI();
            CPCanvas.this.updateColorTheme();
        }

        public final void schedulePrepare(@NotNull SwingLayer layer) {
            Intrinsics.checkNotNullParameter((Object)layer, (String)"layer");
            this.dirtyLayers.add(layer);
            if (this.isShowing()) {
                this.timer.restart();
            }
        }

        public final void schedulePrepare() {
            this.scheduleRender();
            for (SwingLayer layer : CPCanvas.this.getLayers()) {
                this.dirtyLayers.add(layer);
            }
            if (this.isShowing()) {
                this.timer.restart();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void prepare() {
            CPCanvas.this.getPrepareTiming().start();
            int width = this.getWidth();
            int height = this.getHeight();
            ArrayList dirtyLayers = null;
            Set<SwingLayer> set = this.dirtyLayers;
            synchronized (set) {
                boolean bl = false;
                dirtyLayers = new ArrayList(this.dirtyLayers);
                this.dirtyLayers.clear();
                Unit unit = Unit.INSTANCE;
            }
            for (SwingLayer layer : (List)dirtyLayers) {
                layer.prepare(width, height);
            }
            CPCanvas.this.getPrepareTiming().stop();
            this.scheduleRender();
        }

        public final void scheduleRender() {
            CPCanvas.this.redraw();
        }

        @Override
        public void paint(@NotNull Graphics g2) {
            Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
            long start = System.currentTimeMillis();
            CPCanvas.this.getRenderTiming().start();
            if (this.isPaintingForPrint()) {
                this.prepare();
            }
            Graphics2D g22 = (Graphics2D)g2;
            g22.setFont(this.getFont());
            for (SwingLayer layer : CPCanvas.this.getLayers()) {
                layer.render(g22);
            }
            CPCanvas.this.getRenderTiming().stop();
            if (((Boolean)CPCanvas.this.getShowTiming().getValue()).booleanValue()) {
                long delta = System.currentTimeMillis() - start;
                long fps = 1L / delta;
                g22.setColor(Color.red);
                int y = this.getHeight();
                g22.drawString("Prepare: " + CPCanvas.this.getPrepareTiming().getLastDuration() + " ms", 5, y -= 12);
                g22.drawString("Render: " + CPCanvas.this.getRenderTiming().getLastDuration() + " ms", 5, y -= 12);
                g22.drawString("Interact: " + CPCanvas.this.getInteractTiming().getLastDuration() + " ms", 5, y -= 12);
            }
        }

        private static final void _init_$lambda$1(CPCanvas this$0, CanvasComponent this$1, HierarchyEvent e) {
            if ((e.getChangeFlags() & 4L) != 0L) {
                this$0.notifySizeChanged(this$1.getWidth(), this$1.getHeight());
                this$1.schedulePrepare();
            }
        }

        public static final /* synthetic */ void access$prepare(CanvasComponent $this) {
            $this.prepare();
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Rendering.values().length];
            try {
                nArray[Rendering.Density.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.AlphaBlended.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.Opaque.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Rendering.Print.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

