/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.canvas;

import androidx.compose.runtime.internal.StabilityInferred;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.Hashtable;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.canvas.AbstractDensityLayer;
import org.mkui.canvas.AntiAliasingBufferedImageOp;
import org.mkui.canvas.PaletteProvider;
import org.mkui.canvas.SwingLayer;
import org.mkui.geom.Rectangle;
import org.mkui.graphics.IDrawing;
import org.mkui.graphics.pressure.Pressure;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0007\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0016\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006J\u0010\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0014\u0010\u0018\u001a\u0004\u0018\u00010\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0011H\u0002J\u0006\u0010\u001a\u001a\u00020\u0013J\u0006\u0010\u001b\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/mkui/canvas/DensitySwingLayer;", "Lorg/mkui/canvas/AbstractDensityLayer;", "Lorg/mkui/canvas/SwingLayer;", "iDrawing", "Lorg/mkui/graphics/IDrawing;", "width", "", "height", "antialiasing", "", "pressure", "Lorg/mkui/graphics/pressure/Pressure;", "palette", "Lorg/mkui/canvas/PaletteProvider;", "<init>", "(Lorg/mkui/graphics/IDrawing;IIZLorg/mkui/graphics/pressure/Pressure;Lorg/mkui/canvas/PaletteProvider;)V", "image", "Ljava/awt/image/BufferedImage;", "prepare", "", "resize", "render", "g", "Ljava/awt/Graphics2D;", "createAntiAliasedImage", "img", "clear", "computeMax", "Companion", "mkui"})
@StabilityInferred(parameters=0)
public final class DensitySwingLayer
extends AbstractDensityLayer
implements SwingLayer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IDrawing iDrawing;
    private final boolean antialiasing;
    @Nullable
    private BufferedImage image;
    @NotNull
    private final Pressure pressure;
    @NotNull
    private final PaletteProvider palette;
    public static final int $stable = 8;
    private static final boolean MULTITHREADED = false;

    public DensitySwingLayer(@NotNull IDrawing iDrawing, int width, int height, boolean antialiasing, @NotNull Pressure pressure, @NotNull PaletteProvider palette) {
        Intrinsics.checkNotNullParameter((Object)iDrawing, (String)"iDrawing");
        Intrinsics.checkNotNullParameter((Object)pressure, (String)"pressure");
        Intrinsics.checkNotNullParameter((Object)palette, (String)"palette");
        this.iDrawing = iDrawing;
        this.antialiasing = antialiasing;
        this.resize(width, height);
        this.pressure = pressure;
        this.palette = palette;
    }

    @Override
    public void prepare(int width, int height) {
        this.resize(width, height);
        if (this.iDrawing.isActive() && width > 0 && height > 0) {
            this.iDrawing.draw(this.getG(), null, width, height, new Rectangle(0, 0, width, height));
            int m = this.computeMax();
            double min = this.pressure.transform(1.0);
            double max = this.pressure.transform(m);
            BufferedImage bufferedImage = this.image;
            Intrinsics.checkNotNull((Object)bufferedImage);
            DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
            Intrinsics.checkNotNull((Object)dataBuffer, (String)"null cannot be cast to non-null type java.awt.image.DataBufferInt");
            int[] nArray = ((DataBufferInt)dataBuffer).getData();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getData(...)");
            int[] pixels = nArray;
            double range = max - min;
            int n = this.getOverlay().length;
            for (int i = 0; i < n; ++i) {
                int v = this.getOverlay()[i];
                if (v > 0) {
                    double value = 0.0;
                    value = this.pressure.transform(v);
                    int color = (int)(value * (double)(this.palette.getPalette().getColorCount() - 1) / range);
                    pixels[i] = this.palette.getPalette().getColorAt(color).getRGB();
                    continue;
                }
                pixels[i] = 0xFFFFFF;
            }
        }
        if (this.antialiasing) {
            this.image = this.createAntiAliasedImage(this.image);
        }
    }

    public final void resize(int width, int height) {
        if ((this.getWidth() != width || this.getHeight() != height) && width > 0 && height > 0) {
            int[] nArray = new int[]{0xFF0000, 65280, 255, -16777216};
            WritableRaster writableRaster = Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, width, height, nArray), new Point(0, 0));
            Intrinsics.checkNotNullExpressionValue((Object)writableRaster, (String)"createWritableRaster(...)");
            WritableRaster ras = writableRaster;
            BufferedImage bufferedImage = new BufferedImage(new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216), ras, false, new Hashtable());
            int[] o = new int[width * height];
            this.setWidth(width);
            this.setHeight(height);
            this.image = bufferedImage;
            this.setOverlay(o);
            this.setCx1(0);
            this.setCy1(0);
            this.setCx2(width - 1);
            this.setCy2(height - 1);
        } else {
            this.clear();
        }
    }

    @Override
    public void render(@NotNull Graphics2D g2) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g");
        if (this.iDrawing.isActive() && this.image != null) {
            g2.drawImage((Image)this.image, 0, 0, null);
        }
    }

    private final BufferedImage createAntiAliasedImage(BufferedImage img) {
        return img != null ? new AntiAliasingBufferedImageOp().filter(img, null) : null;
    }

    public final void clear() {
        if (this.image != null) {
            Arrays.fill(this.getOverlay(), 0);
        }
    }

    public final int computeMax() {
        int max = 0;
        for (int v : this.getOverlay()) {
            if (v <= max) continue;
            max = v;
        }
        return max;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/mkui/canvas/DensitySwingLayer$Companion;", "", "<init>", "()V", "MULTITHREADED", "", "mkui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

